/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.InvalidKeyException;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class Cipher {
    private BufferedBlockCipher cipher;
    private ByteBuf outBuf;

    public Cipher(boolean encipher, BufferedBlockCipher cipher, ByteBuf key, ByteBuf iv) throws InvalidKeyException {
        this.cipher = cipher;
        this.outBuf = Unpooled.buffer();
        this.initialize(encipher, key, iv);
    }

    private void initialize(boolean encipher, ByteBuf key, ByteBuf iv) throws InvalidKeyException {
        KeyParameter params = null;
        byte[] keyBytes = new byte[key.readableBytes()];
        key.readBytes(keyBytes);
        params = new KeyParameter(keyBytes);
        if (iv.readableBytes() > 0) {
            byte[] ivBytes = new byte[iv.readableBytes()];
            iv.readBytes(ivBytes);
            params = new ParametersWithIV((CipherParameters)params, ivBytes);
        }
        this.cipher.init(encipher, (CipherParameters)params);
    }

    public void update(ByteBuf buf) {
        byte[] outBytes = new byte[this.cipher.getUpdateOutputSize(buf.readableBytes())];
        byte[] inBytes = new byte[buf.readableBytes()];
        buf.readBytes(inBytes);
        int len = this.cipher.processBytes(inBytes, 0, inBytes.length, outBytes, 0);
        this.outBuf.writeBytes(outBytes, 0, len);
    }

    public ByteBuf doFinal() throws InvalidCipherTextException {
        byte[] outBytes = new byte[this.cipher.getOutputSize(0)];
        int len = this.cipher.doFinal(outBytes, 0);
        this.outBuf.writeBytes(outBytes, 0, len);
        return this.outBuf;
    }
}

