/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;

public class BigIntegerUtils {
    public static ByteBuf toBuf(BigInteger i) {
        byte[] array = i.toByteArray();
        int byteLen = (int)Math.ceil((double)i.bitLength() / 8.0);
        ByteBuf buf = Unpooled.buffer((int)byteLen);
        buf.writeBytes(array, array.length - byteLen, byteLen);
        return buf;
    }

    public static BigInteger fromBuf(ByteBuf buf) {
        byte[] array = new byte[buf.readableBytes() + 1];
        array[0] = 0;
        buf.getBytes(0, array, 1, buf.readableBytes());
        return new BigInteger(array);
    }
}

