/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.buffer;

import io.netty.buffer.ByteBuf;
import io.nodyn.buffer.NettyExternalIndexedData;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.dynjs.runtime.ExternalIndexedData;
import org.dynjs.runtime.JSObject;

public class Buffer {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Charset ASCII = StandardCharsets.US_ASCII;
    private static final Charset UCS2 = StandardCharsets.UTF_16LE;
    private static final Charset BINARY = StandardCharsets.ISO_8859_1;

    public static void inject(JSObject object, ByteBuf buf) {
        object.setExternalIndexedData((ExternalIndexedData)new NettyExternalIndexedData(buf));
    }

    public static ByteBuf extract(JSObject object) {
        return ((NettyExternalIndexedData)object.getExternalIndexedData()).buffer();
    }

    public static byte[] extractByteArray(JSObject object) {
        ByteBuf buf = Buffer.extract(object);
        byte[] bytes = new byte[Buffer.bufLen(object)];
        buf.getBytes(buf.readerIndex(), bytes);
        return bytes;
    }

    public static int bufLen(JSObject obj) {
        return ((Number)obj.get(null, "length")).intValue();
    }

    public static Object fill(JSObject obj, Object val, int offset, int end) {
        int byteVal = 0;
        if (val instanceof Number) {
            byteVal = ((Number)val).intValue() & 0xFF;
        } else if (val instanceof String && !((String)val).isEmpty()) {
            byteVal = ((String)val).charAt(0);
        }
        ByteBuf b = Buffer.extract(obj);
        for (int i = offset; i < end; ++i) {
            b.setByte(i, byteVal);
        }
        b.writerIndex(Math.max(b.writerIndex(), offset + end));
        return obj;
    }

    public static long copy(JSObject src, JSObject target, int targetStart, int sourceStart, int sourceEnd) {
        ByteBuf srcBuf = Buffer.extract(src);
        ByteBuf targetBuf = Buffer.extract(target);
        int origWriter = targetBuf.writerIndex();
        targetBuf.writerIndex(targetStart);
        int len = sourceEnd - sourceStart;
        len = Math.min(len, Buffer.bufLen(target) - targetStart);
        targetBuf.writeBytes(srcBuf, sourceStart, len);
        targetBuf.writerIndex(Math.max(targetBuf.writerIndex(), origWriter));
        return len;
    }

    public static long[] utf8Write(JSObject object, String str, int offset, int len) {
        ByteBuf b = Buffer.extract(object);
        int origWriter = b.writerIndex();
        byte[] bytes = str.getBytes(UTF8);
        b.writerIndex(offset);
        len = Math.min(bytes.length, Math.min(len, Buffer.bufLen(object) - offset));
        b.writeBytes(bytes, 0, len);
        b.writerIndex(Math.max(b.writerIndex(), origWriter));
        return new long[]{str.length(), len};
    }

    public static String utf8Slice(JSObject object, int start, int end) {
        ByteBuf b = Buffer.extract(object);
        return b.toString(start, end - start, UTF8);
    }

    public static long asciiWrite(JSObject object, String str, int offset, int len) {
        ByteBuf b = Buffer.extract(object);
        int origWriter = b.writerIndex();
        byte[] bytes = str.getBytes(ASCII);
        len = Math.min(bytes.length, Math.min(len, b.writableBytes()));
        b.writeBytes(bytes, 0, len);
        b.writerIndex(Math.max(b.writerIndex(), origWriter));
        return len;
    }

    public static String asciiSlice(JSObject object, int start, int end) {
        ByteBuf b = Buffer.extract(object);
        return b.toString(start, end - start, ASCII);
    }

    public static long ucs2Write(JSObject object, String str, int offset, int len) {
        ByteBuf b = Buffer.extract(object);
        int origWriter = b.writerIndex();
        byte[] bytes = str.getBytes(UCS2);
        len = Math.min(bytes.length, Math.min(len, b.writableBytes()));
        b.writeBytes(bytes, 0, len);
        b.writerIndex(Math.max(b.writerIndex(), origWriter));
        return len;
    }

    public static String ucs2Slice(JSObject object, int start, int end) {
        ByteBuf b = Buffer.extract(object);
        return b.toString(start, end - start, UCS2);
    }

    public static long hexWrite(JSObject object, String str, int offset, int len) {
        ByteBuf b = Buffer.extract(object);
        int origWriter = b.writerIndex();
        byte[] bytes = Hex.decode((String)str);
        b.writerIndex(offset);
        len = Math.min(bytes.length, Math.min(len, b.writableBytes()));
        b.writeBytes(bytes, 0, len);
        b.writerIndex(Math.max(b.writerIndex(), origWriter));
        return len;
    }

    public static String hexSlice(JSObject object, int start, int end) {
        ByteBuf b = Buffer.extract(object);
        byte[] bytes = new byte[end - start];
        b.getBytes(start, bytes);
        return Hex.toHexString((byte[])bytes);
    }

    public static long base64Write(JSObject object, String str, int offset, int len) {
        ByteBuf b = Buffer.extract(object);
        int origWriter = b.writerIndex();
        byte[] bytes = Base64.decode((String)str);
        b.writerIndex(offset);
        len = Math.min(bytes.length, Math.min(len, b.writableBytes()));
        b.writeBytes(bytes, 0, len);
        b.writerIndex(Math.max(b.writerIndex(), origWriter));
        return len;
    }

    public static String base64Slice(JSObject object, int start, int end) {
        ByteBuf b = Buffer.extract(object);
        byte[] bytes = new byte[end - start];
        b.getBytes(start, bytes);
        return Base64.toBase64String((byte[])bytes);
    }

    public static long binaryWrite(JSObject object, String str, int offset, int len) {
        ByteBuf b = Buffer.extract(object);
        int origWriter = b.writerIndex();
        byte[] bytes = str.getBytes(BINARY);
        len = Math.min(bytes.length, Math.min(len, b.writableBytes()));
        b.writeBytes(bytes, 0, len);
        b.writerIndex(Math.max(b.writerIndex(), origWriter));
        return len;
    }

    public static String binarySlice(JSObject object, int start, int end) {
        ByteBuf b = Buffer.extract(object);
        return b.toString(start, end - start, BINARY);
    }

    public static void writeFloatBE(JSObject obj, float value, int offset) {
        Buffer.extract(obj).setFloat(offset, value);
    }

    public static float readFloatBE(JSObject obj, int offset) {
        return Buffer.extract(obj).getFloat(offset);
    }

    public static void writeFloatLE(JSObject obj, float value, int offset) {
        int bits = Float.floatToIntBits(value);
        Buffer.extract(obj).setInt(offset, Integer.reverseBytes(bits));
    }

    public static float readFloatLE(JSObject obj, int offset) {
        int bits = Buffer.extract(obj).getInt(offset);
        return Float.intBitsToFloat(Integer.reverseBytes(bits));
    }

    public static void writeDoubleBE(JSObject obj, double value, int offset) {
        Buffer.extract(obj).setDouble(offset, value);
    }

    public static double readDoubleBE(JSObject obj, int offset) {
        return Buffer.extract(obj).getDouble(offset);
    }

    public static void writeDoubleLE(JSObject obj, double value, int offset) {
        long bits = Double.doubleToLongBits(value);
        Buffer.extract(obj).setLong(offset, Long.reverse(bits));
    }

    public static double readDoubleLE(JSObject obj, int offset) {
        long bits = Buffer.extract(obj).getLong(offset);
        return Double.longBitsToDouble(Long.reverseBytes(bits));
    }
}

