/*
 * Decompiled with CFR 0.152.
 */
package org.op.chess;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.op.chess.ChessBoard;

final class Square
extends JPanel {
    private final int x;
    private final int y;
    private final ChessBoard board;
    private final JLabel jl;
    private boolean mouseIn = false;

    Square(int y, int x, ChessBoard b) {
        this.x = x;
        this.y = y;
        this.board = b;
        if ((x + y) % 2 == 0) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(Color.gray);
        }
        int square = this.board.getSquareSize();
        this.setPreferredSize(new Dimension(square, square));
        this.jl = new JLabel();
        int piece = this.board.getPieceSize();
        this.jl.setPreferredSize(new Dimension(piece, piece));
        this.add(this.jl);
        this.addMouseListener(new SquareMouseListener());
    }

    void setIcon(Icon i) {
        this.jl.setIcon(i);
    }

    Icon getIcon() {
        return this.jl.getIcon();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.mouseIn) {
            g.setColor(Color.blue);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    class SquareMouseListener
    extends MouseAdapter {
        SquareMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            Square.this.mouseIn = true;
            Square.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            Square.this.mouseIn = false;
            Square.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            Square.this.board.selected(Square.this.y, Square.this.x, Square.this.jl.getIcon() == null);
        }
    }
}

