/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.staccato.StaccatoParserContext;
import org.staccato.Subparser;

public class WhitespaceConsumer
implements Subparser {
    private static final Pattern whitespacePattern = Pattern.compile("^\\s+");
    private static WhitespaceConsumer instance;

    public static WhitespaceConsumer getInstance() {
        if (instance == null) {
            instance = new WhitespaceConsumer();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        Matcher m = whitespacePattern.matcher(music);
        return m.find();
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        Matcher m = whitespacePattern.matcher(music);
        return m.find() ? m.end() : 0;
    }
}

