/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.LinkedList;
import java.util.List;
import org.jfugue.parser.Parser;
import org.jfugue.parser.ParserException;
import org.jfugue.pattern.PatternProducer;
import org.staccato.BarLineSubparser;
import org.staccato.BeatTimeSubparser;
import org.staccato.CollectedNotesPreprocessor;
import org.staccato.FunctionPreprocessor;
import org.staccato.FunctionSubparser;
import org.staccato.IVLSubparser;
import org.staccato.InstructionPreprocessor;
import org.staccato.LyricMarkerSubparser;
import org.staccato.MicrotonePreprocessor;
import org.staccato.NoteSubparser;
import org.staccato.ParenSpacesPreprocessor;
import org.staccato.Preprocessor;
import org.staccato.ReplacementMapPreprocessor;
import org.staccato.SignatureSubparser;
import org.staccato.StaccatoMessages;
import org.staccato.StaccatoParserContext;
import org.staccato.Subparser;
import org.staccato.TempoSubparser;
import org.staccato.UppercasePreprocessor;
import org.staccato.functions.ArpeggiatedChordFunction;
import org.staccato.functions.ChannelPressureFunction;
import org.staccato.functions.ControllerFunction;
import org.staccato.functions.DefaultPreprocessorFunction;
import org.staccato.functions.FunctionManager;
import org.staccato.functions.PitchWheelFunction;
import org.staccato.functions.PolyPressureFunction;
import org.staccato.functions.SysexFunction;
import org.staccato.functions.TrillFunction;

public class StaccatoParser
extends Parser {
    private List<Preprocessor> preprocessors;
    private List<Subparser> subparsers;
    private StaccatoParserContext context = new StaccatoParserContext(this);
    private boolean throwExceptionOnUnknownToken = false;

    public StaccatoParser() {
        NoteSubparser.populateContext(this.context);
        TempoSubparser.populateContext(this.context);
        IVLSubparser.populateContext(this.context);
        FunctionManager funMan = FunctionManager.getInstance();
        funMan.addPreprocessorFunction(DefaultPreprocessorFunction.getInstance());
        funMan.addPreprocessorFunction(TrillFunction.getInstance());
        funMan.addPreprocessorFunction(ArpeggiatedChordFunction.getInstance());
        funMan.addSubparserFunction(PitchWheelFunction.getInstance());
        funMan.addSubparserFunction(ControllerFunction.getInstance());
        funMan.addSubparserFunction(ChannelPressureFunction.getInstance());
        funMan.addSubparserFunction(PolyPressureFunction.getInstance());
        funMan.addSubparserFunction(SysexFunction.getInstance());
        this.preprocessors = new LinkedList<Preprocessor>();
        this.preprocessors.add(ReplacementMapPreprocessor.getInstance());
        this.preprocessors.add(InstructionPreprocessor.getInstance());
        this.preprocessors.add(UppercasePreprocessor.getInstance());
        this.preprocessors.add(CollectedNotesPreprocessor.getInstance());
        this.preprocessors.add(ParenSpacesPreprocessor.getInstance());
        this.preprocessors.add(FunctionPreprocessor.getInstance());
        this.preprocessors.add(MicrotonePreprocessor.getInstance());
        this.subparsers = new LinkedList<Subparser>();
        this.subparsers.add(NoteSubparser.getInstance());
        this.subparsers.add(BarLineSubparser.getInstance());
        this.subparsers.add(IVLSubparser.getInstance());
        this.subparsers.add(SignatureSubparser.getInstance());
        this.subparsers.add(TempoSubparser.getInstance());
        this.subparsers.add(BeatTimeSubparser.getInstance());
        this.subparsers.add(LyricMarkerSubparser.getInstance());
        this.subparsers.add(FunctionSubparser.getInstance());
    }

    public void setThrowsExceptionOnUnknownToken(boolean b) {
        this.throwExceptionOnUnknownToken = b;
    }

    public boolean throwsExceptionOnUnknownToken() {
        return this.throwExceptionOnUnknownToken;
    }

    public void parse(PatternProducer patternProducer) {
        this.parse(patternProducer.getPattern().toString());
    }

    public String preprocess(PatternProducer p) {
        return this.preprocess(p.toString());
    }

    public String preprocess(String s) {
        for (Preprocessor pre : this.preprocessors) {
            s = pre.preprocess(s, this.context);
        }
        return s;
    }

    public void parse(String s) {
        String[] strings;
        this.fireBeforeParsingStarts();
        s = this.preprocess(s);
        for (String substring : strings = s.split(" ")) {
            if (substring.isEmpty()) continue;
            boolean matchingSubparserFound = false;
            for (Subparser sub : this.subparsers) {
                if (matchingSubparserFound || !sub.matches(substring)) continue;
                sub.parse(substring, this.context);
                matchingSubparserFound = true;
            }
            if (matchingSubparserFound || !this.throwsExceptionOnUnknownToken()) continue;
            throw new ParserException(StaccatoMessages.NO_PARSER_FOUND, substring);
        }
        this.fireAfterParsingFinished();
    }
}

