/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfugue.parser.ParserException;
import org.jfugue.provider.ChordProvider;
import org.jfugue.provider.KeyProviderFactory;
import org.jfugue.provider.NoteProvider;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Intervals;
import org.jfugue.theory.Note;
import org.staccato.DefaultNoteSettingsManager;
import org.staccato.StaccatoMessages;
import org.staccato.StaccatoParser;
import org.staccato.StaccatoParserContext;
import org.staccato.Subparser;

public class NoteSubparser
implements Subparser,
NoteProvider,
ChordProvider {
    private static NoteSubparser instance;
    private List<Character> charArray = new ArrayList<Character>();
    private Logger logger = Logger.getLogger("org.jfugue");

    public static NoteSubparser getInstance() {
        if (instance == null) {
            instance = new NoteSubparser();
        }
        return instance;
    }

    private NoteSubparser() {
        this.charArray.add(Character.valueOf('C'));
        this.charArray.add(Character.valueOf('D'));
        this.charArray.add(Character.valueOf('E'));
        this.charArray.add(Character.valueOf('F'));
        this.charArray.add(Character.valueOf('G'));
        this.charArray.add(Character.valueOf('A'));
        this.charArray.add(Character.valueOf('B'));
        this.charArray.add(Character.valueOf('R'));
        this.charArray.add(Character.valueOf('['));
        this.charArray.add(Character.valueOf('0'));
        this.charArray.add(Character.valueOf('1'));
        this.charArray.add(Character.valueOf('2'));
        this.charArray.add(Character.valueOf('3'));
        this.charArray.add(Character.valueOf('4'));
        this.charArray.add(Character.valueOf('5'));
        this.charArray.add(Character.valueOf('6'));
        this.charArray.add(Character.valueOf('7'));
        this.charArray.add(Character.valueOf('8'));
        this.charArray.add(Character.valueOf('9'));
        this.logger.setLevel(Level.OFF);
    }

    @Override
    public boolean matches(String music) {
        return this.charArray.contains(Character.valueOf(music.charAt(0)));
    }

    @Override
    public int parse(String s, StaccatoParserContext context) {
        return this.parseNoteElement(s, 0, context);
    }

    private int parseNoteElement(String s, int index, StaccatoParserContext parserContext) {
        boolean repeat = false;
        NoteContext noteContext = new NoteContext();
        do {
            index = this.parseNoteElement(s, index, noteContext, parserContext);
            if (noteContext.isChord) {
                Chord chord = noteContext.createChord(parserContext);
                parserContext.getParser().fireChordParsed(chord);
            } else {
                Note note = noteContext.createNote(parserContext);
                parserContext.getParser().fireNoteParsed(note);
            }
            repeat = noteContext.thereIsAnother;
            noteContext = noteContext.createNextNoteContext();
        } while (repeat);
        return index;
    }

    public int parseNoteElement(String s, int index, NoteContext noteContext, StaccatoParserContext parserContext) {
        this.logger.info("--Parsing note from string " + s);
        s = s.toUpperCase();
        index = this.parseRoot(s, index, noteContext);
        int startInternalInterval = this.parseOctave(s, index, noteContext);
        int startChord = this.parseInternalInterval(s, startInternalInterval, noteContext);
        int startChordInversion = this.parseChord(s, startChord, noteContext);
        if (index == startInternalInterval) {
            this.setDefaultOctave(noteContext);
        }
        this.logger.info("Octave: " + noteContext.octaveNumber);
        this.computeNoteValue(noteContext, parserContext);
        index = this.parseChordInversion(s, startChordInversion, noteContext);
        index = this.parseDuration(s, index, noteContext, parserContext);
        index = this.parseVelocity(s, index, noteContext);
        index = this.parseConnector(s, index, noteContext);
        return index;
    }

    private int parseRoot(String s, int index, NoteContext context) {
        if (s.charAt(index) >= 'A' && s.charAt(index) <= 'G') {
            return this.parseLetterNote(s, index, context);
        }
        if (s.charAt(index) == 'R') {
            return this.parseRest(s, index, context);
        }
        if (s.charAt(index) == '[') {
            return this.parseBracketedNote(s, index, context);
        }
        if (s.charAt(index) >= '0' && s.charAt(index) <= '9') {
            return this.parseNumericNote(s, index, context);
        }
        return 0;
    }

    private int parseLetterNote(String s, int index, NoteContext context) {
        context.isNumericNote = false;
        int originalIndex = index;
        switch (s.charAt(index)) {
            case 'C': {
                context.noteNumber = 0;
                break;
            }
            case 'D': {
                context.noteNumber = (byte)2;
                break;
            }
            case 'E': {
                context.noteNumber = (byte)4;
                break;
            }
            case 'F': {
                context.noteNumber = (byte)5;
                break;
            }
            case 'G': {
                context.noteNumber = (byte)7;
                break;
            }
            case 'A': {
                context.noteNumber = (byte)9;
                break;
            }
            case 'B': {
                context.noteNumber = (byte)11;
                break;
            }
        }
        ++index;
        boolean checkForModifiers = true;
        block14: while (checkForModifiers) {
            if (index < s.length()) {
                switch (s.charAt(index)) {
                    case '#': {
                        ++index;
                        context.noteNumber = (byte)(context.noteNumber + 1);
                        if (context.noteNumber != 12) continue block14;
                        context.noteNumber = 0;
                        ++context.octaveBias;
                        continue block14;
                    }
                    case 'B': {
                        ++index;
                        context.noteNumber = (byte)(context.noteNumber - 1);
                        if (context.noteNumber != -1) continue block14;
                        context.noteNumber = (byte)11;
                        --context.octaveBias;
                        continue block14;
                    }
                    case 'N': {
                        ++index;
                        context.isNatural = true;
                        checkForModifiers = false;
                        continue block14;
                    }
                }
                checkForModifiers = false;
                continue;
            }
            checkForModifiers = false;
        }
        context.originalString = s.substring(originalIndex, index);
        this.logger.info("Note number within an octave (C=0, B=11): " + context.noteNumber + " (with octaveBias = " + context.octaveBias + ")");
        return index;
    }

    private int parseRest(String s, int index, NoteContext context) {
        context.isRest = true;
        this.logger.info("This note is a Rest");
        return index + 1;
    }

    private int parseBracketedNote(String s, int index, NoteContext context) {
        String stringInBrackets;
        int indexOfEndBracket = s.indexOf(93, index);
        context.noteValueAsString = stringInBrackets = s.substring(index + 1, indexOfEndBracket);
        context.isNumericNote = true;
        this.logger.info("This note is a note represented by the dictionary value " + context.noteValueAsString);
        return indexOfEndBracket + 1;
    }

    private int parseNumericNote(String s, int index, NoteContext context) {
        int numCharsInNumber;
        for (numCharsInNumber = 0; numCharsInNumber < s.length() && s.charAt(index + numCharsInNumber) >= '0' && s.charAt(index + numCharsInNumber) <= '9'; ++numCharsInNumber) {
        }
        String numericNoteString = s.substring(index, index + numCharsInNumber);
        context.noteNumber = Byte.parseByte(numericNoteString);
        context.isNumericNote = true;
        this.logger.info("This note is a numeric note with value " + context.noteNumber);
        return index + numCharsInNumber;
    }

    private int parseOctave(String s, int index, NoteContext context) {
        if (context.isRest || context.isNumericNote) {
            return index;
        }
        int possibleOctave1 = 46;
        int possibleOctave2 = 46;
        if (index < s.length()) {
            possibleOctave1 = s.charAt(index);
        }
        if (index + 1 < s.length()) {
            possibleOctave2 = s.charAt(index + 1);
        }
        int definiteOctaveLength = 0;
        if (possibleOctave1 >= 48 && possibleOctave1 <= 57) {
            definiteOctaveLength = 1;
            if (possibleOctave2 == 48) {
                definiteOctaveLength = 2;
            }
            this.logger.info("Octave is " + definiteOctaveLength + " digits long");
            String octaveNumberString = s.substring(index, index + definiteOctaveLength);
            this.logger.info("Octave string value is " + octaveNumberString);
            try {
                context.octaveNumber = Integer.parseInt(octaveNumberString) + context.octaveBias;
            }
            catch (NumberFormatException e) {
                throw new ParserException(StaccatoMessages.OCTAVE_OUT_OF_RANGE, s);
            }
            if (context.octaveNumber > 10) {
                throw new ParserException(StaccatoMessages.OCTAVE_OUT_OF_RANGE, s);
            }
            if (context.octaveNumber < 0) {
                throw new ParserException(StaccatoMessages.OCTAVE_OUT_OF_RANGE, s);
            }
            context.originalString = context.originalString + octaveNumberString;
        }
        return index + definiteOctaveLength;
    }

    private void setDefaultOctave(NoteContext context) {
        this.logger.info("No octave string found, setting default octave");
        context.octaveNumber = context.isChord ? DefaultNoteSettingsManager.getInstance().getDefaultBassOctave() + context.octaveBias : DefaultNoteSettingsManager.getInstance().getDefaultOctave() + context.octaveBias;
    }

    private int parseInternalInterval(String s, int index, NoteContext context) {
        if (context.isRest) {
            return index;
        }
        if (index < s.length() && s.charAt(index) == '\'') {
            int intervalLength = 0;
            if (index + 1 < s.length() && s.charAt(index + 1) >= '0' && s.charAt(index + 1) <= '9') {
                intervalLength = 1;
            }
            if (intervalLength == 1 && index + 2 < s.length() && (s.charAt(index + 2) == '#' || s.charAt(index + 2) == 'B')) {
                intervalLength = 2;
            }
            if (intervalLength == 2 && index + 3 < s.length() && (s.charAt(index + 3) == '#' || s.charAt(index + 3) == 'B')) {
                intervalLength = 3;
            }
            context.internalInterval = Intervals.getHalfsteps(s.substring(index + 1, index + intervalLength + 1));
            return index + intervalLength + 1;
        }
        return index;
    }

    private int parseChord(String s, int index, NoteContext context) {
        String[] chordNames;
        if (context.isRest) {
            return index;
        }
        int lengthOfChordString = 0;
        boolean chordFound = false;
        for (String chordName : chordNames = Chord.getChordNames()) {
            if (chordFound || s.length() < index + chordName.length() || !chordName.equals(s.substring(index, index + chordName.length()))) continue;
            chordFound = true;
            lengthOfChordString = chordName.length();
            context.isChord = true;
            context.intervals = Chord.getIntervals(chordName);
            context.chordName = chordName;
            this.logger.info("Chord: " + chordName + "   Interval Pattern: " + Chord.getIntervals(chordName));
            break;
        }
        return index + lengthOfChordString;
    }

    private int parseChordInversion(String s, int index, NoteContext context) {
        if (!context.isChord) {
            return index;
        }
        int inversionCount = 0;
        boolean bassNote = false;
        int startIndex = index;
        boolean checkForInversion = true;
        block22: while (checkForInversion) {
            if (index < s.length()) {
                switch (s.charAt(index)) {
                    case '^': {
                        ++index;
                        ++inversionCount;
                        continue block22;
                    }
                    case 'C': {
                        ++index;
                        bassNote = true;
                        continue block22;
                    }
                    case 'D': {
                        ++index;
                        bassNote = true;
                        continue block22;
                    }
                    case 'E': {
                        ++index;
                        bassNote = true;
                        continue block22;
                    }
                    case 'F': {
                        ++index;
                        bassNote = true;
                        continue block22;
                    }
                    case 'G': {
                        ++index;
                        bassNote = true;
                        continue block22;
                    }
                    case 'A': {
                        ++index;
                        bassNote = true;
                        continue block22;
                    }
                    case 'B': {
                        ++index;
                        bassNote = true;
                        continue block22;
                    }
                    case '#': {
                        ++index;
                        continue block22;
                    }
                    case '0': {
                        ++index;
                        inversionCount = inversionCount == -1 ? 0 : inversionCount + 10;
                        continue block22;
                    }
                    case '1': {
                        ++index;
                        inversionCount = 1;
                        continue block22;
                    }
                    case '2': {
                        ++index;
                        inversionCount = 2;
                        continue block22;
                    }
                    case '3': {
                        ++index;
                        inversionCount = 3;
                        continue block22;
                    }
                    case '4': {
                        ++index;
                        inversionCount = 4;
                        continue block22;
                    }
                    case '5': {
                        ++index;
                        inversionCount = 5;
                        continue block22;
                    }
                    case '6': {
                        ++index;
                        inversionCount = 6;
                        continue block22;
                    }
                    case '7': {
                        ++index;
                        inversionCount = 7;
                        continue block22;
                    }
                    case '8': {
                        ++index;
                        inversionCount = 8;
                        continue block22;
                    }
                    case '9': {
                        ++index;
                        inversionCount = 9;
                        continue block22;
                    }
                    case '[': {
                        int indexEndBracket = s.indexOf(93, index);
                        context.inversionBassNote = Note.getToneString(Byte.parseByte(s.substring(index + 1, indexEndBracket - 1)));
                        index = indexEndBracket + 1;
                        continue block22;
                    }
                }
                checkForInversion = false;
                continue;
            }
            checkForInversion = false;
        }
        if (bassNote) {
            context.inversionBassNote = context.inversionBassNote = s.substring(startIndex + 1, index);
        } else if (inversionCount > 0) {
            context.inversionCount = inversionCount;
        }
        return index;
    }

    private void computeNoteValue(NoteContext noteContext, StaccatoParserContext parserContext) {
        byte keySig;
        if (noteContext.isRest) {
            return;
        }
        if (parserContext.getKey() != null && (keySig = KeyProviderFactory.getKeyProvider().convertKeyToByte(parserContext.getKey())) != 0 && !noteContext.isNatural) {
            if (keySig <= -1 && noteContext.noteNumber == 11) {
                noteContext.noteNumber = (byte)10;
            }
            if (keySig <= -2 && noteContext.noteNumber == 4) {
                noteContext.noteNumber = (byte)3;
            }
            if (keySig <= -3 && noteContext.noteNumber == 9) {
                noteContext.noteNumber = (byte)8;
            }
            if (keySig <= -4 && noteContext.noteNumber == 2) {
                noteContext.noteNumber = 1;
            }
            if (keySig <= -5 && noteContext.noteNumber == 7) {
                noteContext.noteNumber = (byte)6;
            }
            if (keySig <= -6 && noteContext.noteNumber == 0) {
                noteContext.noteNumber = (byte)11;
                --noteContext.octaveNumber;
            }
            if (keySig <= -7 && noteContext.noteNumber == 5) {
                noteContext.noteNumber = (byte)4;
            }
            if (keySig >= 1 && noteContext.noteNumber == 5) {
                noteContext.noteNumber = (byte)6;
            }
            if (keySig >= 2 && noteContext.noteNumber == 0) {
                noteContext.noteNumber = 1;
            }
            if (keySig >= 3 && noteContext.noteNumber == 7) {
                noteContext.noteNumber = (byte)8;
            }
            if (keySig >= 4 && noteContext.noteNumber == 2) {
                noteContext.noteNumber = (byte)3;
            }
            if (keySig >= 5 && noteContext.noteNumber == 9) {
                noteContext.noteNumber = (byte)10;
            }
            if (keySig >= 6 && noteContext.noteNumber == 4) {
                noteContext.noteNumber = (byte)5;
            }
            if (keySig >= 7 && noteContext.noteNumber == 11) {
                noteContext.noteNumber = 0;
                ++noteContext.octaveNumber;
            }
            this.logger.info("After adjusting for Key Signature, noteNumber=" + noteContext.noteNumber + " octave=" + noteContext.octaveNumber);
        }
        if (!noteContext.isNumericNote) {
            int intNoteNumber = noteContext.octaveNumber * 12 + noteContext.noteNumber + noteContext.internalInterval;
            if (intNoteNumber > 127) {
                throw new ParserException(StaccatoMessages.CALCULATED_NOTE_OUT_OF_RANGE, Integer.toString(intNoteNumber));
            }
            noteContext.noteNumber = (byte)intNoteNumber;
            this.logger.info("Computed note number: " + noteContext.noteNumber);
        }
    }

    private int parseDuration(String s, int index, NoteContext noteContext, StaccatoParserContext parserContext) {
        if (index < s.length()) {
            switch (s.charAt(index)) {
                case '/': {
                    index = this.parseNumericDuration(s, index, noteContext);
                    break;
                }
                case '-': 
                case 'H': 
                case 'I': 
                case 'O': 
                case 'Q': 
                case 'S': 
                case 'T': 
                case 'W': 
                case 'X': {
                    index = this.parseLetterDuration(s, index, noteContext, parserContext);
                    break;
                }
                default: {
                    noteContext.decimalDuration = DefaultNoteSettingsManager.getInstance().getDefaultDuration();
                    noteContext.durationExplicitlySet = false;
                }
            }
            index = this.parseTuplet(s, index, noteContext);
        } else {
            noteContext.decimalDuration = DefaultNoteSettingsManager.getInstance().getDefaultDuration();
            noteContext.durationExplicitlySet = false;
        }
        this.logger.info("Decimal duration is " + noteContext.decimalDuration);
        return index;
    }

    private int parseNumericDuration(String s, int index, NoteContext context) {
        if (s.charAt(++index) == '-') {
            context.isEndOfTie = true;
            ++index;
        }
        context.durationExplicitlySet = true;
        int endingIndex = this.seekToEndOfDecimal(s, index);
        String durationNumberString = s.substring(index, endingIndex);
        context.decimalDuration += Double.parseDouble(durationNumberString);
        this.logger.info("Decimal duration is " + context.decimalDuration);
        index = endingIndex;
        if (index < s.length() && s.charAt(index) == '-') {
            context.isStartOfTie = true;
            ++index;
        }
        return index;
    }

    private int parseQuantityDuration(String s, int index, NoteContext context) {
        int endingIndex = this.seekToEndOfDecimal(s, index);
        String quantityNumberString = s.substring(index, endingIndex);
        context.decimalDuration += (double)(1.0f / (float)context.mostRecentDuration) * (Double.parseDouble(quantityNumberString) - 1.0);
        this.logger.info("Quantity duration calculation: Duration of 1/" + context.mostRecentDuration + " * " + quantityNumberString + " = " + 1.0 / (double)context.mostRecentDuration * Double.parseDouble(quantityNumberString));
        return endingIndex;
    }

    private int seekToEndOfDecimal(String s, int startingIndex) {
        int cursor;
        for (cursor = startingIndex; cursor < s.length() && (s.charAt(cursor) == '.' || s.charAt(cursor) >= '0' && s.charAt(cursor) <= '9'); ++cursor) {
        }
        return cursor;
    }

    private int parseLetterDuration(String s, int index, NoteContext context, StaccatoParserContext parserContext) {
        boolean moreDurationCharsToParse = true;
        boolean isDotted = false;
        while (moreDurationCharsToParse) {
            int durationNumber = 0;
            if (index < s.length()) {
                char durationChar = s.charAt(index);
                switch (durationChar) {
                    case '-': {
                        if (context.decimalDuration == 0.0 && !context.isEndOfTie) {
                            context.isEndOfTie = true;
                            this.logger.info("Note is end of tie");
                            break;
                        }
                        context.isStartOfTie = true;
                        this.logger.info("Note is start of tie");
                        break;
                    }
                    case 'W': {
                        durationNumber = 1;
                        break;
                    }
                    case 'H': {
                        durationNumber = 2;
                        break;
                    }
                    case 'Q': {
                        durationNumber = 4;
                        break;
                    }
                    case 'I': {
                        durationNumber = 8;
                        break;
                    }
                    case 'S': {
                        durationNumber = 16;
                        break;
                    }
                    case 'T': {
                        durationNumber = 32;
                        break;
                    }
                    case 'X': {
                        durationNumber = 64;
                        break;
                    }
                    case 'O': {
                        durationNumber = 128;
                        break;
                    }
                    default: {
                        --index;
                        moreDurationCharsToParse = false;
                    }
                }
                if (++index < s.length() && s.charAt(index) == '.') {
                    isDotted = true;
                    ++index;
                }
                if (durationNumber > 0) {
                    context.durationExplicitlySet = true;
                    double d = 1.0 / (double)durationNumber;
                    context.decimalDuration = isDotted ? (context.decimalDuration += d + d / 2.0) : (context.decimalDuration += d);
                }
                context.mostRecentDuration = durationNumber;
                if (index >= s.length() || s.charAt(index) < '0' || s.charAt(index) > '9') continue;
                index = this.parseQuantityDuration(s, index, context);
                continue;
            }
            moreDurationCharsToParse = false;
        }
        return index;
    }

    private int parseTuplet(String s, int index, NoteContext context) {
        if (index < s.length() && s.charAt(index) == '*') {
            this.logger.info("Note is a tuplet");
            ++index;
            boolean stopTupletParsing = false;
            int indexOfUnitsToMatch = 0;
            int indexOfNumNotes = 0;
            int counter = -1;
            while (!stopTupletParsing) {
                if (s.length() > index + ++counter) {
                    if (s.charAt(index + counter) == ':') {
                        indexOfNumNotes = index + counter + 1;
                        continue;
                    }
                    if (s.charAt(index + counter) >= '0' && s.charAt(index + counter) <= '9') {
                        if (indexOfUnitsToMatch != 0) continue;
                        indexOfUnitsToMatch = index + counter;
                        continue;
                    }
                    if (s.charAt(index + counter) == '*') continue;
                    stopTupletParsing = true;
                    continue;
                }
                stopTupletParsing = true;
            }
            index += counter;
            double numerator = 2.0;
            double denominator = 3.0;
            if (indexOfUnitsToMatch > 0 && indexOfNumNotes > 0) {
                numerator = Double.parseDouble(s.substring(indexOfUnitsToMatch, indexOfNumNotes - 1));
                denominator = Double.parseDouble(s.substring(indexOfNumNotes, index));
            }
            this.logger.info("Tuplet ratio is " + numerator + ":" + denominator);
            double tupletRatio = numerator / denominator;
            context.decimalDuration *= 1.0 / tupletRatio;
            this.logger.info("Decimal duration after tuplet is " + context.decimalDuration);
        }
        return index;
    }

    private int parseVelocity(String s, int index, NoteContext context) {
        if (context.isRest) {
            return index;
        }
        while (index < s.length()) {
            int startPoint;
            int endPoint = startPoint = index + 1;
            char velocityChar = s.charAt(index);
            int lengthOfByte = 0;
            if (velocityChar == '+' || velocityChar == '_' || velocityChar == ' ') break;
            this.logger.info("Identified Velocity character " + velocityChar);
            boolean byteDone = false;
            while (!byteDone && index + lengthOfByte + 1 < s.length()) {
                char possibleByteChar = s.charAt(index + lengthOfByte + 1);
                if (possibleByteChar >= '0' && possibleByteChar <= '9') {
                    ++lengthOfByte;
                    continue;
                }
                byteDone = true;
            }
            endPoint = index + lengthOfByte + 1;
            if (startPoint == endPoint) {
                return endPoint;
            }
            byte velocityNumber = Byte.parseByte(s.substring(startPoint, endPoint));
            String velocityString = null;
            if (index + 1 < s.length() && s.charAt(index + 1) == '[') {
                endPoint = s.indexOf(93, startPoint) + 1;
                velocityString = s.substring(startPoint, endPoint);
            }
            switch (velocityChar) {
                case 'A': {
                    if (velocityString == null) {
                        context.noteOnVelocity = velocityNumber;
                    } else {
                        context.noteOnVelocityValueAsString = velocityString;
                    }
                    context.hasNoteOnVelocity = true;
                    break;
                }
                case 'D': {
                    if (velocityString == null) {
                        context.noteOffVelocity = velocityNumber;
                    } else {
                        context.noteOffVelocityValueAsString = velocityString;
                    }
                    context.hasNoteOffVelocity = true;
                    break;
                }
                default: {
                    throw new ParserException(StaccatoMessages.VELOCITY_CHARACTER_NOT_RECOGNIZED, s.substring(startPoint, endPoint));
                }
            }
            index = endPoint;
        }
        if (context.hasNoteOnVelocity) {
            this.logger.info("Attack velocity = " + context.noteOnVelocity);
        }
        if (context.hasNoteOffVelocity) {
            this.logger.info("Decay velocity = " + context.noteOffVelocity);
        }
        return index;
    }

    private int parseConnector(String s, int index, NoteContext context) {
        context.thereIsAnother = false;
        if (index < s.length() && (s.charAt(index) == '+' || s.charAt(index) == '_')) {
            this.logger.info("Another note: string = " + s.substring(index, s.length() - 1));
            if (s.charAt(index) == '_') {
                context.anotherNoteIsMelodic = true;
                this.logger.info("Next note will be melodic");
            } else {
                context.anotherNoteIsHarmonic = true;
                this.logger.info("Next note will be harmonic");
            }
            ++index;
            context.thereIsAnother = true;
        }
        return index;
    }

    @Override
    public Note createNote(String noteString) {
        StaccatoParserContext parserContext = new StaccatoParserContext(new StaccatoParser());
        NoteContext noteContext = new NoteContext();
        this.parseNoteElement(noteString, 0, noteContext, parserContext);
        return noteContext.createNote(parserContext);
    }

    @Override
    public Note getMiddleC() {
        return this.createNote("C");
    }

    @Override
    public double getDurationForString(String s) {
        NoteContext noteContext = new NoteContext();
        StaccatoParserContext parserContext = new StaccatoParserContext(new StaccatoParser());
        this.parseDuration(s, 0, noteContext, parserContext);
        return noteContext.decimalDuration;
    }

    public static void populateContext(StaccatoParserContext context) {
        for (int i = 0; i < Note.PERCUSSION_NAMES.length; ++i) {
            context.getDictionary().put(Note.PERCUSSION_NAMES[i], (byte)(i + 35));
        }
        for (String key : Chord.chordMap.keySet()) {
            context.getDictionary().put(key, Chord.chordMap.get(key));
        }
    }

    @Override
    public Chord createChord(String chordString) {
        if (chordString.length() <= 2) {
            chordString = chordString + "MAJ";
        }
        StaccatoParserContext parserContext = new StaccatoParserContext(new StaccatoParser());
        NoteContext noteContext = new NoteContext();
        this.parseNoteElement(chordString, 0, noteContext, parserContext);
        return noteContext.createChord(parserContext);
    }

    class NoteContext {
        public String originalString;
        public byte noteNumber;
        public String noteValueAsString;
        public boolean isNumericNote;
        public boolean isChord;
        public String chordName;
        public Intervals intervals;
        public int inversionCount;
        public String inversionBassNote;
        public boolean isRest;
        public boolean isNatural;
        public int octaveBias;
        public int octaveNumber;
        public int internalInterval;
        public double decimalDuration;
        public String durationValueAsString;
        public boolean durationExplicitlySet;
        public int mostRecentDuration;
        public boolean hasIndeterminateDuration;
        public boolean isEndOfTie;
        public boolean isStartOfTie;
        public boolean hasNoteOnVelocity;
        public byte noteOnVelocity;
        public String noteOnVelocityValueAsString;
        public boolean hasNoteOffVelocity;
        public byte noteOffVelocity;
        public String noteOffVelocityValueAsString;
        public boolean isFirstNote = true;
        public boolean isMelodicNote;
        public boolean anotherNoteIsMelodic;
        public boolean isHarmonicNote;
        public boolean anotherNoteIsHarmonic;
        public boolean thereIsAnother;

        public NoteContext createNextNoteContext() {
            NoteContext noteContext = new NoteContext();
            noteContext.isFirstNote = false;
            noteContext.isMelodicNote = this.anotherNoteIsMelodic;
            noteContext.isHarmonicNote = this.anotherNoteIsHarmonic;
            return noteContext;
        }

        public NoteContext createChordNoteContext() {
            NoteContext noteContext = new NoteContext();
            noteContext.isFirstNote = false;
            noteContext.isMelodicNote = false;
            noteContext.isHarmonicNote = true;
            noteContext.decimalDuration = this.decimalDuration;
            return noteContext;
        }

        public Note createNote(StaccatoParserContext parserContext) {
            try {
                if (this.noteValueAsString != null) {
                    this.noteNumber = (Byte)parserContext.getDictionary().get(this.noteValueAsString);
                }
            }
            catch (NullPointerException e) {
                throw new RuntimeException("JFugue NoteSubparser: Could not find '" + this.noteValueAsString + "' in dictionary.");
            }
            try {
                if (this.durationValueAsString != null) {
                    this.decimalDuration = ((Byte)parserContext.getDictionary().get(this.durationValueAsString)).byteValue();
                }
            }
            catch (NullPointerException e) {
                throw new RuntimeException("JFugue NoteSubparser: Could not find '" + this.durationValueAsString + "' in dictionary.");
            }
            Note note = new Note(this.noteNumber);
            if (this.durationExplicitlySet) {
                note.setDuration(this.decimalDuration);
            }
            note.setOriginalString(this.originalString);
            note.setRest(this.isRest);
            if (this.hasNoteOnVelocity) {
                if (this.noteOnVelocityValueAsString != null) {
                    this.noteOnVelocity = (Byte)parserContext.getDictionary().get(this.noteOnVelocityValueAsString);
                }
                note.setOnVelocity(this.noteOnVelocity);
            }
            if (this.hasNoteOffVelocity) {
                if (this.noteOffVelocityValueAsString != null) {
                    this.noteOffVelocity = (Byte)parserContext.getDictionary().get(this.noteOffVelocityValueAsString);
                }
                note.setOffVelocity(this.noteOffVelocity);
            }
            note.setEndOfTie(this.isEndOfTie);
            note.setStartOfTie(this.isStartOfTie);
            note.setFirstNote(this.isFirstNote);
            note.setHarmonicNote(this.isHarmonicNote);
            note.setMelodicNote(this.isMelodicNote);
            return note;
        }

        public Chord createChord(StaccatoParserContext parserContext) {
            if (this.noteValueAsString != null) {
                this.noteNumber = (Byte)parserContext.getDictionary().get(this.noteValueAsString);
            }
            if (this.durationValueAsString != null) {
                this.decimalDuration = ((Byte)parserContext.getDictionary().get(this.durationValueAsString)).byteValue();
            }
            Note rootNote = this.createNote(parserContext);
            if (this.isChord) {
                Chord chord = new Chord(rootNote, this.intervals);
                if (this.inversionBassNote != null) {
                    chord.setBassNote(this.inversionBassNote);
                } else if (this.inversionCount > 0) {
                    chord.setInversion(this.inversionCount);
                }
                return chord;
            }
            return null;
        }
    }
}

