/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.staccato.DefaultNoteSettingsManager;
import org.staccato.Preprocessor;
import org.staccato.StaccatoParserContext;

public class MicrotonePreprocessor
implements Preprocessor {
    private static MicrotonePreprocessor instance;
    private static Pattern microtonePattern;
    private static Pattern frequencyPattern;
    private static Pattern qualifierPattern;

    public static MicrotonePreprocessor getInstance() {
        if (instance == null) {
            instance = new MicrotonePreprocessor();
        }
        return instance;
    }

    @Override
    public String preprocess(String s, StaccatoParserContext context) {
        StringBuilder buddy = new StringBuilder();
        int posPrev = 0;
        Matcher m = microtonePattern.matcher(s);
        while (m.find()) {
            buddy.append(s, posPrev, m.start());
            double frequency = 0.0;
            Matcher frequencyMatcher = frequencyPattern.matcher(m.group());
            if (!frequencyMatcher.find()) {
                throw new IllegalArgumentException("The following is not a valid microtone frequency: " + frequencyMatcher.group());
            }
            frequency = Double.parseDouble(frequencyMatcher.group());
            String qualifier = null;
            Matcher qualifierMatcher = qualifierPattern.matcher(m.group());
            if (qualifierMatcher.find()) {
                qualifier = qualifierMatcher.group();
            }
            if (qualifier == null) {
                qualifier = "/" + DefaultNoteSettingsManager.getInstance().getDefaultDuration();
            }
            buddy.append(" ");
            buddy.append(MicrotonePreprocessor.convertFrequencyToStaccato(frequency, qualifier));
            posPrev = m.end();
        }
        buddy.append(s.substring(posPrev, s.length()));
        return buddy.toString().trim();
    }

    public static String convertFrequencyToStaccato(double frequency, String qualifier) {
        double totalCents = 1200.0 * Math.log(frequency / 16.3515978312876) / Math.log(2.0);
        double octave = Math.round(totalCents / 1200.0);
        double semitoneCents = totalCents - octave * 1200.0;
        double semitone = Math.round(semitoneCents / 100.0);
        double microtonalAdjustment = semitoneCents - semitone * 100.0;
        double pitches = 8192.0 + microtonalAdjustment * 8192.0 / 100.0;
        double note = (octave + 1.0) * 12.0 + semitone;
        if (note > 127.0) {
            note = 127.0;
        }
        StringBuilder buddy = new StringBuilder();
        buddy.append(":PitchWheel(");
        buddy.append((int)pitches);
        buddy.append(") ");
        buddy.append((int)note);
        buddy.append(qualifier);
        buddy.append(" :PitchWheel(8192)");
        return buddy.toString();
    }

    static {
        microtonePattern = Pattern.compile("(^|\\s)[Mm]\\S+");
        frequencyPattern = Pattern.compile("[0-9.]+");
        qualifierPattern = Pattern.compile("[WHQISTXOADwhqistxoad/]+[0-9.]*\\S*");
    }
}

