/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.midi.MidiDictionary;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;

public class IVLSubparser
implements Subparser {
    public static final char INSTRUMENT = 'I';
    public static final char LAYER = 'L';
    public static final char VOICE = 'V';
    private static IVLSubparser instance;

    public static IVLSubparser getInstance() {
        if (instance == null) {
            instance = new IVLSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return music.charAt(0) == 'V' || music.charAt(0) == 'I' || music.charAt(0) == 'L';
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (this.matches(music)) {
            int posNextSpace = StaccatoUtil.findNextOrEnd(music, ' ', 0);
            byte value = -1;
            if (posNextSpace > 1) {
                String instrumentId = music.substring(1, posNextSpace);
                if (instrumentId.matches("\\d+")) {
                    value = Byte.parseByte(instrumentId);
                } else {
                    if (instrumentId.charAt(0) == '[') {
                        instrumentId = instrumentId.substring(1, instrumentId.length() - 1);
                    }
                    value = (Byte)context.getDictionary().get(instrumentId);
                }
            }
            switch (music.charAt(0)) {
                case 'I': {
                    context.getParser().fireInstrumentParsed(value);
                    break;
                }
                case 'L': {
                    context.getParser().fireLayerChanged(value);
                    break;
                }
                case 'V': {
                    context.getParser().fireTrackChanged(value);
                    break;
                }
            }
            return posNextSpace + 1;
        }
        return 0;
    }

    public static void populateContext(StaccatoParserContext context) {
        context.getDictionary().put("PERCUSSION", (byte)9);
        context.getDictionary().putAll(MidiDictionary.INSTRUMENT_STRING_TO_BYTE);
    }
}

