/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import org.jfugue.midi.MidiFileManager;
import org.jfugue.parser.ParserListener;
import org.jfugue.pattern.Pattern;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Key;
import org.jfugue.theory.Note;
import org.staccato.StaccatoParser;

public class GetPatternStats {
    private List<Number> pitches = new ArrayList<Number>();
    private List<Number> intervals = new ArrayList<Number>();
    private List<Number> degreeNonDiatonic = new ArrayList<Number>();
    private List<Number> interOI = new ArrayList<Number>();
    private List<Number> durations = new ArrayList<Number>();
    private List<Number> restDurations = new ArrayList<Number>();
    private List<Byte> attacks = new ArrayList<Byte>();
    private List<Byte> decays = new ArrayList<Byte>();
    private List<TimeEvent> musicEvents = new ArrayList<TimeEvent>();
    private int rhythm;
    private int measures = 0;
    private double tickPos = 0.0;
    private Key key = new Key("Cmaj");

    public void parsePattern(Pattern pattern, Boolean clear) {
        this.tickPos = 0.0;
        if (clear.booleanValue()) {
            this.clearLists();
        }
        StaccatoParser sp = new StaccatoParser();
        Listener l = new Listener();
        sp.addParserListener(l);
        sp.parse(pattern.toString());
        this.processEvents();
    }

    public void parsePattern(File midiFile, Boolean clear) throws IOException, InvalidMidiDataException {
        Pattern midiPattern = new Pattern();
        String ext = midiFile.getName().substring(midiFile.getName().lastIndexOf(".") + 1, midiFile.getName().length());
        if (ext.equalsIgnoreCase("mid")) {
            Pattern fromMidi = MidiFileManager.loadPatternFromMidi(midiFile);
            midiPattern.add(fromMidi.toString());
        }
        this.parsePattern(midiPattern, clear);
    }

    private void clearLists() {
        this.pitches.clear();
        this.intervals.clear();
        this.degreeNonDiatonic.clear();
        this.interOI.clear();
        this.durations.clear();
        this.restDurations.clear();
        this.attacks.clear();
        this.decays.clear();
        this.musicEvents.clear();
        this.measures = 0;
        this.rhythm = 0;
    }

    public double comparePatterns(Pattern p1, Pattern p2) {
        ArrayList<Number> difference = new ArrayList<Number>();
        GetPatternStats pa1 = new GetPatternStats();
        GetPatternStats pa2 = new GetPatternStats();
        pa1.parsePattern(p1, (Boolean)true);
        pa2.parsePattern(p2, (Boolean)true);
        difference.add(pa1.getGeneralStats()[0] - pa2.getGeneralStats()[0]);
        difference.add(pa1.getGeneralStats()[1] - pa2.getGeneralStats()[1]);
        difference.add(pa1.getGeneralStats()[2] - pa2.getGeneralStats()[2]);
        this.findDifference(pa1.pitches, pa2.pitches, this.pitches);
        difference.add(pa1.getPitchStats().average - pa2.getPitchStats().average);
        difference.add(pa1.getPitchStats().sd - pa2.getPitchStats().sd);
        this.findDifference(pa1.durations, pa2.durations, this.durations);
        difference.add(pa1.getDurationStats().average - pa2.getDurationStats().average);
        difference.add(pa1.getDurationStats().sd - pa2.getDurationStats().sd);
        this.findDifference(pa1.restDurations, pa2.restDurations, this.restDurations);
        difference.add(pa1.getRestStats().average - pa2.getRestStats().average);
        difference.add(pa1.getRestStats().sd - pa2.getRestStats().sd);
        this.findDifference(pa1.intervals, pa2.intervals, this.intervals);
        difference.add(pa1.getIntervalStats().average - pa2.getIntervalStats().average);
        difference.add(pa1.getIntervalStats().sd - pa2.getIntervalStats().sd);
        this.findDifference(pa1.interOI, pa2.interOI, this.interOI);
        difference.add(pa1.getIOIStats().average - pa2.getIOIStats().average);
        difference.add(pa1.getIOIStats().sd - pa2.getIOIStats().sd);
        this.findDifference(pa1.degreeNonDiatonic, pa2.degreeNonDiatonic, this.degreeNonDiatonic);
        difference.add(pa1.getHarmonicStats().average - pa2.getHarmonicStats().average);
        difference.add(pa1.getHarmonicStats().sd - pa2.getHarmonicStats().sd);
        this.rhythm = Math.abs(pa1.getRhythmStats() - pa2.getRhythmStats());
        difference.add(pa1.getRhythmStats() - pa2.getRhythmStats());
        return Math.abs(this.computeAverage(difference));
    }

    private void findDifference(List<Number> p1, List<Number> p2, List<Number> thisList) {
        block3: {
            block5: {
                block4: {
                    if (!p1.isEmpty()) break block4;
                    if (p2.isEmpty()) break block3;
                    for (Number num : p2) {
                        thisList.add(num.doubleValue());
                    }
                    break block3;
                }
                if (!p2.isEmpty()) break block5;
                if (p1.isEmpty()) break block3;
                for (Number num : p1) {
                    thisList.add(num.doubleValue());
                }
                break block3;
            }
            int count = 0;
            for (Number num : p2) {
                thisList.add(num.doubleValue() - p1.get(count).doubleValue());
                if (++count <= p1.size() - 1) continue;
                break;
            }
        }
    }

    public int[] getGeneralStats() {
        return new int[]{this.durations.size(), this.restDurations.size(), this.measures};
    }

    public Stats getPitchStats() {
        return new Stats((List)this.pitches);
    }

    public Stats getDurationStats() {
        return new Stats((List)this.durations);
    }

    public Stats getRestStats() {
        return new Stats((List)this.restDurations);
    }

    public Stats getIntervalStats() {
        return new Stats((List)this.intervals);
    }

    public Stats getIOIStats() {
        return new Stats((List)this.interOI);
    }

    public int getRhythmStats() {
        return this.rhythm;
    }

    public Stats getHarmonicStats() {
        return new Stats((List)this.degreeNonDiatonic);
    }

    private void sortTimeEvents() {
        Collections.sort(this.musicEvents, new Comparator<TimeEvent>(){

            @Override
            public int compare(TimeEvent eg1, TimeEvent eg2) {
                if (eg1.time < eg2.time) {
                    return -1;
                }
                if (eg1.time > eg2.time) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private boolean checkHarmonics(Note note) {
        ArrayList<List<Integer>> majors = new ArrayList<List<Integer>>();
        ArrayList<List<Integer>> minors = new ArrayList<List<Integer>>();
        majors.add(Arrays.asList(0, 2, 4, 5, 7, 9, 11));
        majors.add(Arrays.asList(1, 3, 5, 5, 8, 10, 0));
        majors.add(Arrays.asList(2, 4, 6, 7, 9, 11, 1));
        majors.add(Arrays.asList(3, 4, 7, 8, 10, 0, 2));
        majors.add(Arrays.asList(4, 6, 8, 9, 11, 1, 3));
        majors.add(Arrays.asList(5, 7, 9, 10, 0, 1, 4));
        majors.add(Arrays.asList(6, 8, 10, 11, 1, 3, 5));
        majors.add(Arrays.asList(7, 9, 11, 0, 2, 4, 6));
        majors.add(Arrays.asList(8, 10, 0, 1, 3, 5, 7));
        majors.add(Arrays.asList(9, 11, 1, 2, 4, 6, 8));
        majors.add(Arrays.asList(10, 0, 2, 3, 5, 7, 9));
        majors.add(Arrays.asList(11, 1, 3, 4, 6, 8, 10));
        minors.add(Arrays.asList(3, 4, 7, 8, 10, 0, 2));
        minors.add(Arrays.asList(4, 6, 8, 9, 11, 1, 3));
        minors.add(Arrays.asList(5, 7, 9, 10, 0, 1, 4));
        minors.add(Arrays.asList(6, 8, 10, 11, 1, 3, 5));
        minors.add(Arrays.asList(7, 9, 11, 0, 2, 4, 6));
        minors.add(Arrays.asList(8, 10, 0, 1, 3, 5, 7));
        minors.add(Arrays.asList(9, 11, 1, 2, 4, 6, 8));
        minors.add(Arrays.asList(10, 0, 2, 3, 5, 7, 9));
        minors.add(Arrays.asList(11, 1, 3, 4, 6, 8, 10));
        minors.add(Arrays.asList(0, 2, 4, 5, 7, 9, 11));
        minors.add(Arrays.asList(1, 3, 5, 5, 8, 10, 0));
        minors.add(Arrays.asList(2, 4, 6, 7, 9, 11, 1));
        List keyScale = this.key.getScale().getMajorOrMinorIndicator() == 0 ? (List)majors.get(this.reduceValue(this.key.getRoot().getValue())) : (List)minors.get(this.reduceValue(this.key.getRoot().getValue()));
        return !keyScale.contains(this.reduceValue(note.getValue()));
    }

    private int reduceValue(int v) {
        return v % 12;
    }

    private void checkDegree(Number n) {
        Integer rootValue = this.reduceValue(this.key.getRoot().getValue());
        int noteValue = n.intValue();
        if (noteValue < rootValue) {
            noteValue += 12;
        }
        int difference = noteValue - rootValue;
        switch (difference) {
            case 0: 
            case 1: {
                this.degreeNonDiatonic.add(0);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.degreeNonDiatonic.add(1);
                break;
            }
            case 5: 
            case 6: {
                this.degreeNonDiatonic.add(2);
                break;
            }
            case 7: 
            case 8: {
                this.degreeNonDiatonic.add(3);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.degreeNonDiatonic.add(4);
                break;
            }
        }
    }

    private void processEvents() {
        Note note;
        this.sortTimeEvents();
        double lastTime = 0.0;
        double ioi = 0.0;
        int ticks = 0;
        byte interval = 60;
        this.sortTimeEvents();
        for (TimeEvent t : this.musicEvents) {
            if (!(t.getEvent() instanceof Note) && !(t.getEvent() instanceof Chord)) continue;
            note = (Note)t.getEvent();
            interval = note.getValue();
            lastTime = t.time;
            this.durations.add(note.getDuration());
            ioi = (int)this.convertDecimalToTicks(note.getDuration());
            break;
        }
        for (TimeEvent t : this.musicEvents) {
            if (t.getEvent() instanceof Note || t.getEvent() instanceof Chord) {
                if (t.getEvent() instanceof Chord) {
                    Chord c = (Chord)t.getEvent();
                    note = c.getRoot();
                } else {
                    note = (Note)t.getEvent();
                }
                int noteTicks = (int)this.convertDecimalToTicks(note.getDuration());
                if (!note.isRest()) {
                    this.pitches.add(note.getValue());
                    this.attacks.add(note.getOnVelocity());
                    this.decays.add(note.getOffVelocity());
                    if (this.checkHarmonics(note)) {
                        this.checkDegree(this.reduceValue(note.getValue()));
                    }
                    if (ticks % 128 > 15 && ticks % 128 < 112 && noteTicks > 142 - ticks % 128) {
                        ++this.rhythm;
                    }
                    ticks += noteTicks;
                    interval = (byte)Math.abs(note.getValue() - interval);
                    this.intervals.add(interval);
                    interval = note.getValue();
                    if (lastTime != t.time) {
                        this.durations.add(note.getDuration());
                        this.interOI.add(ioi);
                        ioi = noteTicks;
                    }
                    lastTime = t.time;
                    continue;
                }
                ioi += (double)noteTicks;
                ticks += noteTicks;
                lastTime = t.time;
                if (!(note.getDuration() > 0.0615)) continue;
                this.restDurations.add(note.getDuration());
                continue;
            }
            if (!(t.getEvent() instanceof Key)) continue;
            this.key = (Key)t.getEvent();
        }
        if (this.intervals.size() > 0) {
            this.intervals.remove(0);
        }
    }

    private long convertBeatsToTicks(double time) {
        long durationInTicks = (long)(time * 512.0);
        return durationInTicks;
    }

    private double convertDecimalToTicks(double decimalDuration) {
        double wholeNoteinTicks = 512.0;
        return decimalDuration * wholeNoteinTicks;
    }

    private double calcAverage(List<Number> list) {
        if (this.calcN(list) == 0) {
            return 0.0;
        }
        Double total = 0.0;
        Double min = list.get(0).doubleValue();
        for (Number n : list) {
            Double d = n.doubleValue();
            total = total + d;
            if (!(min > d)) continue;
            min = d;
        }
        Double average = total / (double)list.size() - min;
        return average;
    }

    private double calcSD(List<Number> list) {
        if (this.calcN(list) == 0) {
            return 0.0;
        }
        ArrayList<Number> squares = new ArrayList<Number>();
        double average = this.computeAverage(list);
        for (Number n : list) {
            squares.add(Math.pow(n.doubleValue() - average, 2.0));
        }
        average = Math.sqrt(this.computeAverage(squares));
        return average;
    }

    private double calcRange(List<Number> list) {
        if (this.calcN(list) == 0) {
            return 0.0;
        }
        Double max = list.get(0).doubleValue();
        Double min = list.get(0).doubleValue();
        for (Number n : list) {
            double d = n.doubleValue();
            if (min > d) {
                min = d;
            }
            if (!(max < d)) continue;
            max = d;
        }
        Double range = max - min;
        return range;
    }

    private int calcN(List<Number> list) {
        int n = list.size();
        return n;
    }

    private double computeAverage(List<Number> list) {
        Double total = 0.0;
        for (Number n : list) {
            total = total + n.doubleValue();
        }
        double average = total / (double)list.size();
        return average;
    }

    public String toString() {
        int[] general = this.getGeneralStats();
        Stats duration = this.getDurationStats();
        Stats pitch = this.getPitchStats();
        Stats ioi = this.getIOIStats();
        Stats interval = this.getIntervalStats();
        Stats silence = this.getRestStats();
        Stats harmonics = this.getHarmonicStats();
        return "General Stats: \n Notes =  " + general[0] + "\n Silences =  " + general[1] + "\nInterval Stats: n  =  " + interval.getN() + " \n Average  =  " + interval.getAverage() + "\n Range  =  " + interval.getRange() + "\n SD  =  " + interval.getSD() + "\nIOI Stats: n  =  " + ioi.getN() + "\n Average  =  " + ioi.getAverage() + "\n Range  =  " + ioi.getRange() + "\n SD = " + ioi.getSD() + "\nDuration Stats: n  =  " + duration.getN() + "\n Average  =  " + duration.getAverage() + "\n Range  =  " + duration.getRange() + "\n SD = " + duration.getSD() + "\nPitch Stats: n  =  " + pitch.getN() + "\n Average  =  " + pitch.getAverage() + "\n Range  =  " + pitch.getRange() + "\n SD = " + pitch.getSD() + "\nSilence Stats: n  =  " + silence.getN() + "\n Average  =  " + silence.getAverage() + "\n Range  =  " + silence.getRange() + "\n SD = " + silence.getSD() + "\nHarmonic Stats: n  =  " + harmonics.getN() + "\n Average  =  " + harmonics.getAverage() + "\n Range  =  " + harmonics.getRange() + "\n SD = " + silence.getSD() + "\nRythm Stats: n = " + this.getRhythmStats();
    }

    private class Listener
    implements ParserListener {
        private Listener() {
        }

        @Override
        public void beforeParsingStarts() {
        }

        @Override
        public void afterParsingFinished() {
        }

        @Override
        public void onTrackChanged(byte t) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, t));
        }

        @Override
        public void onLayerChanged(byte layerNum) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, layerNum));
            GetPatternStats.this.tickPos = 0.0;
        }

        @Override
        public void onInstrumentParsed(byte i) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, i));
        }

        @Override
        public void onTempoChanged(int tBPM) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, tBPM));
        }

        @Override
        public void onKeySignatureParsed(byte keyB, byte scale) {
            String maj = "maj";
            String min = "min";
            Key k = scale == 0 ? new Key(new Note(keyB).toString() + maj) : new Key(new Note(keyB).toString() + min);
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, k));
        }

        @Override
        public void onTimeSignatureParsed(byte bDuration, byte bNumber) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, new Byte[]{bDuration, bNumber}));
        }

        @Override
        public void onBarLineParsed(long m) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, m));
            ++GetPatternStats.this.measures;
        }

        @Override
        public void onTrackBeatTimeBookmarked(String string) {
        }

        @Override
        public void onTrackBeatTimeBookmarkRequested(String string) {
        }

        @Override
        public void onTrackBeatTimeRequested(double beats) {
            GetPatternStats.this.tickPos = GetPatternStats.this.convertBeatsToTicks(beats);
        }

        @Override
        public void onPitchWheelParsed(byte b, byte b1) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, new Byte[]{b, b1}));
        }

        @Override
        public void onChannelPressureParsed(byte b) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, b));
        }

        @Override
        public void onPolyphonicPressureParsed(byte b, byte b1) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, new Byte[]{b, b1}));
        }

        @Override
        public void onSystemExclusiveParsed(byte ... bytes) {
        }

        @Override
        public void onControllerEventParsed(byte b, byte b1) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, new Byte[]{b, b1}));
        }

        @Override
        public void onLyricParsed(String lyric) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, lyric));
        }

        @Override
        public void onMarkerParsed(String string) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, string));
        }

        @Override
        public void onFunctionParsed(String string, Object o) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, o));
        }

        @Override
        public void onNoteParsed(Note note) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, note));
            GetPatternStats.this.tickPos = GetPatternStats.this.tickPos + GetPatternStats.this.convertDecimalToTicks(note.getDuration());
        }

        @Override
        public void onChordParsed(Chord chord) {
            GetPatternStats.this.musicEvents.add(new TimeEvent(GetPatternStats.this.tickPos, chord));
            GetPatternStats.this.tickPos = GetPatternStats.this.tickPos + GetPatternStats.this.convertDecimalToTicks(chord.getRoot().getDuration());
        }
    }

    public final class Stats {
        private int n;
        private double range;
        private double sd;
        private double average;

        private Stats(List<Number> list) {
            this.n = GetPatternStats.this.calcN(list);
            this.range = GetPatternStats.this.calcRange(list);
            this.sd = GetPatternStats.this.calcSD(list);
            this.average = GetPatternStats.this.calcAverage(list);
        }

        private Stats(List<Number> list1, List<Number> list2) {
            this.n = GetPatternStats.this.calcN(list1);
            this.range = GetPatternStats.this.calcRange(list1);
            this.sd = GetPatternStats.this.calcSD(list1);
            this.average = GetPatternStats.this.calcAverage(list2);
        }

        public int getN() {
            return this.n;
        }

        public double getRange() {
            return this.range;
        }

        public double getSD() {
            return this.sd;
        }

        public double getAverage() {
            return this.average;
        }
    }

    private class TimeEvent<T> {
        double time;
        T eventValue;

        private TimeEvent(double ticks, T event) {
            this.time = ticks;
            this.eventValue = event;
        }

        private T getEvent() {
            return this.eventValue;
        }
    }
}

