/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.theory;

import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.provider.KeyProviderFactory;
import org.jfugue.provider.NoteProviderFactory;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Intervals;
import org.jfugue.theory.Key;
import org.jfugue.theory.Note;
import org.staccato.StaccatoUtil;

public class ChordProgression
implements PatternProducer {
    private String[] progressionElements;
    private Chord[] knownChords = null;
    private Key key;
    private String allSequence;
    private String eachSequence;

    private ChordProgression() {
    }

    public ChordProgression(String progression) {
        this.createProgression(progression.split("[- ]"));
    }

    public ChordProgression(String[] progressionElements) {
        this.createProgression(progressionElements);
    }

    private void createProgression(String[] progressionElements) {
        this.progressionElements = progressionElements;
        this.key = Key.DEFAULT_KEY;
    }

    public static ChordProgression fromChords(String knownChords) {
        String[] knownChordStrings = knownChords.split(" +");
        ChordProgression cp = new ChordProgression();
        cp.knownChords = new Chord[knownChordStrings.length];
        for (int i = 0; i < knownChordStrings.length; ++i) {
            cp.knownChords[i] = new Chord(knownChordStrings[i]);
        }
        return cp;
    }

    public static ChordProgression fromChords(Chord ... chords) {
        ChordProgression cp = new ChordProgression();
        cp.knownChords = chords;
        return cp;
    }

    public ChordProgression setKey(String key) {
        return this.setKey(KeyProviderFactory.getKeyProvider().createKey(key));
    }

    public ChordProgression setKey(Key key) {
        this.key = key;
        return this;
    }

    @Override
    public Pattern getPattern() {
        Pattern pattern = new Pattern();
        for (Chord chord : this.getChords()) {
            pattern.add(chord);
        }
        if (this.allSequence != null) {
            pattern = this.replaceDollarsWithCandidates(this.allSequence, this.getChords(), new Pattern(this.getChords()));
        }
        if (this.eachSequence != null) {
            Pattern p2 = new Pattern();
            for (String chordString : pattern.toString().split(" ")) {
                Chord chord = new Chord(chordString);
                p2.add(this.replaceDollarsWithCandidates(this.eachSequence, chord.getNotes(), chord));
            }
            pattern = p2;
        }
        return pattern;
    }

    public Chord[] getChords() {
        if (this.knownChords != null) {
            return this.knownChords;
        }
        Chord[] chords = new Chord[this.progressionElements.length];
        Pattern scalePattern = this.key.getScale().getIntervals().setRoot(this.key.getRoot()).getPattern();
        String[] scaleNotes = scalePattern.toString().split(" ");
        int counter = 0;
        for (String progressionElement : this.progressionElements) {
            Note rootNote = NoteProviderFactory.getNoteProvider().createNote(scaleNotes[this.romanNumeralToIndex(progressionElement)]);
            rootNote.useSameDurationAs(this.key.getRoot());
            Intervals intervals = Chord.MAJOR_INTERVALS;
            if (progressionElement.charAt(0) == 'i' || progressionElement.charAt(0) == 'v') {
                intervals = Chord.MINOR_INTERVALS;
            }
            if (progressionElement.toLowerCase().indexOf("o") > 0 || progressionElement.toLowerCase().indexOf("d") > 0) {
                intervals = Chord.DIMINISHED_INTERVALS;
            }
            if (progressionElement.endsWith("7")) {
                if (intervals.equals(Chord.MAJOR_INTERVALS)) {
                    intervals = Chord.MAJOR_SEVENTH_INTERVALS;
                } else if (intervals.equals(Chord.MINOR_INTERVALS)) {
                    intervals = Chord.MINOR_SEVENTH_INTERVALS;
                } else if (intervals.equals(Chord.DIMINISHED_INTERVALS)) {
                    intervals = Chord.DIMINISHED_SEVENTH_INTERVALS;
                }
            }
            if (progressionElement.endsWith("7%6")) {
                if (intervals.equals(Chord.MAJOR_INTERVALS)) {
                    intervals = Chord.MAJOR_SEVENTH_SIXTH_INTERVALS;
                } else if (intervals.equals(Chord.MINOR_INTERVALS)) {
                    intervals = Chord.MINOR_SEVENTH_SIXTH_INTERVALS;
                }
            }
            chords[counter] = new Chord(rootNote, intervals);
            ++counter;
        }
        return chords;
    }

    private int romanNumeralToIndex(String romanNumeral) {
        String s = romanNumeral.toLowerCase();
        if (s.endsWith("o") || s.endsWith("d") || s.endsWith("7")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.endsWith("7%6")) {
            s = s.substring(0, s.length() - 3);
        }
        if (s.equals("i")) {
            return 0;
        }
        if (s.equals("ii")) {
            return 1;
        }
        if (s.equals("iii")) {
            return 2;
        }
        if (s.equals("iv")) {
            return 3;
        }
        if (s.equals("v")) {
            return 4;
        }
        if (s.equals("vi")) {
            return 5;
        }
        if (s.equals("vii")) {
            return 6;
        }
        return 0;
    }

    public String toString() {
        return this.getPattern().toString();
    }

    public String[] toStringArray() {
        return this.getPattern().toString().split(" ");
    }

    private Pattern replaceDollarsWithCandidates(String sequence, PatternProducer[] candidates, PatternProducer underscoreReplacement) {
        StringBuilder buddy = new StringBuilder();
        int posPrevDollar = -1;
        int posNextDollar = 0;
        while (posNextDollar < sequence.length()) {
            posNextDollar = StaccatoUtil.findNextOrEnd(sequence, '$', posPrevDollar);
            if (posPrevDollar + 1 < sequence.length()) {
                buddy.append(sequence.substring(posPrevDollar + 1, posNextDollar));
            }
            if (posNextDollar != sequence.length()) {
                String selectionString = sequence.substring(posNextDollar + 1, posNextDollar + 2);
                if (selectionString.equals("_")) {
                    String[] replacementTokens = underscoreReplacement.getPattern().toString().split(" ");
                    int nextSpaceInSequence = StaccatoUtil.findNextOrEnd(sequence, ' ', posNextDollar);
                    for (String token : replacementTokens) {
                        buddy.append(token);
                        buddy.append(sequence.substring(posNextDollar + 2, nextSpaceInSequence));
                        buddy.append(" ");
                    }
                    posNextDollar = nextSpaceInSequence - 1;
                } else {
                    int selection = Integer.parseInt(sequence.substring(posNextDollar + 1, posNextDollar + 2));
                    if (selection > candidates.length) {
                        throw new IllegalArgumentException("The selector $" + selection + " is greater than the number of items to choose from, which has " + candidates.length + " items.");
                    }
                    buddy.append(candidates[selection].getPattern());
                }
            }
            posPrevDollar = posNextDollar + 1;
        }
        return new Pattern(buddy.toString().trim());
    }

    public ChordProgression eachChordAs(String sequence) {
        this.eachSequence = sequence;
        return this;
    }

    public ChordProgression allChordsAs(String sequence) {
        this.allSequence = sequence;
        return this;
    }

    public ChordProgression distribute(String distribute) {
        for (int i = 0; i < this.progressionElements.length; ++i) {
            this.progressionElements[i] = this.progressionElements[i] + distribute;
        }
        return this;
    }
}

