/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.player;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import org.jfugue.player.EndOfTrackListener;
import org.jfugue.player.ManagedPlayerListener;
import org.jfugue.player.SequencerManager;

public class ManagedPlayer
implements EndOfTrackListener {
    private SequencerManager common;
    private boolean started;
    private boolean finished;
    private boolean paused;
    private CopyOnWriteArrayList<ManagedPlayerListener> playerListeners = new CopyOnWriteArrayList();

    public ManagedPlayer() {
        try {
            this.common = SequencerManager.getInstance();
        }
        catch (MidiUnavailableException e) {
            Logger.getLogger("org.jfugue").severe(e.getLocalizedMessage());
        }
    }

    public void addManagedPlayerListener(ManagedPlayerListener listener) {
        this.playerListeners.add(listener);
    }

    public void removeManagedPlayerListener(ManagedPlayerListener listener) {
        this.playerListeners.add(listener);
    }

    public List<ManagedPlayerListener> getManagedPlayerListeners() {
        return this.playerListeners;
    }

    public void start(Sequence sequence) throws InvalidMidiDataException, MidiUnavailableException {
        this.common.openSequencer();
        this.common.addEndOfTrackListener(this);
        this.common.getSequencer().setSequence(sequence);
        this.fireOnStarted();
        this.started = true;
        this.paused = false;
        this.finished = false;
        this.common.getSequencer().start();
    }

    public void pause() {
        this.fireOnPaused();
        this.paused = true;
        this.common.getSequencer().stop();
    }

    public void resume() {
        this.fireOnResumed();
        this.paused = false;
        this.common.getSequencer().start();
    }

    public void seek(long tick) {
        this.fireOnSeek(tick);
        this.common.getSequencer().setTickPosition(tick);
    }

    public void finish() {
        this.common.close();
        this.finished = true;
        this.fireOnFinished();
    }

    public long getTickLength() {
        return this.common.getSequencer().getTickLength();
    }

    public long getTickPosition() {
        return this.common.getSequencer().getTickPosition();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isPlaying() {
        return this.common.getSequencer().isRunning();
    }

    @Override
    public void onEndOfTrack() {
        this.finish();
    }

    protected void fireOnStarted() {
        List<ManagedPlayerListener> listeners = this.getManagedPlayerListeners();
        for (ManagedPlayerListener listener : listeners) {
            listener.onStarted();
        }
    }

    protected void fireOnFinished() {
        List<ManagedPlayerListener> listeners = this.getManagedPlayerListeners();
        for (ManagedPlayerListener listener : listeners) {
            listener.onFinished();
        }
    }

    protected void fireOnPaused() {
        List<ManagedPlayerListener> listeners = this.getManagedPlayerListeners();
        for (ManagedPlayerListener listener : listeners) {
            listener.onPaused();
        }
    }

    protected void fireOnResumed() {
        List<ManagedPlayerListener> listeners = this.getManagedPlayerListeners();
        for (ManagedPlayerListener listener : listeners) {
            listener.onResumed();
        }
    }

    protected void fireOnSeek(long tick) {
        List<ManagedPlayerListener> listeners = this.getManagedPlayerListeners();
        for (ManagedPlayerListener listener : listeners) {
            listener.onSeek(tick);
        }
    }
}

