/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.pattern;

import java.util.ArrayList;
import java.util.List;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.pattern.PatternValidator;

public class TrackTable
implements PatternProducer {
    private int length;
    private List<List<Pattern>> tracks;
    private PatternValidator validator;
    public static final int NUM_TRACKS = 16;
    public static final int RHYTHM_TRACK = 9;

    public TrackTable(int length) {
        this.length = length;
        this.tracks = new ArrayList<List<Pattern>>(16);
    }

    public List<Pattern> getTrack(int track) {
        return this.tracks.get(track);
    }

    public TrackTable setPatternValidator(PatternValidator pv) {
        this.validator = pv;
        return this;
    }

    public PatternValidator getPatternValidator() {
        return this.validator;
    }

    public TrackTable put(int track, int position, PatternProducer patternProducer) {
        if (this.validator != null && !this.validator.isValid(patternProducer)) {
            throw new RuntimeException(this.validator.getErrorMessage(patternProducer));
        }
        List<Pattern> trackList = this.tracks.get(track);
        if (trackList == null) {
            trackList = new ArrayList<Pattern>(this.getLength());
            this.tracks.add(track, trackList);
        }
        trackList.add(position, patternProducer.getPattern());
        return this;
    }

    public TrackTable put(int track, int position, PatternProducer ... patternProducers) {
        int counter = 0;
        for (PatternProducer producer : patternProducers) {
            this.put(track, position + counter, producer);
            ++counter;
        }
        return this;
    }

    public TrackTable putAtIntervals(int track, int nth, PatternProducer patternProducer) {
        for (int position = 0; position < this.length; position += nth) {
            this.put(track, position, patternProducer);
        }
        return this;
    }

    public TrackTable putAtIntervals(int track, int nth, int first, PatternProducer patternProducer) {
        for (int position = first; position < this.length; position += nth) {
            this.put(track, position, patternProducer);
        }
        return this;
    }

    public TrackTable put(int track, int start, int end, PatternProducer patternProducer) {
        for (int i = start; i <= end; ++i) {
            this.put(track, i, patternProducer);
        }
        return this;
    }

    public TrackTable put(int track, String periodMeansNoOtherMeansYes, PatternProducer patternProducer) {
        for (int i = 0; i < periodMeansNoOtherMeansYes.length(); ++i) {
            if (periodMeansNoOtherMeansYes.charAt(i) == '.') continue;
            this.put(track, i, patternProducer);
        }
        return this;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public Pattern getPattern() {
        Pattern pattern = new Pattern();
        for (List<Pattern> track : this.tracks) {
            for (Pattern p : track) {
                pattern.addTrack(this.tracks.indexOf(track), p);
            }
        }
        return pattern;
    }
}

