/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.pattern;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jfugue.midi.MidiDictionary;
import org.jfugue.pattern.PatternProducer;
import org.staccato.NoteSubparser;

public class Pattern
implements PatternProducer {
    protected StringBuilder patternSB = new StringBuilder();
    private int explicitVoice = -1;
    private int explicitInstrument = -1;
    private int explicitTempo = -1;
    private static final int UNDECLARED_EXPLICIT = -1;

    public Pattern() {
    }

    public Pattern(String string) {
        this();
        this.patternSB.append(string);
    }

    public Pattern(String ... strings) {
        this();
        for (String string : strings) {
            this.patternSB.append(string);
            this.patternSB.append(" ");
        }
    }

    public Pattern(PatternProducer ... producers) {
        this();
        this.add(producers);
    }

    public Pattern add(PatternProducer ... producers) {
        for (PatternProducer producer : producers) {
            this.add(producer.getPattern().toString());
        }
        return this;
    }

    public Pattern add(String string) {
        if (this.patternSB.length() > 0) {
            this.patternSB.append(" ");
        }
        this.patternSB.append(string);
        return this;
    }

    public Pattern prepend(PatternProducer ... producers) {
        for (PatternProducer producer : producers) {
            this.prepend(producer.getPattern().toString());
        }
        return this;
    }

    public Pattern prepend(String string) {
        if (this.patternSB.length() > 0) {
            this.patternSB.insert(0, " ");
        }
        this.patternSB.insert(0, string);
        return this;
    }

    public Pattern addTrack(int trackNumber, PatternProducer producer) {
        this.patternSB.append(" ");
        this.patternSB.append('V');
        this.patternSB.append(trackNumber);
        this.patternSB.append(" ");
        this.patternSB.append(producer);
        return this;
    }

    public Pattern clear() {
        this.patternSB.delete(0, this.patternSB.length());
        return this;
    }

    public Pattern repeat(int n) {
        Pattern p2 = new Pattern();
        for (int i = 0; i < n; ++i) {
            p2.add(this.patternSB.toString());
        }
        this.patternSB = p2.patternSB;
        return this;
    }

    @Override
    public Pattern getPattern() {
        return this;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        if (this.explicitTempo != -1) {
            b2.append('T');
            b2.append(this.explicitTempo);
            b2.append(" ");
        }
        if (this.explicitVoice != -1) {
            b2.append('V');
            b2.append(this.explicitVoice);
            b2.append(" ");
        }
        if (this.explicitInstrument != -1) {
            b2.append('I');
            b2.append("[");
            b2.append(MidiDictionary.INSTRUMENT_BYTE_TO_STRING.get((byte)this.explicitInstrument));
            b2.append("] ");
        }
        b2.append((CharSequence)this.patternSB);
        return b2.toString();
    }

    public Pattern setTempo(int explicitTempo) {
        this.explicitTempo = explicitTempo;
        return this;
    }

    public Pattern setTempo(String tempo) {
        if (!MidiDictionary.TEMPO_STRING_TO_INT.containsKey(tempo.toUpperCase())) {
            throw new RuntimeException("The tempo '" + tempo + "' is not recognized");
        }
        return this.setTempo(MidiDictionary.TEMPO_STRING_TO_INT.get(tempo.toUpperCase()));
    }

    public Pattern setVoice(int voice) {
        this.explicitVoice = voice;
        return this;
    }

    public Pattern setInstrument(int instrument) {
        this.explicitInstrument = instrument;
        return this;
    }

    public Pattern setInstrument(String instrument) {
        if (!MidiDictionary.INSTRUMENT_STRING_TO_BYTE.containsKey(instrument.toUpperCase())) {
            throw new RuntimeException("The instrument '" + instrument + "' is not recognized");
        }
        return this.setInstrument(MidiDictionary.INSTRUMENT_STRING_TO_BYTE.get(instrument.toUpperCase()).byteValue());
    }

    public Pattern addToEachNoteElement(String decoratorString) {
        String[] elements;
        StringBuilder b2 = new StringBuilder();
        int currentDecorator = 0;
        String[] decorators = decoratorString.split(" ");
        for (String element : elements = this.patternSB.toString().split(" ")) {
            if (NoteSubparser.getInstance().matches(element)) {
                b2.append(element);
                b2.append(decorators[currentDecorator++ % decorators.length]);
            } else {
                b2.append(element);
            }
            b2.append(" ");
        }
        this.patternSB = new StringBuilder(b2.toString().trim());
        return this;
    }

    public Pattern save(File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(this.toString());
        writer.close();
        return this;
    }

    public static Pattern load(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Pattern pattern = new Pattern();
        String line = null;
        while ((line = reader.readLine()) != null) {
            pattern.add(line);
        }
        reader.close();
        return pattern;
    }
}

