/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.mitools;

import java.util.Arrays;
import java.util.List;
import org.jfugue.pattern.Pattern;

public class Recombinator {
    private List<Object> things0AsList;
    private Object[] things0AsArray;
    private Object[] things0WorkingArray;
    private List<Object> things1AsList;
    private Object[] things1AsArray;
    private Object[] things1WorkingArray;

    public Recombinator() {
    }

    public Recombinator(List<Object> things0, List<Object> things1) {
        this.things0AsList = things0;
        this.things1AsList = things1;
    }

    public Recombinator(List<Object> things0, Object[] things1) {
        this.things0AsList = things0;
        this.things1AsArray = things1;
    }

    public Recombinator(Object[] things0, List<Object> things1) {
        this.things0AsArray = things0;
        this.things1AsList = things1;
    }

    public Recombinator(Object[] things0, Object[] things1) {
        this.things0AsArray = things0;
        this.things1AsArray = things1;
    }

    public Recombinator put(int index, List<Object> things) {
        switch (index) {
            case 0: {
                this.things0AsList = things;
                this.things0AsArray = null;
                break;
            }
            case 1: {
                this.things1AsList = things;
                this.things1AsArray = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Index to Recombinator must be either 0 or 1; provided value is " + index);
            }
        }
        return this;
    }

    public Recombinator put(int index, Object[] things) {
        switch (index) {
            case 0: {
                this.things0AsList = null;
                this.things0AsArray = things;
                break;
            }
            case 1: {
                this.things1AsList = null;
                this.things1AsArray = things;
                break;
            }
            default: {
                throw new IllegalArgumentException("Index to Recombinator must be either 0 or 1; provided value is " + index);
            }
        }
        return this;
    }

    public Pattern recombine(String instructions, LoopBehavior option) {
        this.createWorkingArrays();
        switch (option) {
            case LOOP_BOTH: {
                return this.loopBoth(instructions);
            }
            case LOOP_0_FIRST: {
                return this.loop0(instructions);
            }
            case LOOP_1_FIRST: {
                return this.loop1(instructions);
            }
        }
        return null;
    }

    private Pattern loopBoth(String instructions) {
        Pattern pattern = new Pattern();
        for (int i = 0; i < Math.max(this.things0WorkingArray.length, this.things1WorkingArray.length); ++i) {
            String patternPiece = instructions.replaceAll("\\$0", this.things0WorkingArray[i % this.things0WorkingArray.length].toString());
            pattern.add(patternPiece.replaceAll("\\$1", this.things1WorkingArray[i % this.things1WorkingArray.length].toString()));
        }
        return pattern;
    }

    private Pattern loop1(String instructions) {
        Pattern pattern = new Pattern();
        for (Object obj0 : this.things0WorkingArray) {
            String patternPiece = instructions.replaceAll("\\$0", obj0.toString());
            for (Object obj1 : this.things1WorkingArray) {
                pattern.add(patternPiece.replaceAll("\\$1", obj1.toString()));
            }
        }
        return pattern;
    }

    private Pattern loop0(String instructions) {
        Pattern pattern = new Pattern();
        for (Object obj1 : this.things1WorkingArray) {
            String patternPiece = instructions.replaceAll("\\$1", obj1.toString());
            for (Object obj0 : this.things0WorkingArray) {
                pattern.add(patternPiece.replaceAll("\\$0", obj0.toString()));
            }
        }
        return pattern;
    }

    private void createWorkingArrays() {
        if (this.things0AsArray != null) {
            this.things0WorkingArray = Arrays.copyOf(this.things0AsArray, this.things0AsArray.length);
        } else if (this.things0AsList != null) {
            this.things0AsList.toArray(this.things0WorkingArray);
        } else {
            throw new RuntimeException("Recombinator cannot recombine; there is no set of objects for $0");
        }
        if (this.things1AsArray != null) {
            this.things1WorkingArray = Arrays.copyOf(this.things1AsArray, this.things1AsArray.length);
        } else if (this.things1AsList != null) {
            this.things1AsList.toArray(this.things1WorkingArray);
        } else {
            throw new RuntimeException("Recombinator cannot recombine; there is no set of objects for $1");
        }
    }

    public static enum LoopBehavior {
        LOOP_0_FIRST,
        LOOP_1_FIRST,
        LOOP_BOTH;

    }
}

