/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.midi;

import java.util.HashMap;
import java.util.Map;

public class TrackTimeManager {
    private double[][] beatTime = new double[16][16];
    private byte currentTrack = 0;
    private byte lastCreatedTrack = 0;
    private byte[] currentLayer = new byte[16];
    private double initialNoteBeatTimeForHarmonicNotes = 0.0;
    private Map<String, Double> bookmarkedTrackTimeMap = new HashMap<String, Double>();

    public void setCurrentTrack(byte track) {
        if (track > this.lastCreatedTrack) {
            for (int i = this.lastCreatedTrack + 1; i < track; ++i) {
                this.createTrack((byte)i);
            }
            this.lastCreatedTrack = track;
        }
        this.currentTrack = track;
    }

    public byte getCurrentTrack() {
        return this.currentTrack;
    }

    protected byte getLastCreatedTrack() {
        return this.lastCreatedTrack;
    }

    protected void createTrack(byte track) {
        for (int layer = 0; layer < 16; layer = (int)((byte)(layer + 1))) {
            this.beatTime[track][layer] = 0.0;
        }
        this.currentLayer[track] = 0;
    }

    public void setCurrentLayer(byte layer) {
        this.currentLayer[this.currentTrack] = layer;
    }

    protected byte getCurrentLayer() {
        return this.currentLayer[this.getCurrentTrack()];
    }

    public void setInitialNoteBeatTimeForHarmonicNotes(double initialNoteBeatTimeForHarmonicNotes) {
        this.initialNoteBeatTimeForHarmonicNotes = initialNoteBeatTimeForHarmonicNotes;
    }

    public double getInitialNoteBeatTimeForHarmonicNotes() {
        return this.initialNoteBeatTimeForHarmonicNotes;
    }

    public void advanceTrackBeatTime(double advanceTime) {
        double[] dArray = this.beatTime[this.currentTrack];
        byte by = this.currentLayer[this.currentTrack];
        dArray[by] = dArray[by] + advanceTime;
    }

    public void setTrackBeatTime(double newTime) {
        this.beatTime[this.currentTrack][this.currentLayer[this.currentTrack]] = newTime;
    }

    public void setAllTrackBeatTime(double newTime) {
        for (int track = 0; track < 16; ++track) {
            for (int layer = 0; layer < 16; ++layer) {
                if (!(this.beatTime[track][layer] < newTime)) continue;
                this.beatTime[track][layer] = newTime;
            }
        }
    }

    public double getTrackBeatTime() {
        return this.beatTime[this.currentTrack][this.currentLayer[this.currentTrack]];
    }

    public void addTrackTickTimeBookmark(String timeBookmarkID) {
        this.bookmarkedTrackTimeMap.put(timeBookmarkID, this.getTrackBeatTime());
    }

    public double getTrackBeatTimeBookmark(String timeBookmarkID) {
        return this.bookmarkedTrackTimeMap.get(timeBookmarkID);
    }

    public double getLatestTrackBeatTime(byte track) {
        double latestTime = 0.0;
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            if (!(this.beatTime[track][i] > latestTime)) continue;
            latestTime = this.beatTime[track][i];
        }
        return latestTime;
    }
}

