/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.devices;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import org.jfugue.midi.MidiTools;

public class MusicReceiver {
    private MidiDevice device;
    private boolean isInitiated;
    private Receiver receiver;

    public MusicReceiver(MidiDevice device) {
        this.device = device;
        this.isInitiated = false;
    }

    public void sendSequence(Sequence sequence) throws MidiUnavailableException {
        this.init();
        MidiTools.sendSequenceToReceiver(sequence, this.receiver);
        this.cleanup();
        this.close();
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    private void init() throws MidiUnavailableException {
        if (!this.isInitiated) {
            if (!this.device.isOpen()) {
                this.device.open();
            }
            this.receiver = this.device.getReceiver();
            this.isInitiated = true;
        }
    }

    private void cleanup() {
        ShortMessage allControllersOff = new ShortMessage();
        ShortMessage allNotesOff = new ShortMessage();
        for (int track = 0; track < 16; track = (int)((byte)(track + 1))) {
            try {
                allControllersOff.setMessage(176, track, 121, 0);
                this.receiver.send(allControllersOff, -1L);
                allNotesOff.setMessage(176, track, 123, 0);
                this.receiver.send(allNotesOff, -1L);
                continue;
            }
            catch (InvalidMidiDataException e) {
                // empty catch block
            }
        }
    }

    private void close() {
        this.receiver.close();
        this.device.close();
    }
}

