/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.pcf;

import com.pi4j.gpio.extension.pcf.PCF8574Pin;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;

public class PCF8574GpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.ti.PCF8574GpioProvider";
    public static final String DESCRIPTION = "PCF8574 GPIO Provider";
    public static final int PCF8574_0x20 = 32;
    public static final int PCF8574_0x21 = 33;
    public static final int PCF8574_0x22 = 34;
    public static final int PCF8574_0x23 = 35;
    public static final int PCF8574_0x24 = 36;
    public static final int PCF8574_0x25 = 37;
    public static final int PCF8574_0x26 = 38;
    public static final int PCF8574_0x27 = 39;
    public static final int PCF8574A_0x38 = 56;
    public static final int PCF8574A_0x39 = 57;
    public static final int PCF8574A_0x3A = 58;
    public static final int PCF8574A_0x3B = 59;
    public static final int PCF8574A_0x3C = 60;
    public static final int PCF8574A_0x3D = 61;
    public static final int PCF8574A_0x3E = 62;
    public static final int PCF8574A_0x3F = 63;
    public static final int PCF8574_MAX_IO_PINS = 8;
    private boolean i2cBusOwner = false;
    private I2CBus bus;
    private I2CDevice device;
    private GpioStateMonitor monitor = null;
    private BitSet currentStates = new BitSet(8);

    public PCF8574GpioProvider(int busNumber, int address) throws IOException {
        this(I2CFactory.getInstance((int)busNumber), address);
        this.i2cBusOwner = true;
    }

    public PCF8574GpioProvider(I2CBus bus, int address) throws IOException {
        this.bus = bus;
        this.device = bus.getDevice(address);
        for (Pin pin : PCF8574Pin.ALL) {
            this.getPinCache(pin).setState(PinState.HIGH);
            this.currentStates.set(pin.getAddress(), true);
        }
        this.monitor = new GpioStateMonitor(this.device);
        this.monitor.start();
    }

    public String getName() {
        return NAME;
    }

    public void export(Pin pin, PinMode mode) {
        super.export(pin, mode);
        this.setMode(pin, mode);
    }

    public void unexport(Pin pin) {
        super.unexport(pin);
        this.setMode(pin, PinMode.DIGITAL_OUTPUT);
    }

    public void setMode(Pin pin, PinMode mode) {
        super.setMode(pin, mode);
    }

    public PinMode getMode(Pin pin) {
        return super.getMode(pin);
    }

    public void setState(Pin pin, PinState state) {
        super.setState(pin, state);
        try {
            this.currentStates.set(pin.getAddress(), state.isHigh());
            this.device.write(this.currentStates.isEmpty() ? (byte)0 : this.currentStates.toByteArray()[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public PinState getState(Pin pin) {
        return super.getState(pin);
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        try {
            if (this.monitor != null) {
                this.monitor.shutdown();
                this.monitor = null;
            }
            if (this.i2cBusOwner) {
                this.bus.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class GpioStateMonitor
    extends Thread {
        private I2CDevice device;
        private boolean shuttingDown = false;

        public GpioStateMonitor(I2CDevice device) {
            this.device = device;
        }

        public void shutdown() {
            this.shuttingDown = true;
        }

        @Override
        public void run() {
            while (!this.shuttingDown) {
                try {
                    byte[] buffer = new byte[1];
                    this.device.read(buffer, 0, 1);
                    BitSet pinStates = BitSet.valueOf(buffer);
                    for (int index = 0; index < 8; ++index) {
                        if (pinStates.get(index) == PCF8574GpioProvider.this.currentStates.get(index)) continue;
                        Pin pin = PCF8574Pin.ALL[index];
                        PinState newState = pinStates.get(index) ? PinState.HIGH : PinState.LOW;
                        PCF8574GpioProvider.this.getPinCache(pin).setState(newState);
                        PCF8574GpioProvider.this.currentStates.set(index, pinStates.get(index));
                        if (PCF8574GpioProvider.this.getMode(pin) != PinMode.DIGITAL_INPUT) continue;
                        this.dispatchPinChangeEvent(pin.getAddress(), newState);
                    }
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void dispatchPinChangeEvent(int pinAddress, PinState state) {
            for (Pin pin : PCF8574GpioProvider.this.listeners.keySet()) {
                if (pin.getAddress() != pinAddress) continue;
                for (PinListener listener : (List)PCF8574GpioProvider.this.listeners.get(pin)) {
                    listener.handlePinEvent((PinEvent)new PinDigitalStateChangeEvent((Object)this, pin, state));
                }
            }
        }
    }
}

