/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.sentdetect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.ml.maxent.GIS;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.SampleTraceStream;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public final class SentenceDetectorTrainer
extends CasConsumer_ImplBase {
    private List<SentenceSample> sentenceSamples = new ArrayList<SentenceSample>();
    private Type mSentenceType;
    private String mModelName;
    private String language = "en";
    private Logger mLogger;
    private UimaContext mContext;
    private String eosChars;
    private File sampleTraceFile;
    private String sampleTraceFileEncoding;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP SentenceDetector trainer.");
        }
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
        this.language = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.Language");
        this.eosChars = CasConsumerUtil.getOptionalStringParameter(this.mContext, "opennlp.uima.EOSChars");
        String sampleTraceFileName = CasConsumerUtil.getOptionalStringParameter(this.getUimaContext(), "opennlp.uima.SampleTraceFile");
        if (sampleTraceFileName != null) {
            this.sampleTraceFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + sampleTraceFileName);
            this.sampleTraceFileEncoding = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), "opennlp.uima.SampleTraceFileEncoding");
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String sentenceTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, sentenceTypeName);
    }

    public void processCas(CAS cas) {
        AnnotationIndex sentenceIndex = cas.getAnnotationIndex(this.mSentenceType);
        Span[] sentSpans = new Span[sentenceIndex.size()];
        int i = 0;
        for (AnnotationFS sentenceAnnotation : sentenceIndex) {
            sentSpans[i++] = new Span(sentenceAnnotation.getBegin(), sentenceAnnotation.getEnd());
        }
        this.sentenceSamples.add(new SentenceSample(cas.getDocumentText().replace('\n', ' '), sentSpans));
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        char[] eos = null;
        if (this.eosChars != null) {
            eos = this.eosChars.toCharArray();
        }
        SentenceDetectorFactory sdFactory = SentenceDetectorFactory.create(null, (String)this.language, (boolean)true, null, (char[])eos);
        TrainingParameters mlParams = ModelUtil.createDefaultTrainingParameters();
        Object samples = ObjectStreamUtils.createObjectStream(this.sentenceSamples);
        OutputStreamWriter samplesOut = null;
        if (this.sampleTraceFile != null) {
            samplesOut = new OutputStreamWriter((OutputStream)new FileOutputStream(this.sampleTraceFile), this.sampleTraceFileEncoding);
            samples = new SampleTraceStream(samples, samplesOut);
        }
        SentenceModel sentenceModel = SentenceDetectorME.train((String)this.language, (ObjectStream)samples, (SentenceDetectorFactory)sdFactory, (TrainingParameters)mlParams);
        this.sentenceSamples = null;
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize((BaseModel)sentenceModel, modelFile);
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.sentenceSamples = null;
    }
}

