/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Enumeration;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class NetworkUtils {
    public static String localIPAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    String ipAddress = inetAddress.getHostAddress().toString();
                    int p = ipAddress.indexOf("%");
                    if (p > 0) {
                        ipAddress = ipAddress.substring(0, p);
                    }
                    return ipAddress;
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return "127.0.0.1";
    }

    public static String responseContent(String url) throws Exception {
        String line;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet();
        request.setURI(new URI(url));
        InputStream is = client.execute((HttpUriRequest)request).getEntity().getContent();
        BufferedReader inb = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder("");
        String NL = System.getProperty("line.separator");
        while ((line = inb.readLine()) != null) {
            sb.append(line).append(NL);
        }
        inb.close();
        return sb.toString();
    }

    public static String responseContentUri(URI uri) throws Exception {
        String line;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost request = new HttpPost();
        request.setURI(uri);
        InputStream is = client.execute((HttpUriRequest)request).getEntity().getContent();
        BufferedReader inb = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder("");
        String NL = System.getProperty("line.separator");
        while ((line = inb.readLine()) != null) {
            sb.append(line).append(NL);
        }
        inb.close();
        return sb.toString();
    }

    public static String spec(String host, String botid, String custid, String input) {
        String spec = "";
        try {
            spec = custid.equals("0") ? String.format("%s?botid=%s&input=%s", "http://" + host + "/pandora/talk-xml", botid, URLEncoder.encode(input, "UTF-8")) : String.format("%s?botid=%s&custid=%s&input=%s", "http://" + host + "/pandora/talk-xml", botid, custid, URLEncoder.encode(input, "UTF-8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println(spec);
        return spec;
    }
}

