/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class IOUtils {
    BufferedReader reader;
    BufferedWriter writer;

    public IOUtils(String filePath, String mode) {
        try {
            if (mode.equals("read")) {
                this.reader = new BufferedReader(new FileReader(filePath));
            } else if (mode.equals("write")) {
                new File(filePath).delete();
                this.writer = new BufferedWriter(new FileWriter(filePath, true));
            }
        }
        catch (IOException e) {
            System.err.println("error: " + e);
        }
    }

    public String readLine() {
        String result = null;
        try {
            result = this.reader.readLine();
        }
        catch (IOException e) {
            System.err.println("error: " + e);
        }
        return result;
    }

    public void writeLine(String line) {
        try {
            this.writer.write(line);
            this.writer.newLine();
        }
        catch (IOException e) {
            System.err.println("error: " + e);
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            System.err.println("error: " + e);
        }
    }

    public static void writeOutputTextLine(String prompt, String text) {
        System.out.println(prompt + ": " + text);
    }

    public static String readInputTextLine() {
        return IOUtils.readInputTextLine(null);
    }

    public static String readInputTextLine(String prompt) {
        if (prompt != null) {
            System.out.print(prompt + ": ");
        }
        BufferedReader lineOfText = new BufferedReader(new InputStreamReader(System.in));
        String textLine = null;
        try {
            textLine = lineOfText.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return textLine;
    }

    public static File[] listFiles(File dir) {
        return dir.listFiles();
    }

    public static String system(String evaluatedContents, String failedString) {
        Runtime rt = Runtime.getRuntime();
        try {
            Process p = rt.exec(evaluatedContents);
            InputStream istrm = p.getInputStream();
            InputStreamReader istrmrdr = new InputStreamReader(istrm);
            BufferedReader buffrdr = new BufferedReader(istrmrdr);
            String result = "";
            String data = "";
            while ((data = buffrdr.readLine()) != null) {
                result = result + data + "\n";
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return failedString;
        }
    }

    public static String evalScript(String engineName, String script) throws Exception {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        String result = "" + engine.eval(script);
        return result;
    }
}

