/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.alicebot.ab.AB;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;
import org.alicebot.ab.ChatTest;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.utils.IOUtils;

public class TestAB {
    public static String sample_file = "sample.random.txt";

    public static void testChat(Bot bot, boolean doWrites, boolean traceMode) {
        Chat chatSession = new Chat(bot, doWrites);
        bot.brain.nodeStats();
        MagicBooleans.trace_mode = traceMode;
        String textLine = "";
        while (true) {
            if ((textLine = IOUtils.readInputTextLine("Human")) == null || textLine.length() < 1) {
                textLine = MagicStrings.null_input;
            }
            if (textLine.equals("q")) {
                System.exit(0);
                continue;
            }
            if (textLine.equals("wq")) {
                bot.writeQuit();
                System.exit(0);
                continue;
            }
            if (textLine.equals("sc")) {
                TestAB.sraixCache("c:/ab/data/sraixdata6.txt", chatSession);
                continue;
            }
            if (textLine.equals("iqtest")) {
                ChatTest ct = new ChatTest(bot);
                try {
                    ct.testMultisentenceRespond();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (textLine.equals("ab")) {
                TestAB.testAB(bot, sample_file);
                continue;
            }
            String request = textLine;
            if (MagicBooleans.trace_mode) {
                System.out.println("STATE=" + request + ":THAT=" + chatSession.thatHistory.get(0).get(0) + ":TOPIC=" + chatSession.predicates.get("topic"));
            }
            String response = chatSession.multisentenceRespond(request);
            while (response.contains("&lt;")) {
                response = response.replace("&lt;", "<");
            }
            while (response.contains("&gt;")) {
                response = response.replace("&gt;", ">");
            }
            IOUtils.writeOutputTextLine("Robot", response);
        }
    }

    public static void testBotChat() {
        Bot bot = new Bot("alice");
        System.out.println(bot.brain.upgradeCnt + " brain upgrades");
        Chat chatSession = new Chat(bot);
        String request = "Hello.  How are you?  What is your name?  Tell me about yourself.";
        String response = chatSession.multisentenceRespond(request);
        System.out.println("Human: " + request);
        System.out.println("Robot: " + response);
    }

    public static void runTests(Bot bot, boolean traceMode) {
        MagicBooleans.qa_test_mode = true;
        Chat chatSession = new Chat(bot, false);
        bot.brain.nodeStats();
        MagicBooleans.trace_mode = traceMode;
        IOUtils testInput = new IOUtils(MagicStrings.root_path + "/data/lognormal-500.txt", "read");
        IOUtils testOutput = new IOUtils(MagicStrings.root_path + "/data/lognormal-500-out.txt", "write");
        String textLine = testInput.readLine();
        int i = 1;
        System.out.print(0);
        while (textLine != null) {
            if (textLine == null || textLine.length() < 1) {
                textLine = MagicStrings.null_input;
            }
            if (textLine.equals("q")) {
                System.exit(0);
            } else if (textLine.equals("wq")) {
                bot.writeQuit();
                System.exit(0);
            } else if (textLine.equals("ab")) {
                TestAB.testAB(bot, sample_file);
            } else if (textLine.equals(MagicStrings.null_input)) {
                testOutput.writeLine("");
            } else if (textLine.startsWith("#")) {
                testOutput.writeLine(textLine);
            } else {
                String request = textLine;
                if (MagicBooleans.trace_mode) {
                    System.out.println("STATE=" + request + ":THAT=" + chatSession.thatHistory.get(0).get(0) + ":TOPIC=" + chatSession.predicates.get("topic"));
                }
                String response = chatSession.multisentenceRespond(request);
                while (response.contains("&lt;")) {
                    response = response.replace("&lt;", "<");
                }
                while (response.contains("&gt;")) {
                    response = response.replace("&gt;", ">");
                }
                testOutput.writeLine("Robot: " + response);
            }
            textLine = testInput.readLine();
            System.out.print(".");
            if (i % 10 == 0) {
                System.out.print(" ");
            }
            if (i % 100 == 0) {
                System.out.println("");
                System.out.print(i + " ");
            }
            ++i;
        }
        testInput.close();
        testOutput.close();
        System.out.println("");
    }

    public static void testAB(Bot bot, String sampleFile) {
        MagicBooleans.trace_mode = true;
        AB ab = new AB(bot, sampleFile);
        ab.ab();
        System.out.println("Begin Pattern Suggestor Terminal Interaction");
        ab.terminalInteraction();
    }

    public static void testShortCuts() {
    }

    public static void sraixCache(String filename, Chat chatSession) {
        int limit = 650000;
        MagicBooleans.cache_sraix = true;
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            int count = 0;
            while ((strLine = br.readLine()) != null && count++ < limit) {
                System.out.println("Human: " + strLine);
                String response = chatSession.multisentenceRespond(strLine);
                System.out.println("Robot: " + response);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

