/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alicebot.ab.Bot;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;

public class PreProcessor {
    private static boolean DEBUG = false;
    public int normalCount = 0;
    public int denormalCount = 0;
    public int personCount = 0;
    public int person2Count = 0;
    public int genderCount = 0;
    public String[] normalSubs = new String[MagicNumbers.max_substitutions];
    public Pattern[] normalPatterns = new Pattern[MagicNumbers.max_substitutions];
    public String[] denormalSubs = new String[MagicNumbers.max_substitutions];
    public Pattern[] denormalPatterns = new Pattern[MagicNumbers.max_substitutions];
    public String[] personSubs = new String[MagicNumbers.max_substitutions];
    public Pattern[] personPatterns = new Pattern[MagicNumbers.max_substitutions];
    public String[] person2Subs = new String[MagicNumbers.max_substitutions];
    public Pattern[] person2Patterns = new Pattern[MagicNumbers.max_substitutions];
    public String[] genderSubs = new String[MagicNumbers.max_substitutions];
    public Pattern[] genderPatterns = new Pattern[MagicNumbers.max_substitutions];

    public PreProcessor(Bot bot) {
        this.normalCount = this.readSubstitutions(bot.config_path + "/normal.txt", this.normalPatterns, this.normalSubs);
        this.denormalCount = this.readSubstitutions(bot.config_path + "/denormal.txt", this.denormalPatterns, this.denormalSubs);
        this.personCount = this.readSubstitutions(bot.config_path + "/person.txt", this.personPatterns, this.personSubs);
        this.person2Count = this.readSubstitutions(bot.config_path + "/person2.txt", this.person2Patterns, this.person2Subs);
        this.genderCount = this.readSubstitutions(bot.config_path + "/gender.txt", this.genderPatterns, this.genderSubs);
        if (MagicBooleans.trace_mode) {
            System.out.println("Preprocessor: " + this.normalCount + " norms " + this.personCount + " persons " + this.person2Count + " person2 ");
        }
    }

    public String normalize(String request) {
        if (DEBUG) {
            System.out.println("PreProcessor.normalize(request: " + request + ")");
        }
        String result = this.substitute(request, this.normalPatterns, this.normalSubs, this.normalCount);
        result = result.replaceAll("(\r\n|\n\r|\r|\n)", " ");
        if (DEBUG) {
            System.out.println("PreProcessor.normalize() returning: " + result);
        }
        return result;
    }

    public String denormalize(String request) {
        return this.substitute(request, this.denormalPatterns, this.denormalSubs, this.denormalCount);
    }

    public String person(String input) {
        return this.substitute(input, this.personPatterns, this.personSubs, this.personCount);
    }

    public String person2(String input) {
        return this.substitute(input, this.person2Patterns, this.person2Subs, this.person2Count);
    }

    public String gender(String input) {
        return this.substitute(input, this.genderPatterns, this.genderSubs, this.genderCount);
    }

    String substitute(String request, Pattern[] patterns, String[] subs, int count) {
        String result = " " + request + " ";
        int index = 0;
        try {
            for (int i = 0; i < count; ++i) {
                index = i;
                String replacement = subs[i];
                Pattern p = patterns[i];
                Matcher m = p.matcher(result);
                if (!m.find()) continue;
                result = m.replaceAll(replacement);
            }
            while (result.contains("  ")) {
                result = result.replace("  ", " ");
            }
            result = result.trim();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Request " + request + " Result " + result + " at " + index + " " + patterns[index] + " " + subs[index]);
        }
        return result.trim();
    }

    public int readSubstitutionsFromInputStream(InputStream in, Pattern[] patterns, String[] subs) {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        int subCount = 0;
        try {
            String strLine;
            while ((strLine = br.readLine()) != null) {
                Pattern pattern;
                Matcher matcher;
                if ((strLine = strLine.trim()).startsWith(MagicStrings.text_comment_mark) || !(matcher = (pattern = Pattern.compile("\"(.*?)\",\"(.*?)\"", 32)).matcher(strLine)).find() || subCount >= MagicNumbers.max_substitutions) continue;
                subs[subCount] = matcher.group(2);
                String quotedPattern = Pattern.quote(matcher.group(1));
                patterns[subCount] = Pattern.compile(quotedPattern, 2);
                ++subCount;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return subCount;
    }

    int readSubstitutions(String filename, Pattern[] patterns, String[] subs) {
        int subCount = 0;
        try {
            File file = new File(filename);
            if (file.exists()) {
                FileInputStream fstream = new FileInputStream(filename);
                subCount = this.readSubstitutionsFromInputStream(fstream, patterns, subs);
                fstream.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return subCount;
    }

    public String[] sentenceSplit(String line) {
        line = line.replace("\u00e3\u20ac\u201a", ".");
        line = line.replace("\u00ef\u00bc\u0178", "?");
        line = line.replace("\u00ef\u00bc\ufffd", "!");
        String[] result = line.split("[\\.!\\?]");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public void normalizeFile(String infile, String outfile) {
        try {
            String strLine;
            BufferedWriter bw = null;
            FileInputStream fstream = new FileInputStream(infile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            bw = new BufferedWriter(new FileWriter(outfile));
            while ((strLine = br.readLine()) != null) {
                if ((strLine = strLine.trim()).length() <= 0) continue;
                String norm = this.normalize(strLine).toUpperCase();
                String[] sentences = this.sentenceSplit(norm);
                if (sentences.length > 1) {
                    for (String s : sentences) {
                        System.out.println(norm + "-->" + s);
                    }
                }
                for (String sentence : sentences) {
                    if ((sentence = sentence.trim()).length() <= 0) continue;
                    bw.write(sentence);
                    bw.newLine();
                }
            }
            bw.close();
            br.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

