/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import org.alicebot.ab.AB;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Category;
import org.alicebot.ab.Chat;
import org.alicebot.ab.ChatTest;
import org.alicebot.ab.Graphmaster;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Nodemapper;
import org.alicebot.ab.PCAIMLProcessorExtension;
import org.alicebot.ab.TestAB;
import org.alicebot.ab.Verbs;

public class Main {
    public static void main(String[] args) {
        MagicStrings.setRootPath();
        AIMLProcessor.extension = new PCAIMLProcessorExtension();
        Main.mainFunction(args);
    }

    public static void mainFunction(String[] args) {
        String botName = "alice2";
        MagicBooleans.jp_tokenize = false;
        MagicBooleans.trace_mode = true;
        String action = "chat";
        System.out.println(MagicStrings.program_name_version);
        for (String s : args) {
            String[] splitArg = s.split("=");
            if (splitArg.length < 2) continue;
            String option = splitArg[0];
            String value = splitArg[1];
            if (option.equals("bot")) {
                botName = value;
            }
            if (option.equals("action")) {
                action = value;
            }
            if (option.equals("trace")) {
                MagicBooleans.trace_mode = value.equals("true");
            }
            if (!option.equals("morph")) continue;
            MagicBooleans.jp_tokenize = value.equals("true");
        }
        if (MagicBooleans.trace_mode) {
            System.out.println("Working Directory = " + MagicStrings.root_path);
        }
        Graphmaster.enableShortCuts = true;
        Bot bot = new Bot(botName, MagicStrings.root_path, action);
        if (MagicBooleans.make_verbs_sets_maps) {
            Verbs.makeVerbSetsMaps(bot);
        }
        if (bot.brain.getCategories().size() < MagicNumbers.brain_print_size) {
            bot.brain.printgraph();
        }
        if (MagicBooleans.trace_mode) {
            System.out.println("Action = '" + action + "'");
        }
        if (action.equals("chat") || action.equals("chat-app")) {
            boolean doWrites = !action.equals("chat-app");
            TestAB.testChat(bot, doWrites, MagicBooleans.trace_mode);
        } else if (action.equals("ab")) {
            TestAB.testAB(bot, TestAB.sample_file);
        } else if (action.equals("aiml2csv") || action.equals("csv2aiml")) {
            Main.convert(bot, action);
        } else if (action.equals("abwq")) {
            AB ab = new AB(bot, TestAB.sample_file);
            ab.abwq();
        } else if (action.equals("test")) {
            TestAB.runTests(bot, MagicBooleans.trace_mode);
        } else if (action.equals("shadow")) {
            MagicBooleans.trace_mode = false;
            bot.shadowChecker();
        } else if (action.equals("iqtest")) {
            ChatTest ct = new ChatTest(bot);
            try {
                ct.testMultisentenceRespond();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("Unrecognized action " + action);
        }
    }

    public static void convert(Bot bot, String action) {
        if (action.equals("aiml2csv")) {
            bot.writeAIMLIFFiles();
        } else if (action.equals("csv2aiml")) {
            bot.writeAIMLFiles();
        }
    }

    public static void getGloss(Bot bot, String filename) {
        System.out.println("getGloss");
        try {
            File file = new File(filename);
            if (file.exists()) {
                FileInputStream fstream = new FileInputStream(filename);
                Main.getGlossFromInputStream(bot, fstream);
                fstream.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void getGlossFromInputStream(Bot bot, InputStream in) {
        System.out.println("getGlossFromInputStream");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        int cnt = 0;
        int filecnt = 0;
        HashMap<String, String> def = new HashMap<String, String>();
        try {
            String strLine;
            String word = null;
            String gloss = null;
            while ((strLine = br.readLine()) != null) {
                String definition;
                if (strLine.contains("<entry word")) {
                    int start = strLine.indexOf("<entry word=\"") + "<entry word=\"".length();
                    int end = strLine.indexOf("#");
                    word = strLine.substring(start, end);
                    word = word.replaceAll("_", " ");
                    System.out.println(word);
                } else if (strLine.contains("<gloss>")) {
                    gloss = strLine.replaceAll("<gloss>", "");
                    gloss = gloss.replaceAll("</gloss>", "");
                    gloss = gloss.trim();
                    System.out.println(gloss);
                }
                if (word == null || gloss == null) continue;
                word = word.toLowerCase().trim();
                if (gloss.length() > 2) {
                    gloss = gloss.substring(0, 1).toUpperCase() + gloss.substring(1, gloss.length());
                }
                if (def.keySet().contains(word)) {
                    definition = (String)def.get(word);
                    definition = definition + "; " + gloss;
                } else {
                    definition = gloss;
                }
                def.put(word, definition);
                word = null;
                gloss = null;
            }
            Category d = new Category(0, "WNDEF *", "*", "*", "unknown", "wndefs" + filecnt + ".aiml");
            bot.brain.addCategory(d);
            Iterator iterator = def.keySet().iterator();
            while (iterator.hasNext()) {
                String x;
                word = x = (String)iterator.next();
                gloss = (String)def.get(word) + ".";
                if (++cnt % 5000 == 0) {
                    ++filecnt;
                }
                Category c = new Category(0, "WNDEF " + word, "*", "*", gloss, "wndefs" + filecnt + ".aiml");
                System.out.println(cnt + " " + filecnt + " " + c.inputThatTopic() + ":" + c.getTemplate() + ":" + c.getFilename());
                Nodemapper node = bot.brain.findNode(c);
                if (node != null) {
                    node.category.setTemplate(node.category.getTemplate() + "," + gloss);
                }
                bot.brain.addCategory(c);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void sraixCache(String filename, Chat chatSession) {
        int limit = 1000;
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            int count = 0;
            while ((strLine = br.readLine()) != null && count++ < limit) {
                System.out.println("Human: " + strLine);
                String response = chatSession.multisentenceRespond(strLine);
                System.out.println("Robot: " + response);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

