/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsapi;

import com.sun.speech.engine.recognition.BaseRecognizer;
import com.sun.speech.engine.recognition.BaseRuleGrammar;
import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.util.Microphone;
import edu.cmu.sphinx.jsapi.RecognitionThread;
import edu.cmu.sphinx.jsapi.Sphinx4ResultListener;
import edu.cmu.sphinx.jsapi.SphinxRecognizerModeDesc;
import edu.cmu.sphinx.jsgf.JSGFGrammar;
import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFGrammarParseException;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import javax.speech.EngineException;
import javax.speech.EngineStateError;
import javax.speech.recognition.GrammarException;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleGrammar;

public class SphinxRecognizer
extends BaseRecognizer {
    private static final long SLEEP_MSEC = 50L;
    private Recognizer recognizer;
    private DataProcessor dataProcessor;
    private JSGFGrammar grammar;
    private final Sphinx4ResultListener resultListener;
    private RecognitionThread recognitionThread;

    public SphinxRecognizer() throws EngineException {
        this(new SphinxRecognizerModeDesc());
    }

    public SphinxRecognizer(SphinxRecognizerModeDesc modeDesc) throws EngineException {
        String config = modeDesc.getConfigFile();
        URL url = SphinxRecognizer.class.getResource(config);
        if (url == null) {
            throw new EngineException("Unable to load configuration from resource '" + config + "'!");
        }
        try {
            ConfigurationManager configuration = new ConfigurationManager(url);
            this.recognizer = (Recognizer)configuration.lookup("recognizer");
            this.dataProcessor = (DataProcessor)configuration.lookup("microphone");
            this.grammar = (JSGFGrammar)configuration.lookup("jsgfGrammar");
        }
        catch (Exception ex) {
            throw new EngineException(ex.getMessage());
        }
        this.resultListener = new Sphinx4ResultListener(this);
    }

    @Override
    protected void handleResume() {
        if (this.recognizer == null) {
            return;
        }
        if (this.recognitionThread != null) {
            return;
        }
        this.recognitionThread = new RecognitionThread(this);
        this.recognitionThread.start();
    }

    @Override
    protected void handlePause() {
        if (this.recognitionThread == null) {
            return;
        }
        this.stopRecognitionThread();
        if (this.dataProcessor instanceof Microphone) {
            Microphone microphone = (Microphone)this.dataProcessor;
            microphone.stopRecording();
        }
    }

    @Override
    protected void handleAllocate() throws EngineException {
        if (this.recognizer == null) {
            throw new EngineException("cannot allocate: no recognizer created!");
        }
        this.recognizer.allocate();
        RuleGrammar[] grammars = this.listRuleGrammars();
        for (int i = 0; i < grammars.length; ++i) {
            this.deleteRuleGrammar(grammars[i]);
        }
        this.recognizer.addResultListener((ResultListener)this.resultListener);
        this.setEngineState(-1L, 4L);
    }

    @Override
    public RuleGrammar loadJSGF(Reader reader) throws GrammarException, IOException, EngineStateError {
        RuleGrammar loadedGrammar = super.loadJSGF(reader);
        try {
            String[] loadedRuleNames;
            BaseRuleGrammar ruleGrammar = new BaseRuleGrammar((BaseRecognizer)this, this.grammar.getRuleGrammar());
            for (String name : loadedRuleNames = loadedGrammar.listRuleNames()) {
                Rule rule = loadedGrammar.getRule(name);
                ruleGrammar.setRule(name, rule, true);
                ruleGrammar.setEnabled(name, true);
            }
            this.grammar.commitChanges();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return loadedGrammar;
    }

    @Override
    protected void handleDeallocate() throws EngineException {
        if (this.recognizer == null) {
            throw new EngineException("cannot deallocate: no recognizer created!");
        }
        this.stopRecognitionThread();
        this.recognizer.deallocate();
        while (this.recognizer.getState() == Recognizer.State.RECOGNIZING) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new EngineException(e.getMessage());
            }
        }
        this.recognizer.resetMonitors();
        this.recognizer.removeResultListener((ResultListener)this.resultListener);
    }

    @Override
    public RuleGrammar loadJSGF(URL url, String name) throws GrammarException, IOException {
        try {
            this.grammar.loadJSGF(name);
        }
        catch (JSGFGrammarException e) {
            throw new GrammarException(e.toString());
        }
        catch (JSGFGrammarParseException e) {
            throw new GrammarException(e.toString());
        }
        return super.loadJSGF(url, name);
    }

    DataProcessor getDataProcessor() {
        return this.dataProcessor;
    }

    Recognizer getRecognizer() {
        return this.recognizer;
    }

    private void stopRecognitionThread() {
        if (this.recognitionThread == null) {
            return;
        }
        this.recognitionThread.stopRecognition();
        long maxSleepTime = 5000L;
        for (long sleepTime = 0L; this.recognitionThread.isAlive() && sleepTime < 5000L; sleepTime += 50L) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.recognitionThread = null;
    }

    RuleGrammar getRuleGrammar() {
        return new BaseRuleGrammar((BaseRecognizer)this, this.grammar.getRuleGrammar());
    }
}

