/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.synthesis.BaseVoice;
import java.util.ArrayList;
import java.util.List;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class VoiceList {
    protected final List<BaseVoice> voiceList = new ArrayList<BaseVoice>();

    public VoiceList() {
    }

    public VoiceList(SynthesizerModeDesc desc) {
        Voice[] v = desc.getVoices();
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                this.addVoice((BaseVoice)v[i]);
            }
        }
    }

    public void addVoice(BaseVoice voice) {
        if (!this.voiceList.contains((Object)voice)) {
            this.voiceList.add(voice);
        }
    }

    public void removeVoice(BaseVoice voice) {
        this.voiceList.remove((Object)voice);
    }

    public BaseVoice getVoiceById(String id) {
        for (int i = 0; i < this.voiceList.size(); ++i) {
            BaseVoice bv = this.voiceList.get(i);
            if (!bv.getId().equals(id)) continue;
            return bv;
        }
        return null;
    }

    public String getVoiceId(Voice voice, int variant) {
        BaseVoice bv;
        String id;
        if (voice instanceof BaseVoice && (id = (bv = (BaseVoice)voice).getId()) != null && id.length() > 0) {
            return id;
        }
        int[] indexes = new int[this.voiceList.size()];
        int count = 0;
        for (int i = 0; i < this.voiceList.size(); ++i) {
            BaseVoice bv2 = this.voiceList.get(i);
            if (!bv2.match(voice)) continue;
            if (variant <= 0) {
                return bv2.getId();
            }
            indexes[count++] = i;
        }
        if (count == 0) {
            return "";
        }
        variant = (variant - 1) % count;
        BaseVoice bv3 = this.voiceList.get(indexes[variant]);
        return bv3.getId();
    }

    public String getVoiceId(String name, int gender, int age, int variant) {
        String id;
        if (name != null && name.length() > 0 && (id = this.getVoiceId(new Voice(name, 65535, 65535, null), 0)) != null && id.length() > 0) {
            return id;
        }
        id = this.getVoiceId(new Voice(null, gender, age, null), variant);
        if (id != null && id.length() > 0) {
            return id;
        }
        int looseAge = age | age << 1 | age >> 1;
        id = this.getVoiceId(new Voice(null, gender, looseAge, null), variant);
        if (id != null && id.length() > 0) {
            return id;
        }
        id = this.getVoiceId(new Voice(null, gender, 65535, null), variant);
        if (id != null && id.length() > 0) {
            return id;
        }
        return "";
    }
}

