/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import javax.speech.synthesis.Voice;

public class BaseVoice
extends Voice {
    protected String voiceId;
    protected float defaultPitch;
    protected float defaultPitchRange;
    protected float defaultSpeakingRate;
    protected float defaultVolume;

    public BaseVoice(String id, String name, int gender, int age, String style, float pitch, float pitchRange, float speakingRate, float volume) {
        super(name, gender, age, style);
        this.voiceId = id;
        this.defaultPitch = pitch;
        this.defaultPitchRange = pitchRange;
        this.defaultSpeakingRate = speakingRate;
        this.defaultVolume = volume;
    }

    public String getId() {
        return this.voiceId;
    }

    public void setId(String id) {
        this.voiceId = id;
    }

    public float getPitch() {
        return this.defaultPitch;
    }

    public float getPitchRange() {
        return this.defaultPitchRange;
    }

    public float getSpeakingRate() {
        return this.defaultSpeakingRate;
    }

    public float getVolume() {
        return this.defaultVolume;
    }

    public Object clone() {
        return super.clone();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.getName() != null) {
            buf.append(this.getName());
        }
        buf.append(":");
        int gender = this.getGender();
        if (gender == 65535) {
            buf.append("GENDER_DONT_CARE");
        } else if ((gender & 2) != 0) {
            buf.append("GENDER_MALE");
        } else if ((gender & 1) != 0) {
            buf.append("GENDER_FEMALE");
        } else if ((gender & 4) != 0) {
            buf.append("GENDER_NEUTRAL");
        }
        buf.append(":");
        int age = this.getAge();
        if (age == 65535) {
            buf.append("AGE_DONT_CARE");
        } else if ((age & 1) != 0) {
            buf.append("AGE_CHILD");
        } else if ((age & 2) != 0) {
            buf.append("AGE_TEENAGER");
        } else if ((age & 4) != 0) {
            buf.append("AGE_YOUNGER_ADULT");
        } else if ((age & 8) != 0) {
            buf.append("AGE_MIDDLE_ADULT");
        } else if ((age & 0x10) != 0) {
            buf.append("AGE_OLDER_ADULT");
        }
        buf.append(":");
        if (this.getStyle() != null) {
            buf.append(this.getStyle());
        }
        return buf.toString();
    }
}

