/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.recognition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleAlternatives;
import javax.speech.recognition.RuleCount;
import javax.speech.recognition.RuleGrammar;
import javax.speech.recognition.RuleName;
import javax.speech.recognition.RuleParse;
import javax.speech.recognition.RuleSequence;
import javax.speech.recognition.RuleTag;
import javax.speech.recognition.RuleToken;

public class RuleParser {
    private Recognizer recognizer;

    public static RuleParse parse(String text, Recognizer recognizer, RuleGrammar grammar, String ruleName) {
        String[] inputTokens = RuleParser.tokenize(text);
        return RuleParser.parse(inputTokens, recognizer, grammar, ruleName);
    }

    public static RuleParse parse(String[] inputTokens, Recognizer recognognizer, RuleGrammar grammar, String ruleName) {
        List<RuleParse> list = RuleParser.mparse(inputTokens, recognognizer, grammar, ruleName);
        if (list != null) {
            for (RuleParse rp : list) {
                if (!grammar.isRulePublic(rp.getRuleName().getRuleName())) continue;
                return rp;
            }
        }
        return null;
    }

    public static List<RuleParse> mparse(String text, Recognizer R, RuleGrammar G, String ruleName) {
        String[] inputTokens = RuleParser.tokenize(text);
        return RuleParser.mparse(inputTokens, R, G, ruleName);
    }

    public static List<RuleParse> mparse(String[] inputTokens, Recognizer recognizer, RuleGrammar grammar, String ruleName) {
        String[] rNames;
        String[] stringArray;
        RuleParser rp = new RuleParser();
        rp.recognizer = recognizer;
        ArrayList<RuleParse> res = new ArrayList<RuleParse>();
        if (ruleName == null) {
            stringArray = grammar.listRuleNames();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ruleName;
        }
        for (String rName : rNames = stringArray) {
            if (ruleName == null && !grammar.isEnabled(rName)) continue;
            Rule startRule = grammar.getRule(rName);
            if (startRule == null) {
                System.out.println("BAD RULENAME " + rName);
                continue;
            }
            List<TokenPos> p = rp.parse(grammar, startRule, inputTokens, 0);
            if (p == null || p.isEmpty()) continue;
            for (TokenPos tp : p) {
                if (tp.getPos() != inputTokens.length) continue;
                res.add(new RuleParse(new RuleName(rName), (Rule)tp));
            }
        }
        return res.isEmpty() ? null : res;
    }

    private List<TokenPos> parse(RuleGrammar grammar, Rule r, String[] input, int pos) {
        if (r instanceof RuleName) {
            return this.parse(grammar, (RuleName)r, input, pos);
        }
        if (r instanceof RuleToken) {
            return this.parse(grammar, (RuleToken)r, input, pos);
        }
        if (r instanceof RuleCount) {
            return this.parse(grammar, (RuleCount)r, input, pos);
        }
        if (r instanceof RuleTag) {
            return this.parse(grammar, (RuleTag)r, input, pos);
        }
        if (r instanceof RuleSequence) {
            return this.parse(grammar, (RuleSequence)r, input, pos);
        }
        if (r instanceof RuleAlternatives) {
            return this.parse(grammar, (RuleAlternatives)r, input, pos);
        }
        System.out.println("ERROR UNKNOWN OBJECT " + r);
        return null;
    }

    private List<TokenPos> parse(RuleGrammar grammar, RuleName rn, String[] input, int pos) {
        List<TokenPos> p;
        String simpleName;
        if (rn.getFullGrammarName() == null) {
            rn.setRuleName(grammar.getName() + '.' + rn.getSimpleRuleName());
        }
        if ((simpleName = rn.getSimpleRuleName()).equals("VOID")) {
            return null;
        }
        if (simpleName.equals("NULL")) {
            ArrayList<TokenPos> res = new ArrayList<TokenPos>();
            res.add(new ParsedRuleParse(rn, (Rule)RuleName.NULL, pos));
            return res;
        }
        Rule ruleref = grammar.getRule(simpleName);
        if (rn.getFullGrammarName() != grammar.getName()) {
            ruleref = null;
        }
        if (ruleref == null) {
            String gname = rn.getFullGrammarName();
            if (gname != null && !gname.isEmpty()) {
                RuleGrammar RG1 = this.recognizer.getRuleGrammar(gname);
                if (RG1 != null) {
                    ruleref = RG1.getRule(simpleName);
                    grammar = RG1;
                } else {
                    System.out.println("ERROR: UNKNOWN GRAMMAR " + gname);
                }
            }
            if (ruleref == null) {
                System.out.println("ERROR: UNKNOWN RULE NAME " + rn.getRuleName() + ' ' + rn);
                return null;
            }
        }
        if ((p = this.parse(grammar, ruleref, input, pos)) == null) {
            return null;
        }
        ArrayList<TokenPos> res = new ArrayList<TokenPos>();
        for (TokenPos tp : p) {
            if (tp instanceof ParsedEmptyToken) {
                res.add(tp);
                continue;
            }
            try {
                res.add(new ParsedRuleParse(rn, (Rule)tp, tp.getPos()));
            }
            catch (IllegalArgumentException e) {
                System.out.println("ERROR " + e);
            }
        }
        return res;
    }

    private List<TokenPos> parse(RuleGrammar grammar, RuleToken rt, String[] input, int pos) {
        if (pos >= input.length) {
            return null;
        }
        String tText = rt.getText().toLowerCase();
        if (tText.equals(input[pos]) || input[pos].equals("%") || input[pos].equals("*")) {
            ArrayList<TokenPos> res = new ArrayList<TokenPos>();
            res.add(new ParsedRuleToken(rt.getText(), pos + 1));
            if (input[pos].equals("*")) {
                res.add(new ParsedRuleToken(rt.getText(), pos));
            }
            return res;
        }
        if (tText.indexOf(32) < 0) {
            return null;
        }
        if (!tText.startsWith(input[pos])) {
            return null;
        }
        String[] ta = RuleParser.tokenize(tText);
        for (int j = 0; j < ta.length; ++j) {
            if (pos >= input.length) {
                return null;
            }
            if (!ta[j].equals(input[pos])) {
                return null;
            }
            ++pos;
        }
        ArrayList<TokenPos> res = new ArrayList<TokenPos>();
        res.add(new ParsedRuleToken(rt.getText(), pos));
        return res;
    }

    private List<TokenPos> parse(RuleGrammar grammar, RuleAlternatives ra, String[] input, int pos) {
        ArrayList<TokenPos> res = new ArrayList<TokenPos>();
        for (Rule rule : ra.getRules()) {
            List<TokenPos> p = this.parse(grammar, rule, input, pos);
            if (p == null) continue;
            res.addAll(p);
        }
        return res;
    }

    private List<TokenPos> parse(RuleGrammar grammar, RuleSequence rs, String[] input, int pos) {
        Rule[] rarry = rs.getRules();
        if (rarry == null || rarry.length == 0) {
            return null;
        }
        List<TokenPos> p = this.parse(grammar, rarry[0], input, pos);
        if (p == null) {
            return null;
        }
        ArrayList<TokenPos> res = new ArrayList<TokenPos>();
        for (TokenPos tp : p) {
            int nPos = tp.getPos();
            if (rarry.length == 1) {
                if (tp instanceof ParsedEmptyToken) {
                    res.add(tp);
                    continue;
                }
                try {
                    res.add(new ParsedRuleSequence(new Rule[]{(Rule)tp}, tp.getPos()));
                }
                catch (IllegalArgumentException e) {
                    System.out.println(e);
                }
                continue;
            }
            Rule[] nra = Arrays.copyOfRange(rarry, 1, rarry.length);
            RuleSequence nrs = new RuleSequence(nra);
            List<TokenPos> q = this.parse(grammar, nrs, input, nPos);
            if (q == null) continue;
            for (TokenPos tp1 : q) {
                Rule[] ra;
                if (tp1 instanceof ParsedEmptyToken) {
                    res.add(tp);
                    continue;
                }
                if (tp instanceof ParsedEmptyToken) {
                    res.add(tp1);
                    continue;
                }
                if (tp1 instanceof RuleSequence) {
                    RuleSequence r2 = (RuleSequence)tp1;
                    Rule[] r2r = r2.getRules();
                    ra = new Rule[r2r.length + 1];
                    ra[0] = (Rule)tp;
                    System.arraycopy(r2r, 0, ra, 1, r2r.length);
                } else {
                    ra = new Rule[]{(Rule)tp, (Rule)tp1};
                }
                try {
                    res.add(new ParsedRuleSequence(ra, tp1.getPos()));
                }
                catch (IllegalArgumentException e) {
                    System.out.println(e);
                }
            }
        }
        return res;
    }

    private List<TokenPos> parse(RuleGrammar grammar, RuleTag rtag, String[] input, int pos) {
        String theTag = rtag.getTag();
        List<TokenPos> p = this.parse(grammar, rtag.getRule(), input, pos);
        if (p == null) {
            return null;
        }
        ArrayList<TokenPos> res = new ArrayList<TokenPos>();
        for (TokenPos tp : p) {
            if (tp instanceof ParsedEmptyToken) {
                res.add(tp);
                continue;
            }
            res.add(new ParsedRuleTag((Rule)tp, theTag, tp.getPos()));
        }
        return res;
    }

    private List<TokenPos> parse(RuleGrammar grammar, RuleCount rc, String[] input, int pos) {
        int rcount = rc.getCount();
        ParsedEmptyToken empty = new ParsedEmptyToken(pos);
        List<TokenPos> p = this.parse(grammar, rc.getRule(), input, pos);
        if (p == null) {
            if (rcount == RuleCount.ONCE_OR_MORE) {
                return null;
            }
            ArrayList<TokenPos> res = new ArrayList<TokenPos>();
            res.add(empty);
            return res;
        }
        if (rcount != RuleCount.ONCE_OR_MORE) {
            p.add(empty);
        }
        if (rcount == RuleCount.OPTIONAL) {
            return p;
        }
        for (int m = 2; m <= input.length - pos; ++m) {
            Object[] ar = new Rule[m];
            Arrays.fill(ar, rc.getRule());
            List<TokenPos> q = this.parse(grammar, new RuleSequence((Rule[])ar), input, pos);
            if (q == null) {
                return p;
            }
            p.addAll(q);
        }
        return p;
    }

    static String[] tokenize(String text) {
        StringTokenizer st = new StringTokenizer(text);
        int size = st.countTokens();
        String[] res = new String[size];
        int i = 0;
        while (st.hasMoreTokens()) {
            res[i++] = st.nextToken().toLowerCase();
        }
        return res;
    }

    class ParsedRuleParse
    extends RuleParse
    implements TokenPos {
        int pos;

        public ParsedRuleParse(RuleName rn, Rule r, int pos) throws IllegalArgumentException {
            super(rn, r);
            this.pos = pos;
        }

        @Override
        public int getPos() {
            return this.pos;
        }
    }

    class ParsedRuleSequence
    extends RuleSequence
    implements TokenPos {
        int pos;

        public ParsedRuleSequence(Rule[] rules, int pos) {
            super(rules);
            this.pos = pos;
        }

        @Override
        public int getPos() {
            return this.pos;
        }
    }

    class ParsedRuleTag
    extends RuleTag
    implements TokenPos {
        int pos;

        public ParsedRuleTag(Rule r, String x, int pos) {
            super(r, x);
            this.pos = pos;
        }

        @Override
        public int getPos() {
            return this.pos;
        }
    }

    class ParsedEmptyToken
    extends ParsedRuleToken {
        public ParsedEmptyToken(int pos) {
            super("EMPTY", pos);
        }
    }

    class ParsedRuleToken
    extends RuleToken
    implements TokenPos {
        int pos;

        public ParsedRuleToken(String x, int pos) {
            super(x);
            this.pos = pos;
        }

        @Override
        public int getPos() {
            return this.pos;
        }
    }

    static interface TokenPos {
        public int getPos();
    }
}

