/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.recognition;

import com.sun.speech.engine.BaseAudioManager;
import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import javax.speech.AudioListener;
import javax.speech.SpeechEvent;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.RecognizerAudioEvent;
import javax.speech.recognition.RecognizerAudioListener;

public class BaseRecognizerAudioManager
extends BaseAudioManager
implements SpeechEventDispatcher {
    public void postAudioLevel(Recognizer source, float audioLevel) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new RecognizerAudioEvent(source, 1102, audioLevel));
    }

    public void fireAudioLevel(RecognizerAudioEvent event) {
        for (AudioListener al : this.listeners) {
            if (!(al instanceof RecognizerAudioListener)) continue;
            ((RecognizerAudioListener)al).audioLevel(event);
        }
    }

    public void postSpeechStarted(Recognizer source) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new RecognizerAudioEvent(source, 1100));
    }

    public void fireSpeechStarted(RecognizerAudioEvent event) {
        for (AudioListener al : this.listeners) {
            if (!(al instanceof RecognizerAudioListener)) continue;
            ((RecognizerAudioListener)al).speechStarted(event);
        }
    }

    public void postSpeechStopped(Recognizer source) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new RecognizerAudioEvent(source, 1101));
    }

    public void fireSpeechStopped(RecognizerAudioEvent event) {
        for (AudioListener al : this.listeners) {
            if (!(al instanceof RecognizerAudioListener)) continue;
            ((RecognizerAudioListener)al).speechStopped(event);
        }
    }

    @Override
    public void dispatchSpeechEvent(SpeechEvent event) {
        switch (event.getId()) {
            case 1102: {
                this.fireAudioLevel((RecognizerAudioEvent)event);
                break;
            }
            case 1100: {
                this.fireSpeechStarted((RecognizerAudioEvent)event);
                break;
            }
            case 1101: {
                this.fireSpeechStopped((RecognizerAudioEvent)event);
            }
        }
    }
}

