/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.SpeechEventWrapper;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.speech.EngineProperties;
import javax.speech.SpeechError;
import javax.speech.SpeechEvent;

public abstract class BaseEngineProperties
implements EngineProperties,
SpeechEventDispatcher {
    protected final List<PropertyChangeListener> propertyChangeListeners = new ArrayList<PropertyChangeListener>();

    public Component getControlComponent() {
        return null;
    }

    public abstract void reset();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected void postPropertyChangeEvent(String propName, Object oldValue, Object newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, oldValue, newValue);
        SpeechEventWrapper se = new SpeechEventWrapper(e);
        SpeechEventUtilities.postSpeechEvent(this, se);
    }

    protected void postPropertyChangeEvent(String propName, float oldValue, float newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, Float.valueOf(oldValue), Float.valueOf(newValue));
        SpeechEventWrapper se = new SpeechEventWrapper(e);
        SpeechEventUtilities.postSpeechEvent(this, se);
    }

    protected void postPropertyChangeEvent(String propName, int oldValue, int newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, oldValue, newValue);
        SpeechEventWrapper se = new SpeechEventWrapper(e);
        SpeechEventUtilities.postSpeechEvent(this, se);
    }

    protected void postPropertyChangeEvent(String propName, boolean oldValue, boolean newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, oldValue, newValue);
        SpeechEventWrapper se = new SpeechEventWrapper(e);
        SpeechEventUtilities.postSpeechEvent(this, se);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener pl : this.propertyChangeListeners) {
            pl.propertyChange(event);
        }
    }

    @Override
    public void dispatchSpeechEvent(SpeechEvent event) {
        if (!(event instanceof SpeechEventWrapper)) {
            throw new SpeechError("BaseEngineProperties: speech event type error");
        }
        SpeechEventWrapper se = (SpeechEventWrapper)event;
        PropertyChangeEvent pe = (PropertyChangeEvent)se.getEventObject();
        this.firePropertyChangeEvent(pe);
    }
}

