/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import marytts.datatypes.MaryXML;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NumberEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"number", "number:float", "number:integer", "number:ordinal", "number:roman", "number:digits", "number:cardinal"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    protected static final String sFloat = "(?:-?(?:[1-9][0-9]{0,8}|0)?(?:\\.|,)[0-9]+)";
    protected static final String sInteger = "(?:-?[1-9][0-9]{0,8}|0)";
    protected static final String sOrdinal = "(?:(?:-?[1-9][0-9]{0,8}|0)\\.)";
    protected static final String sRoman = "(?:[MDCLXVI]+\\.?)";
    protected static final String sDigits = "(?:[0-9.,]*[0-9][.,]?)";
    protected static final String sCardinal = "(?:-?(?:[1-9][0-9]{0,8}|0)?(?:\\.|,)[0-9]+)|(?:-?[1-9][0-9]{0,8}|0)";
    protected final Pattern reFloat = Pattern.compile("(?:-?(?:[1-9][0-9]{0,8}|0)?(?:\\.|,)[0-9]+)");
    protected final Pattern reInteger = Pattern.compile("(?:-?[1-9][0-9]{0,8}|0)");
    protected final Pattern reOrdinal = Pattern.compile("(?:(?:-?[1-9][0-9]{0,8}|0)\\.)");
    protected final Pattern reRoman = Pattern.compile("(?:[MDCLXVI]+\\.?)");
    protected final Pattern reDigits = Pattern.compile("(?:[0-9.,]*[0-9][.,]?)");
    private final Pattern reMatchingChars = null;
    private Logger logger = MaryUtils.getLogger((String)"NumberEP");

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    @Override
    protected boolean allowMultipleTokens() {
        return false;
    }

    @Override
    protected boolean isCandidate(Element t) {
        String s = MaryDomUtils.tokenText((Element)t);
        return this.reFloat.matcher(s).matches() || this.reInteger.matcher(s).matches() || this.reOrdinal.matcher(s).matches() || this.reRoman.matcher(s).matches() || this.reDigits.matcher(s).matches();
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (this.matchFloat(s)) {
                    return 1;
                }
                if (this.matchInteger(s)) {
                    return 2;
                }
                if (this.matchOrdinal(s)) {
                    return 3;
                }
                if (!this.matchDigits(s)) break;
                return 5;
            }
            case 1: {
                if (!this.matchFloat(s)) break;
                return 1;
            }
            case 2: {
                if (!this.matchInteger(s)) break;
                return 2;
            }
            case 3: {
                if (!this.matchOrdinal(s)) break;
                return 3;
            }
            case 4: {
                if (!this.matchRoman(s)) break;
                return 4;
            }
            case 5: {
                if (!this.matchDigits(s)) break;
                return 5;
            }
            case 6: {
                if (this.matchInteger(s)) {
                    return 2;
                }
                if (!this.matchFloat(s)) break;
                return 1;
            }
        }
        return -1;
    }

    @Override
    protected int canDealWith(String input, int typeCode) {
        switch (typeCode) {
            case 0: {
                if (this.matchFloat(input)) {
                    return 1;
                }
                if (this.matchInteger(input)) {
                    return 2;
                }
                if (this.matchOrdinal(input)) {
                    return 3;
                }
                if (this.matchRoman(input)) {
                    return 4;
                }
                if (!this.matchDigits(input)) break;
                return 5;
            }
            case 1: {
                if (!this.matchFloat(input)) break;
                return 1;
            }
            case 2: {
                if (!this.matchInteger(input) && !this.matchRoman(input)) break;
                return 2;
            }
            case 3: {
                if (!this.matchOrdinal(input) && !this.matchInteger(input) && !this.matchRoman(input)) break;
                return 3;
            }
            case 4: {
                if (!this.matchRoman(input)) break;
                return 4;
            }
            case 5: {
                if (!this.matchDigits(input)) break;
                return 5;
            }
            case 6: {
                if (this.matchInteger(input)) {
                    return 2;
                }
                if (!this.matchFloat(input)) break;
                return 1;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = tokens.get(0).getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 1: {
                expanded = this.expandFloat(doc, s, true);
                break;
            }
            case 2: {
                expanded = this.expandInteger(doc, s, true);
                break;
            }
            case 3: {
                expanded = this.expandOrdinal(doc, s, true);
                break;
            }
            case 4: {
                expanded = this.expandRoman(doc, s, true);
                break;
            }
            case 5: {
                expanded = this.expandDigits(doc, s, true);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    protected boolean matchFloat(String s) {
        return this.reFloat.matcher(s).matches();
    }

    protected boolean matchInteger(String s) {
        return this.reInteger.matcher(s).matches();
    }

    protected boolean matchOrdinal(String s) {
        return this.reOrdinal.matcher(s).matches();
    }

    protected boolean matchRoman(String s) {
        return this.reRoman.matcher(s).matches();
    }

    protected boolean matchDigits(String s) {
        return this.reDigits.matcher(s).matches();
    }

    protected List<Element> expandInteger(Document doc, String s, boolean createMtu) {
        long value;
        if (this.matchRoman(s)) {
            return this.expandRoman(doc, s, createMtu, false);
        }
        try {
            while (s.length() > 1 && s.startsWith("0")) {
                s = s.substring(1);
            }
            value = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            this.logger.info((Object)("Cannot convert string \"" + s + "\" to long."));
            throw e;
        }
        return this.expandInteger(doc, value, createMtu, s);
    }

    protected List<Element> expandInteger(Document doc, long value, boolean createMtu, String orig) {
        String expString = this.expandInteger(value);
        return this.makeNewTokens(doc, expString, createMtu, orig);
    }

    protected String expandInteger(String s) {
        long value;
        try {
            while (s.length() > 1 && s.startsWith("0")) {
                s = s.substring(1);
            }
            value = Long.decode(s);
        }
        catch (NumberFormatException e) {
            this.logger.info((Object)("Cannot convert string \"" + s + "\" to long."));
            throw e;
        }
        return this.expandInteger(value);
    }

    protected String expandInteger(long value) {
        StringBuilder buf = new StringBuilder();
        if (value == 0L) {
            return new String("null");
        }
        if (value < 0L) {
            buf.append("Minus ");
        }
        long millions = value / 1000000L;
        int rest = (int)value % 1000000;
        if (millions > 1L) {
            buf.append(this.expandInteger(millions));
            buf.append(" ");
            buf.append("Millionen ");
        } else if (millions == 1L) {
            buf.append("eine Million ");
        }
        int thousands = rest / 1000;
        rest %= 1000;
        if (thousands > 1) {
            buf.append(this.expandInteger(thousands));
            buf.append(" ");
            buf.append("Tausend ");
        } else if (thousands == 1) {
            buf.append("ein Tausend ");
        }
        int hundreds = rest / 100;
        rest %= 100;
        if (hundreds > 1) {
            buf.append(this.expandInteger(hundreds));
            buf.append(" ");
            buf.append("Hundert ");
        } else if (hundreds == 1) {
            buf.append("ein Hundert ");
        }
        if (rest >= 20) {
            int tens = rest / 10;
            switch (rest %= 10) {
                case 1: {
                    buf.append("einund");
                    break;
                }
                case 2: {
                    buf.append("zweiund");
                    break;
                }
                case 3: {
                    buf.append("dreiund");
                    break;
                }
                case 4: {
                    buf.append("vierund");
                    break;
                }
                case 5: {
                    buf.append("f\u00fcnfund");
                    break;
                }
                case 6: {
                    buf.append("sechsund");
                    break;
                }
                case 7: {
                    buf.append("siebenund");
                    break;
                }
                case 8: {
                    buf.append("achtund");
                    break;
                }
                case 9: {
                    buf.append("neunund");
                    break;
                }
            }
            switch (tens) {
                case 2: {
                    buf.append("zwanzig ");
                    break;
                }
                case 3: {
                    buf.append("drei\u00dfig ");
                    break;
                }
                case 4: {
                    buf.append("vierzig ");
                    break;
                }
                case 5: {
                    buf.append("f\u00fcnfzig ");
                    break;
                }
                case 6: {
                    buf.append("sechzig ");
                    break;
                }
                case 7: {
                    buf.append("siebzig ");
                    break;
                }
                case 8: {
                    buf.append("achtzig ");
                    break;
                }
                case 9: {
                    buf.append("neunzig ");
                    break;
                }
            }
        } else {
            switch (rest) {
                case 1: {
                    buf.append("eins ");
                    break;
                }
                case 2: {
                    buf.append("zwei ");
                    break;
                }
                case 3: {
                    buf.append("drei ");
                    break;
                }
                case 4: {
                    buf.append("vier ");
                    break;
                }
                case 5: {
                    buf.append("f\u00fcnf ");
                    break;
                }
                case 6: {
                    buf.append("sechs ");
                    break;
                }
                case 7: {
                    buf.append("sieben ");
                    break;
                }
                case 8: {
                    buf.append("acht ");
                    break;
                }
                case 9: {
                    buf.append("neun ");
                    break;
                }
                case 10: {
                    buf.append("zehn ");
                    break;
                }
                case 11: {
                    buf.append("elf ");
                    break;
                }
                case 12: {
                    buf.append("zw\u00f6lf ");
                    break;
                }
                case 13: {
                    buf.append("dreizehn ");
                    break;
                }
                case 14: {
                    buf.append("vierzehn ");
                    break;
                }
                case 15: {
                    buf.append("f\u00fcnfzehn ");
                    break;
                }
                case 16: {
                    buf.append("sechzehn ");
                    break;
                }
                case 17: {
                    buf.append("siebzehn ");
                    break;
                }
                case 18: {
                    buf.append("achtzehn ");
                    break;
                }
                case 19: {
                    buf.append("neunzehn ");
                    break;
                }
            }
        }
        return buf.toString().trim();
    }

    protected List<Element> expandFloat(Document doc, String s, boolean createMtu) {
        String expString = this.expandFloat(s);
        return this.makeNewTokens(doc, expString, createMtu, s);
    }

    protected String expandFloat(String number) {
        int i;
        long whole = 0L;
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < number.length() && Character.isDigit(number.charAt(i)); ++i) {
            whole *= 10L;
            whole += (long)(number.charAt(i) - 48);
        }
        buf.append(this.expandInteger(whole));
        buf.append(" ");
        if (i < number.length()) {
            buf.append(this.expandDigits(number.substring(i)));
        }
        return buf.toString().trim();
    }

    protected List<Element> expandDigits(Document doc, String s, boolean createMtu) {
        String expString = this.expandDigits(s);
        return this.makeNewTokens(doc, expString, createMtu, s);
    }

    protected String expandDigits(String digits) {
        StringBuilder buf = new StringBuilder();
        block14: for (int i = 0; i < digits.length(); ++i) {
            switch (digits.charAt(i)) {
                case ',': {
                    buf.append("Komma ");
                    continue block14;
                }
                case '.': {
                    buf.append("Punkt ");
                    continue block14;
                }
                case '0': {
                    buf.append("null ");
                    continue block14;
                }
                case '1': {
                    buf.append("eins ");
                    continue block14;
                }
                case '2': {
                    buf.append("zwei ");
                    continue block14;
                }
                case '3': {
                    buf.append("drei ");
                    continue block14;
                }
                case '4': {
                    buf.append("vier ");
                    continue block14;
                }
                case '5': {
                    buf.append("f\u00fcnf ");
                    continue block14;
                }
                case '6': {
                    buf.append("sechs ");
                    continue block14;
                }
                case '7': {
                    buf.append("sieben ");
                    continue block14;
                }
                case '8': {
                    buf.append("acht ");
                    continue block14;
                }
                case '9': {
                    buf.append("neun ");
                    continue block14;
                }
                default: {
                    buf.append(digits.charAt(i));
                    buf.append(' ');
                }
            }
        }
        return buf.toString().trim();
    }

    protected List<Element> expandOrdinal(Document doc, String s, boolean createMtu) {
        long value;
        if (this.matchRoman(s)) {
            return this.expandRoman(doc, s, createMtu, true);
        }
        String intString = this.matchInteger(s) ? s : s.substring(0, s.length() - 1);
        try {
            while (intString.length() > 1 && intString.startsWith("0")) {
                intString = intString.substring(1);
            }
            value = Long.decode(intString);
        }
        catch (NumberFormatException e) {
            this.logger.info((Object)("Cannot convert string \"" + intString + "\" to long."));
            throw e;
        }
        return this.expandOrdinal(doc, value, createMtu, s);
    }

    protected List<Element> expandOrdinal(Document doc, long value, boolean createMtu, String orig) {
        StringBuilder exp = new StringBuilder();
        int rest = (int)value % 100;
        if (Math.abs(value) >= 100L) {
            exp.append(this.expandInteger(value - (long)rest));
            if (rest != 0) {
                exp.append(" ");
            }
        }
        switch (rest) {
            case 0: {
                if (value != 0L) break;
                exp.append("null");
                break;
            }
            case 1: {
                exp.append("ers");
                break;
            }
            case 3: {
                exp.append("drit");
                break;
            }
            case 7: {
                exp.append("sieb");
                break;
            }
            case 8: {
                exp.append("ach");
                break;
            }
            default: {
                exp.append(this.expandInteger(rest));
            }
        }
        if (rest == 0 && value != 0L || rest >= 20) {
            exp.append("s");
        }
        exp.append("te");
        Element t = MaryXML.createElement((Document)doc, (String)"t");
        MaryDomUtils.setTokenText((Element)t, (String)orig);
        t.setAttribute("sounds_like", exp.toString());
        t.setAttribute("ending", "ordinal");
        t.setAttribute("pos", "ADJA");
        ArrayList<Element> result = new ArrayList<Element>();
        if (createMtu) {
            Element mtu = MaryXML.createElement((Document)doc, (String)"mtu");
            mtu.setAttribute("orig", orig);
            mtu.appendChild(t);
            result.add(mtu);
        } else {
            result.add(t);
        }
        return result;
    }

    protected List<Element> expandRoman(Document doc, String number, boolean createMtu) {
        boolean isOrdinal = false;
        if (number.charAt(number.length() - 1) == '.') {
            isOrdinal = true;
            number = number.substring(0, number.length() - 1);
        }
        return this.expandRoman(doc, number, createMtu, isOrdinal);
    }

    protected List<Element> expandRoman(Document doc, String number, boolean createMtu, boolean isOrdinal) {
        if (number.charAt(number.length() - 1) == '.') {
            number = number.substring(0, number.length() - 1);
        }
        int value = MaryUtils.romanToInt((String)number);
        if (isOrdinal) {
            return this.expandOrdinal(doc, value, createMtu, number);
        }
        return this.expandInteger(doc, value, createMtu, number);
    }
}

