/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.phonemiser;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import marytts.language.de.JPhonemiser;
import marytts.language.de.phonemiser.MorphologyReader;
import marytts.language.de.phonemiser.Result;
import marytts.language.de.phonemiser.Word;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class PhonemiseDenglish {
    private static Logger logger = MaryUtils.getLogger((String)"PhonemiseDenglish");
    private String[] vowels = new String[]{"a", "e", "i", "o", "u"};
    private String[] dentalPlosives = new String[]{"t", "d"};
    private Hashtable<String, String> flectionToPhon = null;
    private Hashtable<String, String> prefixLexicon = null;
    private Hashtable<String, String> endingsAndAffixes = null;
    private Hashtable<String, String> terminalVoicings = null;
    private HashSet<String> endingSet = null;
    private int maxEndingLength = 0;
    private int maxPrefixLength = 0;
    private Locale locale;
    private JPhonemiser jphon = null;
    private MorphologyReader mr = new MorphologyReader();

    public PhonemiseDenglish(JPhonemiser jphon) throws Exception {
        this.jphon = jphon;
        String classpathPrefix = "/marytts/language/de/lexicon/denglish/";
        this.flectionToPhon = this.mr.loadInputModel(this.getClass().getResourceAsStream(classpathPrefix + "flectionsPhonLex.xml"));
        this.prefixLexicon = this.mr.loadInputModel(this.getClass().getResourceAsStream(classpathPrefix + "PrefixLex.xml"));
        for (String prefix : this.prefixLexicon.keySet()) {
            if (prefix.length() <= this.maxPrefixLength) continue;
            this.maxPrefixLength = prefix.length();
        }
        this.endingsAndAffixes = this.mr.loadInputModel(this.getClass().getResourceAsStream(classpathPrefix + "germanEndings.xml"));
        this.terminalVoicings = this.mr.loadInputModel(this.getClass().getResourceAsStream(classpathPrefix + "terminal_voicing_for_german.xml"));
        String[] endingList = this.getEndingsAndAffixes("flections");
        if (endingList != null) {
            this.endingSet = new HashSet(50);
            for (int j = 0; j < endingList.length; ++j) {
                if (endingList[j].length() > this.maxEndingLength) {
                    this.maxEndingLength = endingList[j].length();
                }
                this.endingSet.add(endingList[j]);
            }
        }
    }

    public Result processWord(String toBePhonemised, boolean allowOtherLanguage) {
        Word currentWord = new Word(toBePhonemised);
        String transcription = null;
        Result currentResult = new Result();
        long time1 = System.currentTimeMillis();
        if (currentWord.getToBePhonemised().equals("")) {
            logger.debug((Object)"Empty String!");
            return currentResult;
        }
        if (currentWord.getToBePhonemised().length() <= 2) {
            logger.debug((Object)"Input to short to be a deng item");
            logger.debug((Object)"Now using letter to sound rules");
            return currentResult;
        }
        transcription = this.processFlection(currentWord, currentResult, allowOtherLanguage);
        if (transcription != null) {
            long time2 = System.currentTimeMillis();
            long end = time2 - time1;
            logger.debug((Object)("Processing took: " + end + " ms"));
            currentResult.setTranscription(transcription);
            return currentResult;
        }
        transcription = this.compoundAnalysis(currentWord, currentResult, false);
        if (transcription != null) {
            long time3 = System.currentTimeMillis();
            long end = time3 - time1;
            logger.debug((Object)("Processing took: " + end + " ms"));
            currentResult.setTranscription(transcription);
            return currentResult;
        }
        transcription = this.compoundAnalysis(currentWord, currentResult, allowOtherLanguage);
        if (transcription != null) {
            long time3 = System.currentTimeMillis();
            long end = time3 - time1;
            logger.debug((Object)("Processing took: " + end + " ms"));
            currentResult.setTranscription(transcription);
            return currentResult;
        }
        return currentResult;
    }

    private String processFlection(Word word, Result currentResult, boolean allowOtherLanguage) {
        int maxPrefLen;
        String toBePhonemised = word.getToBePhonemised();
        logger.debug((Object)("processFlection is starting with: " + toBePhonemised));
        String transcription = this.jphon.userdictLookup(toBePhonemised, null);
        if (transcription != null) {
            return transcription;
        }
        transcription = this.jphon.lexiconLookup(toBePhonemised, null);
        if (transcription != null) {
            return transcription;
        }
        if (allowOtherLanguage) {
            transcription = this.processFlectionEnding(word, currentResult);
        }
        if (transcription != null) {
            return transcription;
        }
        for (int i = maxPrefLen = Math.min(this.maxPrefixLength, word.getToBePhonemised().length() - 3); i > 0; --i) {
            String prefix = word.getToBePhonemised().substring(0, i).toLowerCase();
            String prefixPhon = this.prefixLexiconLookup(prefix);
            if (prefixPhon == null) continue;
            logger.debug((Object)("Prefix found: " + prefix + " [" + prefixPhon + "]"));
            Word partialWord = new Word(word.getToBePhonemised().substring(i));
            String restTranscription = this.processFlection(partialWord, currentResult, allowOtherLanguage);
            if (restTranscription == null) continue;
            if (prefixPhon.indexOf("'") != -1) {
                restTranscription = restTranscription.replaceAll("'", "");
            }
            transcription = prefixPhon + "-" + restTranscription;
            return transcription;
        }
        return null;
    }

    private String processFlectionEnding(Word word, Result currentResult) {
        String toBePhonemised = word.getToBePhonemised();
        logger.debug((Object)("processFlectionEnding is starting with: " + toBePhonemised));
        String wordMinusFlectionEnding = null;
        String flectionEnding = null;
        String result = null;
        String[] wordPlusEnding = this.separateFlectionEndings(toBePhonemised, this.maxEndingLength);
        if (wordPlusEnding != null) {
            wordMinusFlectionEnding = wordPlusEnding[0];
            flectionEnding = wordPlusEnding[1];
            if ((word = this.transformWordToEnBaseForm(wordMinusFlectionEnding, flectionEnding, word)).getOtherLanguageBaseForm() != null) {
                word.setFlectionEnding(flectionEnding);
                result = this.transcribeFlection(word, currentResult);
            } else {
                int currentEndingLength = flectionEnding.length();
                wordPlusEnding = this.separateFlectionEndings(toBePhonemised, currentEndingLength - 1);
                if (wordPlusEnding != null) {
                    wordMinusFlectionEnding = wordPlusEnding[0];
                    flectionEnding = wordPlusEnding[1];
                    if ((word = this.transformWordToEnBaseForm(wordMinusFlectionEnding, flectionEnding, word)).getOtherLanguageBaseForm() != null) {
                        word.setFlectionEnding(flectionEnding);
                        result = this.transcribeFlection(word, currentResult);
                    } else {
                        currentEndingLength = flectionEnding.length();
                        wordPlusEnding = this.separateFlectionEndings(toBePhonemised, currentEndingLength - 1);
                        if (wordPlusEnding != null && (word = this.transformWordToEnBaseForm(wordMinusFlectionEnding = wordPlusEnding[0], flectionEnding = wordPlusEnding[1], word)).getOtherLanguageBaseForm() != null) {
                            word.setFlectionEnding(flectionEnding);
                            result = this.transcribeFlection(word, currentResult);
                        }
                    }
                } else if ((word = this.transformWordToEnBaseForm(toBePhonemised, null, word)).getOtherLanguageBaseForm() != null) {
                    result = this.transcribeFlection(word, currentResult);
                } else {
                    logger.debug((Object)"Unable to transcribe flection. Returning null.");
                }
            }
        }
        logger.debug((Object)("processFlection: " + result));
        return result;
    }

    private String compoundAnalysis(Word word, Result currentResult, boolean allowOtherLanguage) {
        logger.debug((Object)("compoundAnalysis is starting with: " + word.getToBePhonemised()));
        for (int i = word.getToBePhonemised().length() - 3; i >= 3; --i) {
            String[] helper;
            String firstPhon = null;
            String fugePhon = null;
            String restPhon = null;
            String[] genitiveAccusativeAndPluralEndings = this.getEndingsAndAffixes("noun_genitive_accusative_and_plural_endings");
            String prefix = word.getToBePhonemised().substring(0, i);
            logger.debug((Object)("Pre: " + prefix));
            firstPhon = this.jphon.userdictLookup(prefix, null);
            if (firstPhon == null) {
                firstPhon = this.jphon.lexiconLookup(prefix, null);
            }
            if (firstPhon == null && allowOtherLanguage && (firstPhon = this.jphon.phonemiseEn(prefix)) != null) {
                currentResult.setUsedOtherLanguageToPhonemise(true);
            }
            if (firstPhon == null) continue;
            String rest = word.getToBePhonemised().substring(i);
            logger.debug((Object)("Rest is: " + rest));
            restPhon = this.prefixLexiconLookup(rest);
            logger.debug((Object)("RestPhon: " + restPhon));
            if (restPhon == null) {
                restPhon = this.jphon.userdictLookup(rest, null);
            }
            if (restPhon == null) {
                restPhon = this.jphon.lexiconLookup(rest, null);
            }
            if (restPhon == null && allowOtherLanguage && (restPhon = this.jphon.phonemiseEn(rest)) != null) {
                currentResult.setUsedOtherLanguageToPhonemise(true);
            }
            if (restPhon == null) {
                for (int j = 0; j < genitiveAccusativeAndPluralEndings.length; ++j) {
                    if (rest.endsWith(genitiveAccusativeAndPluralEndings[j])) {
                        String restPhonEn;
                        logger.debug((Object)("rest ends with: " + genitiveAccusativeAndPluralEndings[j]));
                        String restWithoutLast = rest.substring(0, rest.length() - 1);
                        String restPhonDe = this.jphon.userdictLookup(restWithoutLast, null);
                        if (restPhonDe == null) {
                            restPhonDe = this.jphon.lexiconLookup(restWithoutLast, null);
                        }
                        String genitiveAndPluralEndingTrans = this.endingTranscriptionLookup(genitiveAccusativeAndPluralEndings[j]);
                        if (restPhonDe != null) {
                            restPhon = restPhonDe + genitiveAndPluralEndingTrans;
                        } else if (allowOtherLanguage && (restPhonEn = this.jphon.phonemiseEn(rest.substring(0, rest.length() - 1))) != null) {
                            currentResult.setUsedOtherLanguageToPhonemise(true);
                            restPhon = restPhonEn + genitiveAndPluralEndingTrans;
                        }
                    }
                    if (restPhon != null) break;
                }
            }
            if (restPhon == null && (helper = this.fugeSearch(rest)) != null && helper.length == 2) {
                fugePhon = helper[0];
                String rest2 = helper[1];
                restPhon = this.jphon.userdictLookup(rest2, null);
                if (restPhon == null) {
                    restPhon = this.jphon.lexiconLookup(rest2, null);
                }
                if (restPhon == null && allowOtherLanguage && (restPhon = this.jphon.phonemiseEn(rest2)) != null) {
                    currentResult.setUsedOtherLanguageToPhonemise(true);
                }
                if (restPhon == null) {
                    restPhon = this.compoundAnalysis(new Word(rest2), currentResult, allowOtherLanguage);
                }
            }
            if (restPhon == null) {
                restPhon = this.processFlection(new Word(rest), currentResult, allowOtherLanguage);
            }
            if (restPhon == null) {
                restPhon = this.compoundAnalysis(new Word(rest), currentResult, allowOtherLanguage);
            }
            if (restPhon == null) continue;
            restPhon = restPhon.replaceAll("'", "");
            return firstPhon + (fugePhon != null ? fugePhon : "") + "-" + restPhon;
        }
        return null;
    }

    private String[] fugeSearch(String suffix) {
        String fugePhon = null;
        int fugeLength = 0;
        String[] validFuges = this.getEndingsAndAffixes("compound_fuge");
        for (int j = 0; j < validFuges.length; ++j) {
            if (!suffix.startsWith(validFuges[j])) continue;
            fugePhon = this.endingTranscriptionLookup(validFuges[j]);
            fugeLength = validFuges[j].length();
            break;
        }
        if (fugePhon != null) {
            String[] returnValue = new String[]{fugePhon, suffix.substring(fugeLength)};
            return returnValue;
        }
        return null;
    }

    private String[] separateFlectionEndings(String toBePhonemised, int endingLength) {
        String wordMinusFlectionEnding = null;
        String flectionEnding = this.knowEnding(toBePhonemised, endingLength);
        if (flectionEnding != null) {
            wordMinusFlectionEnding = toBePhonemised.substring(0, toBePhonemised.length() - flectionEnding.length());
            String[] wordPlusEnding = new String[]{wordMinusFlectionEnding, flectionEnding};
            return wordPlusEnding;
        }
        return null;
    }

    private Word transformWordToEnBaseForm(String wordMinusFlectionEnding, String flectionEnding, Word word) {
        logger.debug((Object)("getEnBaseForm is starting with...: " + wordMinusFlectionEnding));
        String[] participleBaseLong = this.getEndingsAndAffixes("participle_base_long");
        String[] participleBaseShort = this.getEndingsAndAffixes("participle_base_short");
        String wordMinusFlectionEndingPenultimateChar = null;
        String wordMinusFlectionEndingUltimateChar = null;
        if (wordMinusFlectionEnding.length() > 2) {
            wordMinusFlectionEndingPenultimateChar = wordMinusFlectionEnding.substring(wordMinusFlectionEnding.length() - 2, wordMinusFlectionEnding.length() - 1);
        }
        if (wordMinusFlectionEnding.length() > 1) {
            wordMinusFlectionEndingUltimateChar = wordMinusFlectionEnding.substring(wordMinusFlectionEnding.length() - 1, wordMinusFlectionEnding.length());
        }
        String wordMinusFlectionEndingLastTwo = wordMinusFlectionEndingPenultimateChar + wordMinusFlectionEndingUltimateChar;
        if (wordMinusFlectionEnding.length() > 3) {
            if (this.knowEnBaseForm(wordMinusFlectionEnding)) {
                if (flectionEnding != null) {
                    if (this.isLongParticipleBaseEnding(flectionEnding, participleBaseLong) || this.isShortParticipleBaseEnding(flectionEnding, participleBaseShort)) {
                        word.setOtherLanguageBaseForm(wordMinusFlectionEnding);
                        word.setCouldBeParticiple(true);
                        word.setCouldBeParticipleInBaseForm(true);
                    } else if (this.endsWithVowel(wordMinusFlectionEnding)) {
                        word.setOtherLanguageBaseForm(wordMinusFlectionEnding);
                        word.setWordMinusFlectionEndsWithVowel(true);
                        word.setCouldBeParticiple(true);
                    } else {
                        word.setOtherLanguageBaseForm(wordMinusFlectionEnding);
                    }
                } else {
                    word.setOtherLanguageBaseForm(wordMinusFlectionEnding);
                    logger.debug((Object)"wordMinusFlectionEnding is already enBaseForm");
                }
            }
            if (word.getOtherLanguageBaseForm() == null) {
                for (int j = 1; j < 3; ++j) {
                    logger.debug((Object)("new(2a): " + wordMinusFlectionEnding.substring(0, wordMinusFlectionEnding.length() - j)));
                    if (this.knowEnBaseForm(wordMinusFlectionEnding.substring(0, wordMinusFlectionEnding.length() - j)) && (this.isLongParticipleBaseEnding(wordMinusFlectionEndingLastTwo, participleBaseLong) || this.isShortParticipleBaseEnding(wordMinusFlectionEndingUltimateChar, participleBaseShort) && (!this.isShortParticipleBaseEnding(wordMinusFlectionEndingUltimateChar, participleBaseShort) || !this.isShortParticipleBaseEnding(wordMinusFlectionEndingPenultimateChar, participleBaseShort)))) {
                        word.setOtherLanguageBaseForm(wordMinusFlectionEnding.substring(0, wordMinusFlectionEnding.length() - j));
                        word.setCouldBeParticiple(true);
                        word.setCutOffCharacter(true);
                        logger.debug((Object)"new(2a)");
                    }
                    if (word.getOtherLanguageBaseForm() != null) break;
                }
            }
            if (word.getOtherLanguageBaseForm() == null) {
                logger.debug((Object)("in geminate clause: " + wordMinusFlectionEnding));
                if (wordMinusFlectionEndingUltimateChar.equals(wordMinusFlectionEndingPenultimateChar) && this.knowEnBaseForm(wordMinusFlectionEnding.substring(0, wordMinusFlectionEnding.length() - 1))) {
                    word.setOtherLanguageBaseForm(wordMinusFlectionEnding.substring(0, wordMinusFlectionEnding.length() - 1));
                    logger.debug((Object)"geminate.......");
                }
            }
            if (word.getOtherLanguageBaseForm() == null) {
                word.setIsVerbalGerund(this.checkIfGerund(wordMinusFlectionEnding));
                if (word.getIsVerbalGerund()) {
                    word.setOtherLanguageBaseForm(this.transformWordToEnBaseFormGerund(wordMinusFlectionEnding));
                }
            }
        }
        logger.debug((Object)("finally enBaseForm: " + word.getOtherLanguageBaseForm()));
        return word;
    }

    private String transformWordToEnBaseFormGerund(String word) {
        logger.debug((Object)("getBaseFormGerund called with: " + word));
        String enBaseForm = null;
        String[] flectionFuge = this.getEndingsAndAffixes("flection_fuge");
        logger.debug((Object)"found gerund..........");
        for (int j = 0; j < flectionFuge.length; ++j) {
            if (this.knowEnBaseForm(word.substring(0, word.length() - 3) + flectionFuge[j])) {
                enBaseForm = word.substring(0, word.length() - 3) + flectionFuge[j];
                logger.debug((Object)"gerund case 3");
            }
            if (enBaseForm != null) break;
        }
        if (enBaseForm == null) {
            if (this.knowEnBaseForm(word.substring(0, word.length() - 3))) {
                enBaseForm = word.substring(0, word.length() - 3);
                logger.debug((Object)"gerund case 1");
            } else if (this.knowEnBaseForm(word.substring(0, word.length() - 4)) && word.charAt(word.length() - 4) == word.charAt(word.length() - 5)) {
                enBaseForm = word.substring(0, word.length() - 4);
                logger.debug((Object)"gerund case 2");
            }
        }
        return enBaseForm;
    }

    private String transcribeFlection(Word word, Result currentResult) {
        String result = null;
        String otherLanguageTranscription = null;
        String endingTranscription = null;
        String gerundEndingTrans = null;
        String participleBaseShortEndingTrans = null;
        String flectionFugeTrans = null;
        otherLanguageTranscription = this.jphon.phonemiseEn(word.getOtherLanguageBaseForm());
        if (otherLanguageTranscription != null) {
            currentResult.setUsedOtherLanguageToPhonemise(true);
            for (int j = 0; j < this.dentalPlosives.length; ++j) {
                if (!otherLanguageTranscription.endsWith(this.dentalPlosives[j])) continue;
                word.setExtraSyll(true);
                logger.debug((Object)"extraSyll true");
            }
            String[] participleBaseLongEndings = this.getEndingsAndAffixes("participle_base_long");
            for (int j = 0; j < participleBaseLongEndings.length; ++j) {
                if (word.getFlectionEnding() == null || !word.getFlectionEnding().equals(participleBaseLongEndings[j]) || word.getCutOffCharacter()) continue;
                word.setExtraSyll(true);
            }
            String[] gerundEndings = this.getEndingsAndAffixes("gerund_ending");
            for (int j = 0; j < gerundEndings.length; ++j) {
                if (this.endingTranscriptionLookup(gerundEndings[j]) == null) continue;
                gerundEndingTrans = this.endingTranscriptionLookup(gerundEndings[j]);
            }
            String[] participleBaseShortEndings = this.getEndingsAndAffixes("participle_base_short");
            for (int j = 0; j < participleBaseShortEndings.length; ++j) {
                if (this.endingTranscriptionLookup(participleBaseShortEndings[j]) == null) continue;
                participleBaseShortEndingTrans = this.endingTranscriptionLookup(participleBaseShortEndings[j]);
            }
            String[] flectionFuge = this.getEndingsAndAffixes("flection_fuge");
            for (int j = 0; j < flectionFuge.length; ++j) {
                if (this.endingTranscriptionLookup(flectionFuge[j]) == null) continue;
                flectionFugeTrans = this.endingTranscriptionLookup(flectionFuge[j]);
            }
            endingTranscription = this.endingTranscriptionLookup(word.getFlectionEnding());
            String newEnTranscription = this.rebuildTrans(otherLanguageTranscription);
            String newGerundEndingTrans = this.rebuildTrans(gerundEndingTrans);
            String voicedNewGerundEndingTrans = this.voiceFinal(newGerundEndingTrans);
            logger.debug((Object)("enTrans: " + otherLanguageTranscription));
            if (word.getFlectionEnding() != null) {
                if (this.endingTranscriptionLookup(word.getFlectionEnding()) != null) {
                    if (otherLanguageTranscription.endsWith(word.getFlectionEnding()) && !word.getIsVerbalGerund() && !word.getCouldBeParticiple()) {
                        result = otherLanguageTranscription;
                        logger.debug((Object)"(0)");
                    } else if (word.getCouldBeParticiple() && this.isShortSuperlative(word.getFlectionEnding()) && word.getExtraSyll()) {
                        result = newEnTranscription + flectionFugeTrans + participleBaseShortEndingTrans + endingTranscription;
                        logger.debug((Object)"(1)");
                    } else if (word.getCouldBeParticiple() && word.getCouldBeParticipleInBaseForm() && word.getExtraSyll()) {
                        result = newEnTranscription + flectionFugeTrans + participleBaseShortEndingTrans;
                        logger.debug((Object)"(2)");
                    } else if (word.getCouldBeParticiple() && word.getExtraSyll() && word.getWordMinusFlectionEndsWithVowel()) {
                        result = newEnTranscription + flectionFugeTrans + "-" + endingTranscription;
                        logger.debug((Object)"(3)");
                    } else if (word.getCouldBeParticiple() && word.getExtraSyll()) {
                        result = newEnTranscription + flectionFugeTrans + "-" + participleBaseShortEndingTrans + endingTranscription;
                        logger.debug((Object)"(4)");
                    } else if (word.getCouldBeParticiple() && this.isShortSuperlative(word.getFlectionEnding())) {
                        result = otherLanguageTranscription + participleBaseShortEndingTrans + endingTranscription;
                        logger.debug((Object)"(5)");
                    } else if (word.getCouldBeParticiple() && word.getCouldBeParticipleInBaseForm()) {
                        result = otherLanguageTranscription + participleBaseShortEndingTrans;
                        logger.debug((Object)"(6)");
                    } else if (word.getCouldBeParticiple()) {
                        result = otherLanguageTranscription + "-" + participleBaseShortEndingTrans + endingTranscription;
                        logger.debug((Object)"(7)");
                    } else if (word.getIsVerbalGerund()) {
                        logger.debug((Object)"isVerbalGerund");
                        result = this.isShortSuperlative(word.getFlectionEnding()) ? newEnTranscription + gerundEndingTrans + endingTranscription : newEnTranscription + voicedNewGerundEndingTrans + endingTranscription;
                    } else if (this.isShortSuperlative(word.getFlectionEnding())) {
                        result = otherLanguageTranscription + endingTranscription;
                    } else if (word.getExtraSyll()) {
                        logger.debug((Object)"extraSyll is true here...");
                        result = newEnTranscription + endingTranscription;
                    } else {
                        result = this.endingContainsVowel(word.getFlectionEnding()) && !this.endingBeginsWithVowel(word.getFlectionEnding()) ? otherLanguageTranscription + "-" + endingTranscription : (this.endingContainsVowel(word.getFlectionEnding()) && this.endingBeginsWithVowel(word.getFlectionEnding()) ? newEnTranscription + endingTranscription : otherLanguageTranscription + endingTranscription);
                    }
                }
            } else if (word.getIsVerbalGerund()) {
                result = newEnTranscription + gerundEndingTrans;
                logger.debug((Object)"(((1)))");
            } else {
                result = otherLanguageTranscription;
                logger.debug((Object)"(((2)))");
            }
        }
        return result;
    }

    private String knowEnding(String toBePhonemised, int endingLength) {
        logger.debug((Object)("in knowEnding: " + toBePhonemised));
        String currentEnding = null;
        String foundEnding = null;
        int wordLength = toBePhonemised.length();
        for (int j = endingLength; j > 0; --j) {
            if (j >= wordLength) continue;
            currentEnding = toBePhonemised.substring(wordLength - j, wordLength);
            logger.debug((Object)("currentEnding: " + currentEnding));
            if (this.endingSet.contains(currentEnding)) {
                foundEnding = currentEnding;
                logger.debug((Object)("foundEnding....: " + foundEnding));
            }
            if (foundEnding != null) break;
        }
        return foundEnding;
    }

    private String voiceFinal(String ending) {
        String finalPhoneme = null;
        String voicedFinalPhoneme = null;
        String voicedEnding = null;
        if (ending.length() > 0) {
            finalPhoneme = ending.substring(ending.length() - 1, ending.length());
        }
        if (this.getVoicedFinal(finalPhoneme) != null) {
            voicedFinalPhoneme = this.getVoicedFinal(finalPhoneme);
            voicedEnding = ending.substring(0, ending.length() - 1) + voicedFinalPhoneme;
        } else {
            voicedEnding = ending;
        }
        return voicedEnding;
    }

    private String rebuildTrans(String s) {
        Allophone last;
        Allophone[] allophones;
        AllophoneSet set = this.jphon.getAllophoneSet();
        if (set != null && (allophones = set.splitIntoAllophones(s)) != null && allophones.length > 0 && (last = allophones[allophones.length - 1]).isConsonant()) {
            String lastPh = last.name();
            return s.substring(0, s.length() - lastPh.length()) + "-" + lastPh;
        }
        return s + "-";
    }

    private boolean checkIfGerund(String s) {
        String[] gerundEndings = this.getEndingsAndAffixes("gerund_ending");
        for (int j = 0; j < gerundEndings.length; ++j) {
            if (s.length() <= gerundEndings[j].length() || !s.substring(s.length() - 3, s.length()).equals(gerundEndings[j])) continue;
            return true;
        }
        return false;
    }

    private boolean isShortSuperlative(String flectionEnding) {
        String[] shortSuperlativeEndings = this.getEndingsAndAffixes("superlative_short");
        for (int i = 0; i < shortSuperlativeEndings.length; ++i) {
            if (flectionEnding == null || !flectionEnding.equals(shortSuperlativeEndings[i])) continue;
            return true;
        }
        return false;
    }

    private boolean endingBeginsWithVowel(String ending) {
        for (int i = 0; i < this.vowels.length; ++i) {
            if (!this.vowels[i].equals(ending.substring(0, 1))) continue;
            return true;
        }
        return false;
    }

    private boolean endingContainsVowel(String ending) {
        for (int i = 0; i < this.vowels.length; ++i) {
            for (int j = 0; j < ending.length(); ++j) {
                if (!this.vowels[i].equals(ending.substring(j, j + 1))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean endsWithVowel(String s) {
        for (int i = 0; i < this.vowels.length; ++i) {
            for (int j = 0; j < s.length(); ++j) {
                if (!this.vowels[i].equals(s.substring(s.length() - 1, s.length()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLongParticipleBaseEnding(String s, String[] participleBaseLong) {
        for (int j = 0; j < participleBaseLong.length; ++j) {
            if (!s.equals(participleBaseLong[j])) continue;
            return true;
        }
        return false;
    }

    private boolean isShortParticipleBaseEnding(String s, String[] participleBaseShort) {
        for (int j = 0; j < participleBaseShort.length; ++j) {
            if (!s.equals(participleBaseShort[j])) continue;
            return true;
        }
        return false;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private boolean knowEnBaseForm(String s) {
        return this.jphon.phonemiseEn(s) != null;
    }

    private String prefixLexiconLookup(String s) {
        String prefixTranscription = null;
        try {
            if (this.prefixLexicon.get(s) != null) {
                prefixTranscription = this.prefixLexicon.get(s);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("prefixLexLookup: " + e.toString()));
        }
        return prefixTranscription;
    }

    private String getVoicedFinal(String phon) {
        String voicedPhon = null;
        try {
            if (this.terminalVoicings.get(phon) != null) {
                voicedPhon = this.terminalVoicings.get(phon);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("getVoicedFinal: " + e.toString()));
        }
        return voicedPhon;
    }

    private String[] getEndingsAndAffixes(String key) {
        String[] endingList = null;
        try {
            if (this.endingsAndAffixes.get(key) != null) {
                String value = this.endingsAndAffixes.get(key);
                endingList = value.split("/");
            }
        }
        catch (Exception e) {
            logger.debug((Object)("getEndingsAndAffixes: " + e.toString()));
        }
        return endingList;
    }

    private String endingTranscriptionLookup(String s) {
        String affixPhon = null;
        try {
            if (this.flectionToPhon.get(s) != null) {
                affixPhon = this.flectionToPhon.get(s);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("endingTranscriptionLookup: " + e.toString()));
        }
        return affixPhon;
    }
}

