/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.utils;

import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.utils.DomUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JapaneseUtils {
    public static String tokenizeFragment(String fragment) {
        return fragment.trim();
    }

    public static String tokenizeSentence(String sentence) {
        if (!MagicBooleans.jp_tokenize) {
            return sentence;
        }
        String result = "";
        result = JapaneseUtils.tokenizeXML(sentence);
        while (result.contains("$ ")) {
            result = result.replace("$ ", "$");
        }
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        while (result.contains("anon ")) {
            result = result.replace("anon ", "anon");
        }
        result = result.trim();
        return result;
    }

    public static String tokenizeXML(String xmlExpression) {
        String response = MagicStrings.template_failed;
        try {
            xmlExpression = "<sentence>" + xmlExpression + "</sentence>";
            Node root = DomUtils.parseString(xmlExpression);
            response = JapaneseUtils.recursEval(root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return AIMLProcessor.trimTag(response, "sentence");
    }

    private static String recursEval(Node node) {
        try {
            String nodeName = node.getNodeName();
            if (nodeName.equals("#text")) {
                return JapaneseUtils.tokenizeFragment(node.getNodeValue());
            }
            if (nodeName.equals("sentence")) {
                return JapaneseUtils.evalTagContent(node);
            }
            return JapaneseUtils.genericXML(node);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "JP Morph Error";
        }
    }

    public static String genericXML(Node node) {
        String result = JapaneseUtils.evalTagContent(node);
        return JapaneseUtils.unevaluatedXML(result, node);
    }

    public static String evalTagContent(Node node) {
        String result = "";
        try {
            NodeList childList = node.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                result = result + JapaneseUtils.recursEval(child);
            }
        }
        catch (Exception ex) {
            System.out.println("Something went wrong with evalTagContent");
            ex.printStackTrace();
        }
        return result;
    }

    private static String unevaluatedXML(String result, Node node) {
        String nodeName = node.getNodeName();
        String attributes = "";
        if (node.hasAttributes()) {
            NamedNodeMap XMLAttributes = node.getAttributes();
            for (int i = 0; i < XMLAttributes.getLength(); ++i) {
                attributes = attributes + " " + XMLAttributes.item(i).getNodeName() + "=\"" + XMLAttributes.item(i).getNodeValue() + "\"";
            }
        }
        if (result.equals("")) {
            return " <" + nodeName + attributes + "/> ";
        }
        return " <" + nodeName + attributes + ">" + result + "</" + nodeName + "> ";
    }
}

