/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.text.DecimalFormat;
import org.alicebot.ab.AIMLMap;
import org.alicebot.ab.AIMLSet;
import org.alicebot.ab.Bot;

public class EnglishNumberToWords {
    private static final String[] tensNames = new String[]{"", " ten", " twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety"};
    private static final String[] numNames = new String[]{"", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};

    private EnglishNumberToWords() {
    }

    private static String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return numNames[number] + " hundred" + soFar;
    }

    public static String convert(long number) {
        String tradHundredThousands;
        String tradMillions;
        String tradBillions;
        if (number == 0L) {
            return "zero";
        }
        String snumber = Long.toString(number);
        String mask = "000000000000";
        DecimalFormat df = new DecimalFormat(mask);
        snumber = df.format(number);
        int billions = Integer.parseInt(snumber.substring(0, 3));
        int millions = Integer.parseInt(snumber.substring(3, 6));
        int hundredThousands = Integer.parseInt(snumber.substring(6, 9));
        int thousands = Integer.parseInt(snumber.substring(9, 12));
        switch (billions) {
            case 0: {
                tradBillions = "";
                break;
            }
            case 1: {
                tradBillions = EnglishNumberToWords.convertLessThanOneThousand(billions) + " billion ";
                break;
            }
            default: {
                tradBillions = EnglishNumberToWords.convertLessThanOneThousand(billions) + " billion ";
            }
        }
        String result = tradBillions;
        switch (millions) {
            case 0: {
                tradMillions = "";
                break;
            }
            case 1: {
                tradMillions = EnglishNumberToWords.convertLessThanOneThousand(millions) + " million ";
                break;
            }
            default: {
                tradMillions = EnglishNumberToWords.convertLessThanOneThousand(millions) + " million ";
            }
        }
        result = result + tradMillions;
        switch (hundredThousands) {
            case 0: {
                tradHundredThousands = "";
                break;
            }
            case 1: {
                tradHundredThousands = "one thousand ";
                break;
            }
            default: {
                tradHundredThousands = EnglishNumberToWords.convertLessThanOneThousand(hundredThousands) + " thousand ";
            }
        }
        result = result + tradHundredThousands;
        String tradThousand = EnglishNumberToWords.convertLessThanOneThousand(thousands);
        result = result + tradThousand;
        return result.replaceAll("^\\s+", "").replaceAll("\\b\\s{2,}\\b", " ");
    }

    public static void makeSetMap(Bot bot) {
        AIMLSet numberName = new AIMLSet("numbername", bot);
        AIMLMap name2number = new AIMLMap("name2number", bot);
        for (int i = 0; i < 10000; ++i) {
            String name = EnglishNumberToWords.convert(i).trim();
            String number = "" + i;
            numberName.add(name);
            name2number.put(name, number);
            if (i != 1000) continue;
            System.out.println("Name2number(" + name + ")=" + number);
        }
        numberName.writeAIMLSet();
        name2number.writeAIMLMap();
    }

    public static void main(String[] args) {
        System.out.println("*** " + EnglishNumberToWords.convert(0L));
        System.out.println("*** " + EnglishNumberToWords.convert(1L));
        System.out.println("*** " + EnglishNumberToWords.convert(16L));
        System.out.println("*** " + EnglishNumberToWords.convert(100L));
        System.out.println("*** " + EnglishNumberToWords.convert(118L));
        System.out.println("*** " + EnglishNumberToWords.convert(200L));
        System.out.println("*** " + EnglishNumberToWords.convert(219L));
        System.out.println("*** " + EnglishNumberToWords.convert(800L));
        System.out.println("*** " + EnglishNumberToWords.convert(801L));
        System.out.println("*** " + EnglishNumberToWords.convert(1316L));
        System.out.println("*** " + EnglishNumberToWords.convert(1000000L));
        System.out.println("*** " + EnglishNumberToWords.convert(2000000L));
        System.out.println("*** " + EnglishNumberToWords.convert(3000200L));
        System.out.println("*** " + EnglishNumberToWords.convert(700000L));
        System.out.println("*** " + EnglishNumberToWords.convert(9000000L));
        System.out.println("*** " + EnglishNumberToWords.convert(9001000L));
        System.out.println("*** " + EnglishNumberToWords.convert(123456789L));
        System.out.println("*** " + EnglishNumberToWords.convert(Integer.MAX_VALUE));
        System.out.println("*** " + EnglishNumberToWords.convert(3000000010L));
    }
}

