/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.alicebot.ab.AIMLMap;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.AIMLSet;
import org.alicebot.ab.Category;
import org.alicebot.ab.Graphmaster;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Nodemapper;
import org.alicebot.ab.NodemapperOperator;
import org.alicebot.ab.PreProcessor;
import org.alicebot.ab.Properties;
import org.alicebot.ab.Timer;
import org.alicebot.ab.Utilities;
import org.alicebot.ab.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bot {
    public final Properties properties = new Properties();
    public final PreProcessor preProcessor;
    public final Graphmaster brain;
    public Graphmaster learnfGraph;
    public Graphmaster learnGraph;
    public String name = MagicStrings.default_bot_name;
    public HashMap<String, AIMLSet> setMap = new HashMap();
    public HashMap<String, AIMLMap> mapMap = new HashMap();
    public HashSet<String> pronounSet = new HashSet();
    public String root_path = "c:/ab";
    public String bot_path = this.root_path + "/bots";
    public String bot_name_path = this.bot_path + "/super";
    public String aimlif_path = this.bot_path + "/aimlif";
    public String aiml_path = this.bot_path + "/aiml";
    public String config_path = this.bot_path + "/config";
    public String log_path = this.bot_path + "/log";
    public String sets_path = this.bot_path + "/sets";
    public String maps_path = this.bot_path + "/maps";

    public void setAllPaths(String root, String name) {
        this.bot_path = root + "/bots";
        this.bot_name_path = this.bot_path + "/" + name;
        if (MagicBooleans.trace_mode) {
            System.out.println("Name = " + name + " Path = " + this.bot_name_path);
        }
        this.aiml_path = this.bot_name_path + "/aiml";
        this.aimlif_path = this.bot_name_path + "/aimlif";
        this.config_path = this.bot_name_path + "/config";
        this.log_path = this.bot_name_path + "/logs";
        this.sets_path = this.bot_name_path + "/sets";
        this.maps_path = this.bot_name_path + "/maps";
        if (MagicBooleans.trace_mode) {
            System.out.println(this.root_path);
            System.out.println(this.bot_path);
            System.out.println(this.bot_name_path);
            System.out.println(this.aiml_path);
            System.out.println(this.aimlif_path);
            System.out.println(this.config_path);
            System.out.println(this.log_path);
            System.out.println(this.sets_path);
            System.out.println(this.maps_path);
        }
    }

    public Bot() {
        this(MagicStrings.default_bot);
    }

    public Bot(String name) {
        this(name, MagicStrings.root_path);
    }

    public Bot(String name, String path) {
        this(name, path, "auto");
    }

    public Bot(String name, String path, String action) {
        int cnt = 0;
        boolean elementCnt = false;
        this.name = name;
        this.setAllPaths(path, name);
        this.brain = new Graphmaster(this);
        this.learnfGraph = new Graphmaster(this, "learnf");
        this.learnGraph = new Graphmaster(this, "learn");
        this.preProcessor = new PreProcessor(this);
        this.addProperties();
        cnt = this.addAIMLSets();
        if (MagicBooleans.trace_mode) {
            System.out.println("Loaded " + cnt + " set elements.");
        }
        cnt = this.addAIMLMaps();
        if (MagicBooleans.trace_mode) {
            System.out.println("Loaded " + cnt + " map elements");
        }
        this.pronounSet = this.getPronouns();
        AIMLSet number = new AIMLSet(MagicStrings.natural_number_set_name, this);
        this.setMap.put(MagicStrings.natural_number_set_name, number);
        AIMLMap successor = new AIMLMap(MagicStrings.map_successor, this);
        this.mapMap.put(MagicStrings.map_successor, successor);
        AIMLMap predecessor = new AIMLMap(MagicStrings.map_predecessor, this);
        this.mapMap.put(MagicStrings.map_predecessor, predecessor);
        AIMLMap singular = new AIMLMap(MagicStrings.map_singular, this);
        this.mapMap.put(MagicStrings.map_singular, singular);
        AIMLMap plural = new AIMLMap(MagicStrings.map_plural, this);
        this.mapMap.put(MagicStrings.map_plural, plural);
        Date aimlDate = new Date(new File(this.aiml_path).lastModified());
        Date aimlIFDate = new Date(new File(this.aimlif_path).lastModified());
        if (MagicBooleans.trace_mode) {
            System.out.println("AIML modified " + aimlDate + " AIMLIF modified " + aimlIFDate);
        }
        MagicStrings.pannous_api_key = Utilities.getPannousAPIKey(this);
        MagicStrings.pannous_login = Utilities.getPannousLogin(this);
        if (action.equals("aiml2csv")) {
            this.addCategoriesFromAIML();
        } else if (action.equals("csv2aiml")) {
            this.addCategoriesFromAIMLIF();
        } else if (action.equals("chat-app")) {
            if (MagicBooleans.trace_mode) {
                System.out.println("Loading only AIMLIF files");
            }
            cnt = this.addCategoriesFromAIMLIF();
        } else if (aimlDate.after(aimlIFDate)) {
            if (MagicBooleans.trace_mode) {
                System.out.println("AIML modified after AIMLIF");
            }
            cnt = this.addCategoriesFromAIML();
            this.writeAIMLIFFiles();
        } else {
            this.addCategoriesFromAIMLIF();
            if (this.brain.getCategories().size() == 0) {
                System.out.println("No AIMLIF Files found.  Looking for AIML");
                cnt = this.addCategoriesFromAIML();
            }
        }
        Category b = new Category(0, "PROGRAM VERSION", "*", "*", MagicStrings.program_name_version, "update.aiml");
        this.brain.addCategory(b);
        this.brain.nodeStats();
        this.learnfGraph.nodeStats();
    }

    HashSet<String> getPronouns() {
        HashSet<String> pronounSet = new HashSet<String>();
        String pronouns = Utilities.getFile(this.config_path + "/pronouns.txt");
        String[] splitPronouns = pronouns.split("\n");
        for (int i = 0; i < splitPronouns.length; ++i) {
            String p = splitPronouns[i].trim();
            if (p.length() <= 0) continue;
            pronounSet.add(p);
        }
        if (MagicBooleans.trace_mode) {
            System.out.println("Read pronouns: " + pronounSet);
        }
        return pronounSet;
    }

    void addMoreCategories(String file, ArrayList<Category> moreCategories) {
        block5: {
            if (file.contains(MagicStrings.deleted_aiml_file)) break block5;
            if (file.contains(MagicStrings.learnf_aiml_file)) {
                if (MagicBooleans.trace_mode) {
                    System.out.println("Reading Learnf file");
                }
                for (Category c : moreCategories) {
                    this.brain.addCategory(c);
                    this.learnfGraph.addCategory(c);
                }
            } else {
                for (Category c : moreCategories) {
                    this.brain.addCategory(c);
                }
            }
        }
    }

    int addCategoriesFromAIML() {
        Timer timer = new Timer();
        timer.start();
        int cnt = 0;
        try {
            File folder = new File(this.aiml_path);
            if (folder.exists()) {
                File[] listOfFiles = IOUtils.listFiles(folder);
                if (MagicBooleans.trace_mode) {
                    System.out.println("Loading AIML files from " + this.aiml_path);
                }
                for (File listOfFile : listOfFiles) {
                    String file;
                    if (!listOfFile.isFile() || !(file = listOfFile.getName()).endsWith(".aiml") && !file.endsWith(".AIML")) continue;
                    if (MagicBooleans.trace_mode) {
                        System.out.println(file);
                    }
                    try {
                        ArrayList<Category> moreCategories = AIMLProcessor.AIMLToCategories(this.aiml_path, file);
                        this.addMoreCategories(file, moreCategories);
                        cnt += moreCategories.size();
                    }
                    catch (Exception iex) {
                        System.out.println("Problem loading " + file);
                        iex.printStackTrace();
                    }
                }
            } else {
                System.out.println("addCategoriesFromAIML: " + this.aiml_path + " does not exist.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (MagicBooleans.trace_mode) {
            System.out.println("Loaded " + cnt + " categories in " + timer.elapsedTimeSecs() + " sec");
        }
        return cnt;
    }

    public int addCategoriesFromAIMLIF() {
        Timer timer = new Timer();
        timer.start();
        int cnt = 0;
        try {
            File folder = new File(this.aimlif_path);
            if (folder.exists()) {
                File[] listOfFiles = IOUtils.listFiles(folder);
                if (MagicBooleans.trace_mode) {
                    System.out.println("Loading AIML files from " + this.aimlif_path);
                }
                for (File listOfFile : listOfFiles) {
                    String file;
                    if (!listOfFile.isFile() || !(file = listOfFile.getName()).endsWith(MagicStrings.aimlif_file_suffix) && !file.endsWith(MagicStrings.aimlif_file_suffix.toUpperCase())) continue;
                    if (MagicBooleans.trace_mode) {
                        System.out.println(file);
                    }
                    try {
                        ArrayList<Category> moreCategories = this.readIFCategories(this.aimlif_path + "/" + file);
                        cnt += moreCategories.size();
                        this.addMoreCategories(file, moreCategories);
                    }
                    catch (Exception iex) {
                        System.out.println("Problem loading " + file);
                        iex.printStackTrace();
                    }
                }
            } else {
                System.out.println("addCategoriesFromAIMLIF: " + this.aimlif_path + " does not exist.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (MagicBooleans.trace_mode) {
            System.out.println("Loaded " + cnt + " categories in " + timer.elapsedTimeSecs() + " sec");
        }
        return cnt;
    }

    public void writeQuit() {
        this.writeAIMLIFFiles();
        this.writeAIMLFiles();
    }

    public int readCertainIFCategories(Graphmaster graph, String fileName) {
        int cnt = 0;
        File file = new File(this.aimlif_path + "/" + fileName + MagicStrings.aimlif_file_suffix);
        if (file.exists()) {
            try {
                ArrayList<Category> certainCategories = this.readIFCategories(this.aimlif_path + "/" + fileName + MagicStrings.aimlif_file_suffix);
                for (Category d : certainCategories) {
                    graph.addCategory(d);
                }
                cnt = certainCategories.size();
                System.out.println("readCertainIFCategories " + cnt + " categories from " + fileName + MagicStrings.aimlif_file_suffix);
            }
            catch (Exception iex) {
                System.out.println("Problem loading " + fileName);
                iex.printStackTrace();
            }
        } else {
            System.out.println("No " + this.aimlif_path + "/" + fileName + MagicStrings.aimlif_file_suffix + " file found");
        }
        return cnt;
    }

    public void writeCertainIFCategories(Graphmaster graph, String file) {
        if (MagicBooleans.trace_mode) {
            System.out.println("writeCertainIFCaegories " + file + " size= " + graph.getCategories().size());
        }
        this.writeIFCategories(graph.getCategories(), file + MagicStrings.aimlif_file_suffix);
        File dir = new File(this.aimlif_path);
        dir.setLastModified(new Date().getTime());
    }

    public void writeLearnfIFCategories() {
        this.writeCertainIFCategories(this.learnfGraph, MagicStrings.learnf_aiml_file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIFCategories(ArrayList<Category> cats, String filename) {
        BufferedWriter bw = null;
        File existsPath = new File(this.aimlif_path);
        if (existsPath.exists()) {
            try {
                bw = new BufferedWriter(new FileWriter(this.aimlif_path + "/" + filename));
                for (Category category : cats) {
                    bw.write(Category.categoryToIF(category));
                    bw.newLine();
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (bw != null) {
                        bw.flush();
                        bw.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void writeAIMLIFFiles() {
        if (MagicBooleans.trace_mode) {
            System.out.println("writeAIMLIFFiles");
        }
        HashMap<String, BufferedWriter> fileMap = new HashMap<String, BufferedWriter>();
        Category b = new Category(0, "BRAIN BUILD", "*", "*", new Date().toString(), "update.aiml");
        this.brain.addCategory(b);
        ArrayList<Category> brainCategories = this.brain.getCategories();
        Collections.sort(brainCategories, Category.CATEGORY_NUMBER_COMPARATOR);
        for (Category category : brainCategories) {
            try {
                BufferedWriter bw;
                String fileName = category.getFilename();
                if (fileMap.containsKey(fileName)) {
                    bw = (BufferedWriter)fileMap.get(fileName);
                } else {
                    bw = new BufferedWriter(new FileWriter(this.aimlif_path + "/" + fileName + MagicStrings.aimlif_file_suffix));
                    fileMap.put(fileName, bw);
                }
                bw.write(Category.categoryToIF(category));
                bw.newLine();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Set set = fileMap.keySet();
        for (Object aSet : set) {
            BufferedWriter bw = (BufferedWriter)fileMap.get(aSet);
            try {
                if (bw == null) continue;
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        File file = new File(this.aimlif_path);
        file.setLastModified(new Date().getTime());
    }

    public void writeAIMLFiles() {
        if (MagicBooleans.trace_mode) {
            System.out.println("writeAIMLFiles");
        }
        HashMap<String, BufferedWriter> fileMap = new HashMap<String, BufferedWriter>();
        Category b = new Category(0, "BRAIN BUILD", "*", "*", new Date().toString(), "update.aiml");
        this.brain.addCategory(b);
        ArrayList<Category> brainCategories = this.brain.getCategories();
        Collections.sort(brainCategories, Category.CATEGORY_NUMBER_COMPARATOR);
        for (Category category : brainCategories) {
            if (category.getFilename().equals(MagicStrings.null_aiml_file)) continue;
            try {
                BufferedWriter bw;
                String fileName = category.getFilename();
                if (fileMap.containsKey(fileName)) {
                    bw = (BufferedWriter)fileMap.get(fileName);
                } else {
                    String copyright = Utilities.getCopyright(this, fileName);
                    bw = new BufferedWriter(new FileWriter(this.aiml_path + "/" + fileName));
                    fileMap.put(fileName, bw);
                    bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<aiml>\n");
                    bw.write(copyright);
                }
                bw.write(Category.categoryToAIML(category) + "\n");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Set set = fileMap.keySet();
        for (Object aSet : set) {
            BufferedWriter bw = (BufferedWriter)fileMap.get(aSet);
            try {
                if (bw == null) continue;
                bw.write("</aiml>\n");
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        File file = new File(this.aiml_path);
        file.setLastModified(new Date().getTime());
    }

    void addProperties() {
        try {
            this.properties.getProperties(this.config_path + "/properties.txt");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<Category> readIFCategories(String filename) {
        ArrayList<Category> categories = new ArrayList<Category>();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            while ((strLine = br.readLine()) != null) {
                try {
                    Category c = Category.IFToCategory(strLine);
                    categories.add(c);
                }
                catch (Exception ex) {
                    System.out.println("Invalid AIMLIF in " + filename + " line " + strLine);
                }
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return categories;
    }

    int addAIMLSets() {
        int cnt = 0;
        Timer timer = new Timer();
        timer.start();
        try {
            File folder = new File(this.sets_path);
            if (folder.exists()) {
                File[] listOfFiles = IOUtils.listFiles(folder);
                if (MagicBooleans.trace_mode) {
                    System.out.println("Loading AIML Sets files from " + this.sets_path);
                }
                for (File listOfFile : listOfFiles) {
                    String file;
                    if (!listOfFile.isFile() || !(file = listOfFile.getName()).endsWith(".txt") && !file.endsWith(".TXT")) continue;
                    if (MagicBooleans.trace_mode) {
                        System.out.println(file);
                    }
                    String setName = file.substring(0, file.length() - ".txt".length());
                    if (MagicBooleans.trace_mode) {
                        System.out.println("Read AIML Set " + setName);
                    }
                    AIMLSet aimlSet = new AIMLSet(setName, this);
                    cnt += aimlSet.readAIMLSet(this);
                    this.setMap.put(setName, aimlSet);
                }
            } else {
                System.out.println("addAIMLSets: " + this.sets_path + " does not exist.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cnt;
    }

    int addAIMLMaps() {
        int cnt = 0;
        Timer timer = new Timer();
        timer.start();
        try {
            File folder = new File(this.maps_path);
            if (folder.exists()) {
                File[] listOfFiles = IOUtils.listFiles(folder);
                if (MagicBooleans.trace_mode) {
                    System.out.println("Loading AIML Map files from " + this.maps_path);
                }
                for (File listOfFile : listOfFiles) {
                    String file;
                    if (!listOfFile.isFile() || !(file = listOfFile.getName()).endsWith(".txt") && !file.endsWith(".TXT")) continue;
                    if (MagicBooleans.trace_mode) {
                        System.out.println(file);
                    }
                    String mapName = file.substring(0, file.length() - ".txt".length());
                    if (MagicBooleans.trace_mode) {
                        System.out.println("Read AIML Map " + mapName);
                    }
                    AIMLMap aimlMap = new AIMLMap(mapName, this);
                    cnt += aimlMap.readAIMLMap(this);
                    this.mapMap.put(mapName, aimlMap);
                }
            } else {
                System.out.println("addAIMLMaps: " + this.maps_path + " does not exist.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cnt;
    }

    public void deleteLearnfCategories() {
        ArrayList<Category> learnfCategories = this.learnfGraph.getCategories();
        for (Category c : learnfCategories) {
            Nodemapper n = this.brain.findNode(c);
            System.out.println("Found node " + n + " for " + c.inputThatTopic());
            if (n == null) continue;
            n.category = null;
        }
        this.learnfGraph = new Graphmaster(this);
    }

    public void deleteLearnCategories() {
        ArrayList<Category> learnCategories = this.learnGraph.getCategories();
        for (Category c : learnCategories) {
            Nodemapper n = this.brain.findNode(c);
            System.out.println("Found node " + n + " for " + c.inputThatTopic());
            if (n == null) continue;
            n.category = null;
        }
        this.learnGraph = new Graphmaster(this);
    }

    public void shadowChecker() {
        this.shadowChecker(this.brain.root);
    }

    void shadowChecker(Nodemapper node) {
        if (NodemapperOperator.isLeaf(node)) {
            String input = node.category.getPattern();
            input = this.brain.replaceBotProperties(input);
            input = input.replace("*", "XXX").replace("_", "XXX").replace("^", "").replace("#", "");
            String that = node.category.getThat().replace("*", "XXX").replace("_", "XXX").replace("^", "").replace("#", "");
            String topic = node.category.getTopic().replace("*", "XXX").replace("_", "XXX").replace("^", "").replace("#", "");
            input = this.instantiateSets(input);
            System.out.println("shadowChecker: input=" + input);
            Nodemapper match = this.brain.match(input, that, topic);
            if (match != node) {
                System.out.println("" + Graphmaster.inputThatTopic(input, that, topic));
                System.out.println("MATCHED:     " + match.category.inputThatTopic());
                System.out.println("SHOULD MATCH:" + node.category.inputThatTopic());
            }
        } else {
            for (String key : NodemapperOperator.keySet(node)) {
                this.shadowChecker(NodemapperOperator.get(node, key));
            }
        }
    }

    public String instantiateSets(String pattern) {
        String[] splitPattern = pattern.split(" ");
        pattern = "";
        for (String x : splitPattern) {
            if (x.startsWith("<SET>")) {
                String setName = AIMLProcessor.trimTag(x, "SET");
                AIMLSet set = this.setMap.get(setName);
                x = set != null ? "FOUNDITEM" : "NOTFOUND";
            }
            pattern = pattern + " " + x;
        }
        return pattern.trim();
    }
}

