/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Inflector;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Sraix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIMLMap
extends HashMap<String, String> {
    public String mapName;
    String host;
    String botid;
    boolean isExternal = false;
    Inflector inflector = new Inflector();
    Bot bot;

    public AIMLMap(String name, Bot bot) {
        this.bot = bot;
        this.mapName = name;
    }

    public String get(String key) {
        String value;
        if (this.mapName.equals(MagicStrings.map_successor)) {
            try {
                int number = Integer.parseInt(key);
                return String.valueOf(number + 1);
            }
            catch (Exception ex) {
                return MagicStrings.default_map;
            }
        }
        if (this.mapName.equals(MagicStrings.map_predecessor)) {
            try {
                int number = Integer.parseInt(key);
                return String.valueOf(number - 1);
            }
            catch (Exception ex) {
                return MagicStrings.default_map;
            }
        }
        if (this.mapName.equals("singular")) {
            return this.inflector.singularize(key).toLowerCase();
        }
        if (this.mapName.equals("plural")) {
            return this.inflector.pluralize(key).toLowerCase();
        }
        if (this.isExternal && MagicBooleans.enable_external_sets) {
            String query = this.mapName.toUpperCase() + " " + key;
            String response = Sraix.sraix(null, query, MagicStrings.default_map, null, this.host, this.botid, null, "0");
            System.out.println("External " + this.mapName + "(" + key + ")=" + response);
            value = response;
        } else {
            value = (String)super.get(key);
        }
        if (value == null) {
            value = MagicStrings.default_map;
        }
        return value;
    }

    @Override
    public String put(String key, String value) {
        return super.put(key, value);
    }

    public void writeAIMLMap() {
        System.out.println("Writing AIML Map " + this.mapName);
        try {
            FileWriter fstream = new FileWriter(this.bot.maps_path + "/" + this.mapName + ".txt");
            BufferedWriter out = new BufferedWriter(fstream);
            for (String p : this.keySet()) {
                p = p.trim();
                out.write(p + ":" + this.get(p).trim());
                out.newLine();
            }
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public int readAIMLMapFromInputStream(InputStream in, Bot bot) {
        int cnt = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String strLine;
            while ((strLine = br.readLine()) != null && strLine.length() > 0) {
                String[] splitLine = strLine.split(":");
                if (splitLine.length < 2) continue;
                ++cnt;
                if (strLine.startsWith(MagicStrings.remote_map_key)) {
                    if (splitLine.length < 3) continue;
                    this.host = splitLine[1];
                    this.botid = splitLine[2];
                    this.isExternal = true;
                    System.out.println("Created external map at " + this.host + " " + this.botid);
                    continue;
                }
                String key = splitLine[0].toUpperCase();
                String value = splitLine[1];
                this.put(key, value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cnt;
    }

    public int readAIMLMap(Bot bot) {
        int cnt = 0;
        if (MagicBooleans.trace_mode) {
            System.out.println("Reading AIML Map " + bot.maps_path + "/" + this.mapName + ".txt");
        }
        try {
            File file = new File(bot.maps_path + "/" + this.mapName + ".txt");
            if (file.exists()) {
                FileInputStream fstream = new FileInputStream(bot.maps_path + "/" + this.mapName + ".txt");
                cnt = this.readAIMLMapFromInputStream(fstream, bot);
                fstream.close();
            } else {
                System.out.println(bot.maps_path + "/" + this.mapName + ".txt not found");
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return cnt;
    }
}

