/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import org.alicebot.ab.AIMLSet;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Category;
import org.alicebot.ab.Graphmaster;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Nodemapper;
import org.alicebot.ab.NodemapperOperator;
import org.alicebot.ab.Timer;
import org.alicebot.ab.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AB {
    public boolean shuffle_mode = true;
    public boolean sort_mode = !this.shuffle_mode;
    public boolean filter_atomic_mode = false;
    public boolean filter_wild_mode = false;
    public boolean offer_alice_responses = true;
    public String logfile = MagicStrings.root_path + "/data/" + MagicStrings.ab_sample_file;
    public int runCompletedCnt;
    public Bot bot;
    public Bot alice;
    AIMLSet passed;
    AIMLSet testSet;
    public final Graphmaster inputGraph;
    public final Graphmaster patternGraph;
    public final Graphmaster deletedGraph;
    public ArrayList<Category> suggestedCategories;
    public static int limit = 500000;
    static int leafPatternCnt = 0;
    static int starPatternCnt = 0;

    public AB(Bot bot, String sampleFile) {
        MagicStrings.ab_sample_file = sampleFile;
        this.logfile = MagicStrings.root_path + "/data/" + MagicStrings.ab_sample_file;
        System.out.println("AB with sample file " + this.logfile);
        this.bot = bot;
        this.inputGraph = new Graphmaster(bot, "input");
        this.deletedGraph = new Graphmaster(bot, "deleted");
        this.patternGraph = new Graphmaster(bot, "pattern");
        for (Category c : bot.brain.getCategories()) {
            this.patternGraph.addCategory(c);
        }
        this.suggestedCategories = new ArrayList();
        this.passed = new AIMLSet("passed", bot);
        this.testSet = new AIMLSet("1000", bot);
        this.readDeletedIFCategories();
    }

    public void productivity(int runCompletedCnt, Timer timer) {
        float time = timer.elapsedTimeMins();
        System.out.println("Completed " + runCompletedCnt + " in " + time + " min. Productivity " + (float)runCompletedCnt / time + " cat/min");
    }

    public void readDeletedIFCategories() {
        this.bot.readCertainIFCategories(this.deletedGraph, MagicStrings.deleted_aiml_file);
        if (MagicBooleans.trace_mode) {
            System.out.println("--- DELETED CATEGORIES -- read " + this.deletedGraph.getCategories().size() + " deleted categories");
        }
    }

    public void writeDeletedIFCategories() {
        System.out.println("--- DELETED CATEGORIES -- write");
        this.bot.writeCertainIFCategories(this.deletedGraph, MagicStrings.deleted_aiml_file);
        System.out.println("--- DELETED CATEGORIES -- write " + this.deletedGraph.getCategories().size() + " deleted categories");
    }

    public void saveCategory(String pattern, String template, String filename) {
        String that = "*";
        String topic = "*";
        Category c = new Category(0, pattern, that, topic, template, filename);
        if (c.validate()) {
            this.bot.brain.addCategory(c);
            this.bot.writeAIMLIFFiles();
            ++this.runCompletedCnt;
        } else {
            System.out.println("Invalid Category " + c.validationMessage);
        }
    }

    public void deleteCategory(Category c) {
        c.setFilename(MagicStrings.deleted_aiml_file);
        c.setTemplate(MagicStrings.deleted_template);
        this.deletedGraph.addCategory(c);
        System.out.println("--- bot.writeDeletedIFCategories()");
        this.writeDeletedIFCategories();
    }

    public void skipCategory(Category c) {
    }

    public void abwq() {
        Timer timer = new Timer();
        timer.start();
        this.classifyInputs(this.logfile);
        System.out.println(timer.elapsedTimeSecs() + " classifying inputs");
        this.bot.writeQuit();
    }

    public void graphInputs(String filename) {
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            for (int count = 0; (strLine = br.readLine()) != null && count < limit; ++count) {
                Category c = new Category(0, strLine, "*", "*", "nothing", MagicStrings.unknown_aiml_file);
                Nodemapper node = this.inputGraph.findNode(c);
                if (node == null) {
                    this.inputGraph.addCategory(c);
                    c.incrementActivationCnt();
                    continue;
                }
                node.category.incrementActivationCnt();
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public void findPatterns() {
        this.findPatterns(this.inputGraph.root, "");
        System.out.println(leafPatternCnt + " Leaf Patterns " + starPatternCnt + " Star Patterns");
    }

    void findPatterns(Nodemapper node, String partialPatternThatTopic) {
        if (NodemapperOperator.isLeaf(node) && node.category.getActivationCnt() > MagicNumbers.node_activation_cnt) {
            ++leafPatternCnt;
            try {
                String categoryPatternThatTopic = "";
                categoryPatternThatTopic = node.shortCut ? partialPatternThatTopic + " <THAT> * <TOPIC> *" : partialPatternThatTopic;
                Category c = new Category(0, categoryPatternThatTopic, MagicStrings.blank_template, MagicStrings.unknown_aiml_file);
                if (!this.bot.brain.existsCategory(c) && !this.deletedGraph.existsCategory(c)) {
                    this.patternGraph.addCategory(c);
                    this.suggestedCategories.add(c);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (NodemapperOperator.size(node) > MagicNumbers.node_size) {
            ++starPatternCnt;
            try {
                Category c = new Category(0, partialPatternThatTopic + " * <THAT> * <TOPIC> *", MagicStrings.blank_template, MagicStrings.unknown_aiml_file);
                if (!this.bot.brain.existsCategory(c) && !this.deletedGraph.existsCategory(c)) {
                    this.patternGraph.addCategory(c);
                    this.suggestedCategories.add(c);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String key : NodemapperOperator.keySet(node)) {
            Nodemapper value = NodemapperOperator.get(node, key);
            this.findPatterns(value, partialPatternThatTopic + " " + key);
        }
    }

    public void classifyInputs(String filename) {
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            int count = 0;
            while ((strLine = br.readLine()) != null && count < limit) {
                if (strLine == null) continue;
                if (strLine.startsWith("Human: ")) {
                    strLine = strLine.substring("Human: ".length(), strLine.length());
                }
                String[] sentences = this.bot.preProcessor.sentenceSplit(strLine);
                for (int i = 0; i < sentences.length; ++i) {
                    String sentence = sentences[i];
                    if (sentence.length() <= 0) continue;
                    Nodemapper match = this.patternGraph.match(sentence, "unknown", "unknown");
                    if (match == null) {
                        System.out.println(sentence + " null match");
                    } else {
                        match.category.incrementActivationCnt();
                    }
                    if (++count % 10000 != 0) continue;
                    System.out.println(count);
                }
            }
            System.out.println("Finished classifying " + count + " inputs");
            br.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void ab() {
        String logFile = this.logfile;
        MagicBooleans.trace_mode = false;
        MagicBooleans.enable_external_sets = false;
        if (this.offer_alice_responses) {
            this.alice = new Bot("alice");
        }
        Timer timer = new Timer();
        this.bot.brain.nodeStats();
        if (this.bot.brain.getCategories().size() < MagicNumbers.brain_print_size) {
            this.bot.brain.printgraph();
        }
        timer.start();
        System.out.println("Graphing inputs");
        this.graphInputs(logFile);
        System.out.println(timer.elapsedTimeSecs() + " seconds Graphing inputs");
        this.inputGraph.nodeStats();
        if (this.inputGraph.getCategories().size() < MagicNumbers.brain_print_size) {
            this.inputGraph.printgraph();
        }
        timer.start();
        System.out.println("Finding Patterns");
        this.findPatterns();
        System.out.println(this.suggestedCategories.size() + " suggested categories");
        System.out.println(timer.elapsedTimeSecs() + " seconds finding patterns");
        timer.start();
        this.patternGraph.nodeStats();
        if (this.patternGraph.getCategories().size() < MagicNumbers.brain_print_size) {
            this.patternGraph.printgraph();
        }
        System.out.println("Classifying Inputs from " + logFile);
        this.classifyInputs(logFile);
        System.out.println(timer.elapsedTimeSecs() + " classifying inputs");
    }

    public ArrayList<Category> nonZeroActivationCount(ArrayList<Category> suggestedCategories) {
        ArrayList<Category> result = new ArrayList<Category>();
        for (Category c : suggestedCategories) {
            if (c.getActivationCnt() <= 0) continue;
            result.add(c);
        }
        return result;
    }

    public void terminalInteraction() {
        boolean firstInteraction = true;
        String alicetemplate = null;
        Timer timer = new Timer();
        this.sort_mode = !this.shuffle_mode;
        Collections.sort(this.suggestedCategories, Category.ACTIVATION_COMPARATOR);
        ArrayList<Category> topSuggestCategories = new ArrayList<Category>();
        for (int i = 0; i < 10000 && i < this.suggestedCategories.size(); ++i) {
            topSuggestCategories.add(this.suggestedCategories.get(i));
        }
        this.suggestedCategories = topSuggestCategories;
        if (this.shuffle_mode) {
            Collections.shuffle(this.suggestedCategories);
        }
        timer = new Timer();
        timer.start();
        this.runCompletedCnt = 0;
        ArrayList<Category> filteredAtomicCategories = new ArrayList<Category>();
        ArrayList<Category> filteredWildCategories = new ArrayList<Category>();
        for (Category c : this.suggestedCategories) {
            if (!c.getPattern().contains("*")) {
                filteredAtomicCategories.add(c);
                continue;
            }
            filteredWildCategories.add(c);
        }
        ArrayList<Category> browserCategories = this.filter_atomic_mode ? filteredAtomicCategories : (this.filter_wild_mode ? filteredWildCategories : this.suggestedCategories);
        browserCategories = this.nonZeroActivationCount(browserCategories);
        for (Category c : browserCategories) {
            try {
                ArrayList<String> samples = new ArrayList<String>(c.getMatches(this.bot));
                Collections.shuffle(samples);
                int sampleSize = Math.min(MagicNumbers.displayed_input_sample_size, c.getMatches(this.bot).size());
                for (int i = 0; i < sampleSize; ++i) {
                    System.out.println("" + samples.get(i));
                }
                System.out.println("[" + c.getActivationCnt() + "] " + c.inputThatTopic());
                if (this.offer_alice_responses) {
                    Nodemapper node = this.alice.brain.findNode(c);
                    if (node != null) {
                        String displayAliceTemplate = alicetemplate = node.category.getTemplate();
                        if ((displayAliceTemplate = displayAliceTemplate.replace("\n", " ")).length() > 200) {
                            displayAliceTemplate = displayAliceTemplate.substring(0, 200);
                        }
                        System.out.println("ALICE: " + displayAliceTemplate);
                    } else {
                        alicetemplate = null;
                    }
                }
                String textLine = "" + IOUtils.readInputTextLine();
                if (firstInteraction) {
                    timer.start();
                    firstInteraction = false;
                }
                this.productivity(this.runCompletedCnt, timer);
                this.terminalInteractionStep(this.bot, "", textLine, c, alicetemplate);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("Returning to Category Browser");
            }
        }
        System.out.println("No more samples");
        this.bot.writeAIMLFiles();
        this.bot.writeAIMLIFFiles();
    }

    public void terminalInteractionStep(Bot bot, String request, String textLine, Category c, String alicetemplate) {
        String[] pronouns;
        String template = null;
        if (textLine.contains("<pattern>") && textLine.contains("</pattern>")) {
            int index = textLine.indexOf("<pattern>") + "<pattern>".length();
            int jndex = textLine.indexOf("</pattern>");
            int kndex = jndex + "</pattern>".length();
            if (index < jndex) {
                String pattern = textLine.substring(index, jndex);
                c.setPattern(pattern);
                textLine = textLine.substring(kndex, textLine.length());
                System.out.println("Got pattern = " + pattern + " template = " + textLine);
            }
        }
        String botThinks = "";
        for (String p : pronouns = new String[]{"he", "she", "it", "we", "they"}) {
            if (!textLine.contains("<" + p + ">")) continue;
            textLine = textLine.replace("<" + p + ">", "");
            botThinks = "<think><set name=\"" + p + "\"><set name=\"topic\"><star/></set></set></think>";
        }
        if (textLine.equals("q")) {
            System.exit(0);
        } else if (textLine.equals("wq")) {
            bot.writeQuit();
            System.exit(0);
        } else if (textLine.equals("skip") || textLine.equals("")) {
            this.skipCategory(c);
        } else if (textLine.equals("s") || textLine.equals("pass")) {
            this.passed.add(request);
            AIMLSet difference = new AIMLSet("difference", bot);
            difference.addAll(this.testSet);
            difference.removeAll(this.passed);
            difference.writeAIMLSet();
            this.passed.writeAIMLSet();
        } else if (textLine.equals("a")) {
            template = alicetemplate;
            String filename = template.contains("<sr") ? MagicStrings.reductions_update_aiml_file : MagicStrings.personality_aiml_file;
            this.saveCategory(c.getPattern(), template, filename);
        } else if (textLine.equals("d")) {
            this.deleteCategory(c);
        } else if (textLine.equals("x")) {
            template = "<sraix services=\"pannous\">" + c.getPattern().replace("*", "<star/>") + "</sraix>";
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.sraix_aiml_file);
        } else if (textLine.equals("p")) {
            template = "<srai>" + MagicStrings.inappropriate_filter + "</srai>";
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.inappropriate_aiml_file);
        } else if (textLine.equals("f")) {
            template = "<srai>" + MagicStrings.profanity_filter + "</srai>";
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.profanity_aiml_file);
        } else if (textLine.equals("i")) {
            template = "<srai>" + MagicStrings.insult_filter + "</srai>";
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.insult_aiml_file);
        } else if (textLine.contains("<srai>") || textLine.contains("<sr/>")) {
            template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.reductions_update_aiml_file);
        } else if (textLine.contains("<oob>")) {
            template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.oob_aiml_file);
        } else if (textLine.contains("<set name") || botThinks.length() > 0) {
            template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.predicates_aiml_file);
        } else if (textLine.contains("<get name") && !textLine.contains("<get name=\"name")) {
            template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.predicates_aiml_file);
        } else {
            template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.personality_aiml_file);
        }
    }
}

