/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import javax.realtime.MemoryArea;
import javolution.context.ObjectFactory;
import javolution.context.PersistentContext;
import javolution.lang.MathLib;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastList;
import javolution.util.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastTable<E>
extends FastCollection<E>
implements List<E>,
Reusable,
RandomAccess {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastTable();
        }

        public void cleanup(Object object) {
            ((FastTable)object).reset();
        }
    };
    private static final int B0 = 4;
    private static final int C0 = 16;
    private static final int B1 = 10;
    private static final int C1 = 1024;
    private static final int M1 = 1023;
    private transient E[] _low;
    private transient E[][] _high;
    private transient int _capacity = 16;
    private transient int _size;
    private transient FastComparator<? super E> _valueComparator = FastComparator.DEFAULT;
    private static final Object[] NULL_BLOCK = new Object[1024];
    private static final long serialVersionUID = 1L;
    static volatile int ONE_VOLATILE = 1;

    public FastTable() {
        this._low = new Object[16];
        this._high = new Object[1][];
        this._high[0] = this._low;
    }

    public FastTable(String string) {
        this();
        new PersistentContext.Reference(string, this){

            protected void notifyChange() {
                FastTable.this.clear();
                FastTable.this.addAll((FastList)this.get());
            }
        };
    }

    public FastTable(int n) {
        this();
        while (n > this._capacity) {
        }
    }

    public FastTable(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public static <E> FastTable<E> newInstance() {
        return (FastTable)FACTORY.object();
    }

    public static void recycle(FastTable fastTable) {
        FACTORY.recycle(fastTable);
    }

    public void setSize(int n) {
        while (this._size < n) {
            this.addLast(null);
        }
        while (this._size > n) {
            this.removeLast();
        }
    }

    @Override
    public final E get(int n) {
        if (n >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        return n < 1024 ? this._low[n] : this._high[n >> 10][n & 0x3FF];
    }

    @Override
    public final E set(int n, E e) {
        if (n >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        E[] EArray = this._high[n >> 10];
        E e2 = EArray[n & 0x3FF];
        EArray[n & 0x3FF] = e;
        return e2;
    }

    @Override
    public final boolean add(E e) {
        if (this._size >= this._capacity) {
            this.increaseCapacity();
        }
        this._high[this._size >> 10][this._size & 0x3FF] = e;
        this._size += ONE_VOLATILE;
        return true;
    }

    @Override
    public final E getFirst() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this._low[0];
    }

    @Override
    public final E getLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this._size - 1);
    }

    @Override
    public final void addLast(E e) {
        this.add(e);
    }

    @Override
    public final E removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        this._size -= ONE_VOLATILE;
        E[] EArray = this._high[this._size >> 10];
        E e = EArray[this._size & 0x3FF];
        EArray[this._size & 0x3FF] = null;
        return e;
    }

    @Override
    public final void clear() {
        int n = this._size;
        this._size = ONE_VOLATILE - 1;
        for (int i = 0; i < n; i += 1024) {
            int n2 = MathLib.min(n - i, 1024);
            E[] EArray = this._high[i >> 10];
            System.arraycopy(NULL_BLOCK, 0, EArray, 0, n2);
        }
    }

    @Override
    public void reset() {
        this.clear();
        this.setValueComparator(FastComparator.DEFAULT);
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = collection.size();
        this.shiftRight(n, n2);
        Iterator<E> iterator = collection.iterator();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this._high[i >> 10][i & 0x3FF] = iterator.next();
        }
        this._size += n2 * ONE_VOLATILE;
        return n2 != 0;
    }

    @Override
    public final void add(int n, E e) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        this.shiftRight(n, 1);
        this._high[n >> 10][n & 0x3FF] = e;
        this._size += ONE_VOLATILE;
    }

    @Override
    public final E remove(int n) {
        E e = this.get(n);
        this._size -= ONE_VOLATILE;
        this.shiftLeft(n + 1, 1);
        this._high[this._size >> 10][this._size & 0x3FF] = null;
        return e;
    }

    public final void removeRange(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > this._size) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        this._size -= n3 * ONE_VOLATILE;
        this.shiftLeft(n, n3);
        int n4 = this._size + n3;
        for (int i = this._size; i < n4; ++i) {
            this._high[i >> 10][i & 0x3FF] = null;
        }
    }

    @Override
    public final int indexOf(Object object) {
        int n;
        FastComparator<E> fastComparator = this.getValueComparator();
        for (int i = 0; i < this._size; i += n) {
            E[] EArray = this._high[i >> 10];
            n = MathLib.min(EArray.length, this._size - i);
            for (int j = 0; j < n; ++j) {
                if (!(fastComparator == FastComparator.DEFAULT ? FastTable.defaultEquals(object, EArray[j]) : fastComparator.areEqual(object, EArray[j]))) continue;
                return i + j;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        int n;
        FastComparator<E> fastComparator = this.getValueComparator();
        for (int i = this._size - 1; i >= 0; i -= n) {
            E[] EArray = this._high[i >> 10];
            int n2 = n = (i & 0x3FF) + 1;
            while (--n2 >= 0) {
                if (!(fastComparator == FastComparator.DEFAULT ? FastTable.defaultEquals(object, EArray[n2]) : fastComparator.areEqual(object, EArray[n2]))) continue;
                return i + n2 - n + 1;
            }
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return FastTableIterator.valueOf(this, 0, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator() {
        return FastTableIterator.valueOf(this, 0, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException();
        }
        return FastTableIterator.valueOf(this, n, 0, this._size);
    }

    @Override
    public final List<E> subList(int n, int n2) {
        if (n < 0 || n2 > this._size || n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
        }
        return SubTable.valueOf(this, n, n2 - n);
    }

    public final void trimToSize() {
        while (this._capacity - this._size > 1024) {
            this._capacity -= 1024;
            this._high[this._capacity >> 10] = null;
        }
    }

    public final FastTable<E> sort() {
        if (this._size > 1) {
            this.quicksort(0, this._size - 1, this.getValueComparator());
        }
        return this;
    }

    private void quicksort(int n, int n2, FastComparator fastComparator) {
        int n3 = 0;
        if (n < n2) {
            n3 = this.partition(n, n2, fastComparator);
            this.quicksort(n, n3 - 1, fastComparator);
            this.quicksort(n3 + 1, n2, fastComparator);
        }
    }

    private int partition(int n, int n2, FastComparator fastComparator) {
        E e = this.get(n);
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (fastComparator.compare(this.get(n3), e) <= 0 && n3 < n2) {
                ++n3;
                continue;
            }
            while (fastComparator.compare(this.get(n4), e) > 0 && n4 > n) {
                --n4;
            }
            if (n3 < n4) {
                E e2 = this.get(n3);
                this.set(n3, this.get(n4));
                this.set(n4, e2);
            }
            if (n4 <= n3) break;
        }
        this.set(n, this.get(n4));
        this.set(n4, e);
        return n4;
    }

    public FastTable<E> setValueComparator(FastComparator<? super E> fastComparator) {
        this._valueComparator = fastComparator;
        return this;
    }

    @Override
    public FastComparator<? super E> getValueComparator() {
        return this._valueComparator;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final FastCollection.Record head() {
        return Index.valueOf(-1);
    }

    @Override
    public final FastCollection.Record tail() {
        return Index.valueOf(this._size);
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return this.get(((Index)record).intValue());
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this.remove(((Index)record).intValue());
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        int n = objectInputStream.readInt();
        this._capacity = 16;
        while (this._capacity < this._size && this._capacity < 1024) {
            this._capacity <<= 1;
        }
        this._low = new Object[this._capacity];
        this._high = new Object[1][];
        this._high[0] = this._low;
        for (int i = 0; i < n; ++i) {
            this.addLast(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getValueComparator());
        int n = this._size;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(this.get(i));
        }
    }

    protected final int getCapacity() {
        return this._capacity;
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                if (FastTable.this._capacity < 1024) {
                    FastTable.this._capacity <<= 1;
                    Object[] objectArray = new Object[FastTable.this._capacity];
                    System.arraycopy(FastTable.this._low, 0, objectArray, 0, FastTable.this._low.length);
                    FastTable.access$102(FastTable.this, objectArray);
                    ((FastTable)FastTable.this)._high[0] = objectArray;
                } else {
                    int n = FastTable.this._capacity >> 10;
                    if (n >= FastTable.this._high.length) {
                        Object[][] objectArray = new Object[FastTable.this._high.length * 2][];
                        System.arraycopy(FastTable.this._high, 0, objectArray, 0, FastTable.this._high.length);
                        FastTable.access$202(FastTable.this, objectArray);
                    }
                    ((FastTable)FastTable.this)._high[n] = new Object[1024];
                    FastTable.this._capacity += 1024;
                }
            }
        });
    }

    private void shiftRight(int n, int n2) {
        while (this._size + n2 >= this._capacity) {
            this.increaseCapacity();
        }
        int n3 = this._size;
        while (--n3 >= n) {
            int n4 = n3 + n2;
            this._high[n4 >> 10][n4 & 0x3FF] = this._high[n3 >> 10][n3 & 0x3FF];
        }
    }

    private void shiftLeft(int n, int n2) {
        for (int i = n; i < this._size; ++i) {
            int n3 = i - n2;
            this._high[n3 >> 10][n3 & 0x3FF] = this._high[i >> 10][i & 0x3FF];
        }
    }

    private static boolean defaultEquals(Object object, Object object2) {
        return object == null ? object2 == null : object == object2 || object.equals(object2);
    }

    static /* synthetic */ Object[] access$102(FastTable fastTable, Object[] objectArray) {
        fastTable._low = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[][] access$202(FastTable fastTable, Object[][] objectArray) {
        fastTable._high = objectArray;
        return objectArray;
    }

    private static final class FastTableIterator
    implements ListIterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new FastTableIterator();
            }

            protected void cleanup(Object object) {
                FastTableIterator fastTableIterator = (FastTableIterator)object;
                fastTableIterator._table = null;
                FastTableIterator.access$702(fastTableIterator, null);
                FastTableIterator.access$802(fastTableIterator, null);
            }
        };
        private FastTable _table;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;
        private Object[] _low;
        private Object[][] _high;

        private FastTableIterator() {
        }

        public static FastTableIterator valueOf(FastTable fastTable, int n, int n2, int n3) {
            FastTableIterator fastTableIterator = (FastTableIterator)FACTORY.object();
            fastTableIterator._table = fastTable;
            fastTableIterator._start = n2;
            fastTableIterator._end = n3;
            fastTableIterator._nextIndex = n;
            fastTableIterator._low = fastTable._low;
            fastTableIterator._high = fastTable._high;
            fastTableIterator._currentIndex = -1;
            return fastTableIterator;
        }

        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        public Object next() {
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            return this._nextIndex < 1024 ? this._low[this._nextIndex++] : this._high[this._nextIndex >> 10][this._nextIndex++ & 0x3FF];
        }

        public int nextIndex() {
            return this._nextIndex;
        }

        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        public Object previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            int n = this._nextIndex;
            return n < 1024 ? this._low[n] : this._high[n >> 10][n & 0x3FF];
        }

        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object object) {
            this._table.add(this._nextIndex++, object);
            ++this._end;
            this._currentIndex = -1;
        }

        public void set(Object object) {
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._table.set(this._currentIndex, object);
        }

        public void remove() {
            if (this._currentIndex >= 0) {
                this._table.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }

        static /* synthetic */ Object[] access$702(FastTableIterator fastTableIterator, Object[] objectArray) {
            fastTableIterator._low = objectArray;
            return objectArray;
        }

        static /* synthetic */ Object[][] access$802(FastTableIterator fastTableIterator, Object[][] objectArray) {
            fastTableIterator._high = objectArray;
            return objectArray;
        }
    }

    private static final class SubTable
    extends FastCollection
    implements List,
    RandomAccess {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new SubTable();
            }

            protected void cleanup(Object object) {
                SubTable subTable = (SubTable)object;
                subTable._table = null;
            }
        };
        private FastTable _table;
        private int _offset;
        private int _size;

        private SubTable() {
        }

        public static SubTable valueOf(FastTable fastTable, int n, int n2) {
            SubTable subTable = (SubTable)FACTORY.object();
            subTable._table = fastTable;
            subTable._offset = n;
            subTable._size = n2;
            return subTable;
        }

        public int size() {
            return this._size;
        }

        public FastCollection.Record head() {
            return Index.valueOf(-1);
        }

        public FastCollection.Record tail() {
            return Index.valueOf(this._size);
        }

        public Object valueOf(FastCollection.Record record) {
            return this._table.get(((Index)record).intValue() + this._offset);
        }

        public void delete(FastCollection.Record record) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        public Object get(int n) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            return this._table.get(n + this._offset);
        }

        public Object set(int n, Object object) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            return this._table.set(n + this._offset, object);
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        public int indexOf(Object object) {
            FastComparator fastComparator = this._table.getValueComparator();
            int n = -1;
            while (++n < this._size) {
                if (!fastComparator.areEqual(object, this._table.get(n + this._offset))) continue;
                return n;
            }
            return -1;
        }

        public int lastIndexOf(Object object) {
            FastComparator fastComparator = this._table.getValueComparator();
            int n = this._size;
            while (--n >= 0) {
                if (!fastComparator.areEqual(object, this._table.get(n + this._offset))) continue;
                return n;
            }
            return -1;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n) {
            if (n >= 0 && n <= this._size) {
                return FastTableIterator.valueOf(this._table, n + this._offset, this._offset, this._offset + this._size);
            }
            throw new IndexOutOfBoundsException("index: " + n + " for table of size: " + this._size);
        }

        public List subList(int n, int n2) {
            if (n < 0 || n2 > this._size || n > n2) {
                throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
            }
            return SubTable.valueOf(this._table, this._offset + n, n2 - n);
        }
    }
}

