/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.Measure;
import javax.measure.converter.AddConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;

public class DecimalMeasure<Q extends Quantity>
extends Measure<BigDecimal, Q> {
    private final BigDecimal _value;
    private final Unit<Q> _unit;
    private static final long serialVersionUID = 1L;

    public DecimalMeasure(BigDecimal value, Unit<Q> unit) {
        this._value = value;
        this._unit = unit;
    }

    public static <Q extends Quantity> DecimalMeasure<Q> valueOf(BigDecimal decimal, Unit<Q> unit) {
        return new DecimalMeasure<Q>(decimal, unit);
    }

    public static <Q extends Quantity> DecimalMeasure<Q> valueOf(CharSequence csq) {
        String str = csq.toString();
        int numberLength = str.length();
        int unitStartIndex = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            for (int j = i + 1; j < str.length(); ++j) {
                if (Character.isWhitespace(str.charAt(j))) continue;
                unitStartIndex = j;
                break;
            }
            numberLength = i;
            break;
        }
        BigDecimal decimal = new BigDecimal(str.substring(0, numberLength));
        Unit<Quantity> unit = Unit.ONE;
        if (unitStartIndex > 0) {
            unit = Unit.valueOf(str.substring(unitStartIndex));
        }
        return new DecimalMeasure<Dimensionless>(decimal, unit);
    }

    @Override
    public Unit<Q> getUnit() {
        return this._unit;
    }

    @Override
    public BigDecimal getValue() {
        return this._value;
    }

    public DecimalMeasure<Q> to(Unit<Q> unit) {
        return this.to(unit, null);
    }

    public DecimalMeasure<Q> to(Unit<Q> unit, MathContext mathContext) {
        if (unit == this._unit || unit.equals(this._unit)) {
            return this;
        }
        UnitConverter cvtr = this._unit.getConverterTo(unit);
        if (cvtr instanceof RationalConverter) {
            RationalConverter factor = (RationalConverter)cvtr;
            BigDecimal dividend = BigDecimal.valueOf(factor.getDividend());
            BigDecimal divisor = BigDecimal.valueOf(factor.getDivisor());
            BigDecimal result = mathContext == null ? this._value.multiply(dividend).divide(divisor) : this._value.multiply(dividend, mathContext).divide(divisor, mathContext);
            return new DecimalMeasure<Q>(result, unit);
        }
        if (cvtr.isLinear()) {
            BigDecimal factor = BigDecimal.valueOf(cvtr.convert(1.0));
            BigDecimal result = mathContext == null ? this._value.multiply(factor) : this._value.multiply(factor, mathContext);
            return new DecimalMeasure<Q>(result, unit);
        }
        if (cvtr instanceof AddConverter) {
            BigDecimal offset = BigDecimal.valueOf(((AddConverter)cvtr).getOffset());
            BigDecimal result = mathContext == null ? this._value.add(offset) : this._value.add(offset, mathContext);
            return new DecimalMeasure<Q>(result, unit);
        }
        BigDecimal result = BigDecimal.valueOf(cvtr.convert(this._value.doubleValue()));
        return new DecimalMeasure<Q>(result, unit);
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        if (unit == this._unit || unit.equals(this._unit)) {
            return this._value.doubleValue();
        }
        return this._unit.getConverterTo(unit).convert(this._value.doubleValue());
    }
}

