/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.exceptions.MaryConfigurationException;
import marytts.unitselection.data.Unit;
import marytts.util.data.MaryHeader;
import marytts.vocalizations.VocalizationUnit;

public class VocalizationUnitFileReader {
    private MaryHeader hdr = null;
    private int numberOfUnits = 0;
    private int sampleRate = 0;
    private VocalizationUnit[] backchannelUnits;

    public VocalizationUnitFileReader() {
    }

    public VocalizationUnitFileReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    public void load(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File [" + fileName + "] was not found.");
        }
        try {
            this.hdr = new MaryHeader((DataInput)dis);
            if (this.hdr.getType() != 225) {
                throw new RuntimeException("File [" + fileName + "] is not a valid Mary Units file.");
            }
            this.numberOfUnits = dis.readInt();
            if (this.numberOfUnits < 0) {
                throw new RuntimeException("File [" + fileName + "] has a negative number of units. Aborting.");
            }
            this.sampleRate = dis.readInt();
            if (this.sampleRate < 0) {
                throw new RuntimeException("File [" + fileName + "] has a negative number sample rate. Aborting.");
            }
            this.backchannelUnits = new VocalizationUnit[this.numberOfUnits];
            for (int i = 0; i < this.numberOfUnits; ++i) {
                int noOfUnits = dis.readInt();
                Unit[] units = new Unit[noOfUnits];
                String[] unitNames = new String[noOfUnits];
                for (int j = 0; j < noOfUnits; ++j) {
                    long startTime = dis.readLong();
                    int duration = dis.readInt();
                    units[j] = new Unit(startTime, duration, j);
                    int charArraySize = dis.readInt();
                    char[] phoneChar = new char[charArraySize];
                    for (int k = 0; k < charArraySize; ++k) {
                        phoneChar[k] = dis.readChar();
                    }
                    unitNames[j] = new String(phoneChar);
                }
                long startBCTime = units[0].startTime;
                int bcDuration = (int)units[noOfUnits - 1].startTime + units[noOfUnits - 1].duration - (int)units[0].startTime;
                this.backchannelUnits[i] = new VocalizationUnit(startBCTime, bcDuration, i);
                this.backchannelUnits[i].setUnits(units);
                this.backchannelUnits[i].setUnitNames(unitNames);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Reading the Mary header from file [" + fileName + "] failed.", e);
        }
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public VocalizationUnit getUnit(int i) {
        return this.backchannelUnits[i];
    }

    public VocalizationUnit[] getUnit(int[] i) {
        VocalizationUnit[] ret = new VocalizationUnit[i.length];
        for (int k = 0; k < i.length; ++k) {
            ret[k] = this.getUnit(i[k]);
        }
        return ret;
    }

    public VocalizationUnit getNextUnit(VocalizationUnit u) {
        if (u == null || u.index >= this.backchannelUnits.length - 1 || u.index < 0) {
            return null;
        }
        return this.backchannelUnits[u.index + 1];
    }

    public VocalizationUnit getPreviousUnit(VocalizationUnit u) {
        if (u == null || u.index >= this.backchannelUnits.length || u.index <= 0) {
            return null;
        }
        return this.backchannelUnits[u.index - 1];
    }

    public boolean isEdgeUnit(int i) {
        return this.backchannelUnits[i].isEdgeUnit();
    }

    public static void main(String[] args) throws Exception {
        String fileName = "/home/sathish/Work/dfki399/backchannel/mary_files/BCCphoneUnits.mry";
        VocalizationUnitFileReader bcUfr = new VocalizationUnitFileReader();
        bcUfr.load(fileName);
    }
}

