/*
 * Decompiled with CFR 0.152.
 */
package marytts.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;

public class FeatureUtils {
    public static FeatureDefinition readFeatureDefinition(String targetFeaturesData) throws IOException {
        try (BufferedReader in = new BufferedReader(new StringReader(targetFeaturesData));){
            FeatureDefinition featureDefinition = new FeatureDefinition(in, false);
            return featureDefinition;
        }
    }

    public static FeatureDefinition readFeatureDefinition(InputStream featureStream) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(featureStream, "UTF-8"));){
            FeatureDefinition featureDefinition = new FeatureDefinition(in, false);
            return featureDefinition;
        }
    }

    public static FeatureVector[] readFeatureVectors(String targetFeaturesData) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new StringReader(targetFeaturesData));
        FeatureDefinition def = new FeatureDefinition(br, false);
        while ((line = br.readLine()) != null && !line.trim().equals("")) {
        }
        ArrayList<FeatureVector> fvs = new ArrayList<FeatureVector>();
        while ((line = br.readLine()) != null && !line.trim().equals("")) {
            FeatureVector fv = def.toFeatureVector(0, line);
            fvs.add(fv);
        }
        return fvs.toArray(new FeatureVector[fvs.size()]);
    }
}

