/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import java.util.ArrayList;
import java.util.List;
import marytts.exceptions.SynthesisException;
import marytts.modules.synthesis.Voice;
import marytts.unitselection.data.UnitDatabase;
import marytts.unitselection.select.SelectedUnit;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.TargetCostFunction;
import marytts.unitselection.select.viterbi.Viterbi;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UnitSelector {
    protected UnitDatabase database;
    protected Logger logger = MaryUtils.getLogger(this.getClass());
    protected float targetCostWeight;
    protected float sCostWeight = -1.0f;
    protected int beamSize;

    public void load(UnitDatabase unitDatabase, float targetCostWeight, int beamSize) {
        this.database = unitDatabase;
        this.targetCostWeight = targetCostWeight;
        this.beamSize = beamSize;
    }

    public void load(UnitDatabase unitDatabase, float targetCostWeight, float sCostWeight, int beamSize) {
        this.database = unitDatabase;
        this.targetCostWeight = targetCostWeight;
        this.sCostWeight = sCostWeight;
        this.beamSize = beamSize;
    }

    public List<SelectedUnit> selectUnits(List<Element> tokensAndBoundaries, Voice voice) throws SynthesisException {
        long time = System.currentTimeMillis();
        ArrayList<Element> segmentsAndBoundaries = new ArrayList<Element>();
        for (Element tOrB : tokensAndBoundaries) {
            if (tOrB.getTagName().equals("boundary")) {
                segmentsAndBoundaries.add(tOrB);
                continue;
            }
            assert (tOrB.getTagName().equals("t")) : "Expected token, got " + tOrB.getTagName();
            NodeList segs = tOrB.getElementsByTagName("ph");
            int max = segs.getLength();
            for (int i = 0; i < max; ++i) {
                segmentsAndBoundaries.add((Element)segs.item(i));
            }
        }
        List<Target> targets = this.createTargets(segmentsAndBoundaries);
        TargetCostFunction tcf = this.database.getTargetCostFunction();
        for (Target target : targets) {
            tcf.computeTargetFeatures(target);
        }
        Viterbi viterbi = this.sCostWeight < 0.0f ? new Viterbi(targets, this.database, this.targetCostWeight, this.beamSize) : new Viterbi(targets, this.database, this.targetCostWeight, this.sCostWeight, this.beamSize);
        viterbi.apply();
        List<SelectedUnit> selectedUnits = viterbi.getSelectedUnits();
        if (selectedUnits == null) {
            throw new IllegalStateException("Viterbi: can't find path");
        }
        long newtime = System.currentTimeMillis() - time;
        this.logger.debug((Object)("Selection took " + newtime + " milliseconds"));
        return selectedUnits;
    }

    protected List<Target> createTargets(List<Element> segmentsAndBoundaries) {
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Element sOrB : segmentsAndBoundaries) {
            String phone = UnitSelector.getPhoneSymbol(sOrB);
            targets.add(new Target(phone, sOrB));
        }
        return targets;
    }

    public static String getPhoneSymbol(Element segmentOrBoundary) {
        String phone;
        if (segmentOrBoundary.getTagName().equals("ph")) {
            phone = segmentOrBoundary.getAttribute("p");
        } else {
            assert (segmentOrBoundary.getTagName().equals("boundary")) : "Expected boundary element, but got " + segmentOrBoundary.getTagName();
            phone = "_";
        }
        return phone;
    }
}

