/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.interpolation;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import marytts.exceptions.SynthesisException;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.signalproc.process.FramewiseMerger;
import marytts.signalproc.process.InlineFrameMerger;
import marytts.signalproc.process.LSFInterpolator;
import marytts.unitselection.UnitSelectionVoice;
import marytts.unitselection.concat.BaseUnitConcatenator;
import marytts.unitselection.concat.UnitConcatenator;
import marytts.unitselection.interpolation.InterpolatingVoice;
import marytts.unitselection.select.SelectedUnit;
import marytts.unitselection.select.UnitSelector;
import marytts.util.MaryUtils;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InterpolatingSynthesizer
implements WaveformSynthesizer {
    protected Logger logger;

    @Override
    public void startup() throws Exception {
        this.logger = MaryUtils.getLogger((String)"InterpolatingSynthesizer");
        Voice.registerVoice(new InterpolatingVoice(this, "interpolatingvoice"));
        this.logger.info((Object)"started.");
    }

    @Override
    public void powerOnSelfTest() throws Error {
    }

    @Override
    public AudioInputStream synthesize(List<Element> tokensAndBoundaries, Voice voice, String outputParams) throws SynthesisException {
        AudioInputStream audio2;
        AudioInputStream audio1;
        if (tokensAndBoundaries.size() == 0) {
            return null;
        }
        Element first = tokensAndBoundaries.get(0);
        Element voiceElement = (Element)MaryDomUtils.getAncestor((Node)first, (String)"voice");
        String name = voiceElement.getAttribute("name");
        String[] parts = name.split("\\s+");
        assert (parts.length == 4);
        assert (parts[1].equals("with"));
        assert (parts[2].endsWith("%"));
        int percent = Integer.parseInt(parts[2].substring(0, parts[2].length() - 1));
        Voice voice1 = Voice.getVoice(parts[0]);
        assert (voice1 != null);
        Voice voice2 = Voice.getVoice(parts[3]);
        assert (voice2 != null);
        if (!(voice1 instanceof UnitSelectionVoice)) {
            throw new IllegalArgumentException("Voices of type " + voice.getClass().getName() + " not supported!");
        }
        if (!(voice2 instanceof UnitSelectionVoice)) {
            throw new IllegalArgumentException("Voices of type " + voice.getClass().getName() + " not supported!");
        }
        UnitSelectionVoice usv1 = (UnitSelectionVoice)voice1;
        UnitSelectionVoice usv2 = (UnitSelectionVoice)voice2;
        UnitSelector unitSel1 = usv1.getUnitSelector();
        List<SelectedUnit> selectedUnits1 = unitSel1.selectUnits(tokensAndBoundaries, voice);
        UnitSelector unitSel2 = usv2.getUnitSelector();
        List<SelectedUnit> selectedUnits2 = unitSel2.selectUnits(tokensAndBoundaries, voice);
        assert (selectedUnits1.size() == selectedUnits2.size()) : "Unexpected difference in number of units: " + selectedUnits1.size() + " vs. " + selectedUnits2.size();
        int numUnits = selectedUnits1.size();
        UnitConcatenator unitConcatenator1 = usv1.getConcatenator();
        try {
            audio1 = unitConcatenator1.getAudio(selectedUnits1);
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Iterator<SelectedUnit> selIt = selectedUnits1.iterator();
            while (selIt.hasNext()) {
                pw.println(selIt.next());
            }
            throw new SynthesisException("For voice " + voice1.getName() + ", problems generating audio for unit chain: " + sw.toString(), (Throwable)ioe);
        }
        AudioDoubleDataSource audioSource1 = new AudioDoubleDataSource(audio1);
        UnitConcatenator unitConcatenator2 = usv2.getConcatenator();
        try {
            audio2 = unitConcatenator2.getAudio(selectedUnits2);
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Iterator<SelectedUnit> selIt = selectedUnits2.iterator();
            while (selIt.hasNext()) {
                pw.println(selIt.next());
            }
            throw new SynthesisException("For voice " + voice2.getName() + ", problems generating audio for unit chain: " + sw.toString(), (Throwable)ioe);
        }
        AudioDoubleDataSource audioSource2 = new AudioDoubleDataSource(audio2);
        int sampleRate1 = (int)usv1.dbAudioFormat().getSampleRate();
        double[] label1 = new double[numUnits];
        double t1 = 0.0;
        int sampleRate2 = (int)usv2.dbAudioFormat().getSampleRate();
        double[] label2 = new double[numUnits];
        double t2 = 0.0;
        for (int i = 0; i < numUnits; ++i) {
            SelectedUnit u1 = selectedUnits1.get(i);
            SelectedUnit u2 = selectedUnits2.get(i);
            BaseUnitConcatenator.UnitData ud1 = (BaseUnitConcatenator.UnitData)u1.getConcatenationData();
            int unitDuration1 = ud1.getUnitDuration();
            if (unitDuration1 < 0) {
                unitDuration1 = 0;
                Datagram[] d = ud1.getFrames();
                for (int id = 0; id < d.length; ++id) {
                    unitDuration1 = (int)((long)unitDuration1 + d[id].getDuration());
                }
            }
            label1[i] = t1 += (double)((float)unitDuration1 / (float)sampleRate1);
            BaseUnitConcatenator.UnitData ud2 = (BaseUnitConcatenator.UnitData)u2.getConcatenationData();
            int unitDuration2 = ud2.getUnitDuration();
            if (unitDuration2 < 0) {
                unitDuration2 = 0;
                Datagram[] d = ud2.getFrames();
                for (int id = 0; id < d.length; ++id) {
                    unitDuration2 = (int)((long)unitDuration2 + d[id].getDuration());
                }
            }
            label2[i] = t2 += (double)((float)unitDuration2 / (float)sampleRate2);
            this.logger.debug((Object)(usv1.getName() + " [" + u1.getTarget() + "] " + label1[i] + " -- " + usv2.getName() + " [" + u2.getTarget() + "] " + label2[i]));
        }
        int frameLength = Integer.getInteger("signalproc.lpcanalysisresynthesis.framelength", 512);
        int predictionOrder = Integer.getInteger("signalproc.lpcanalysisresynthesis.predictionorder", 20);
        double r = (double)percent / 100.0;
        assert (r >= 0.0);
        assert (r <= 1.0);
        FramewiseMerger foas = new FramewiseMerger((DoubleDataSource)audioSource1, frameLength, sampleRate1, (DoubleDataSource)new BufferedDoubleDataSource(label1), (DoubleDataSource)audioSource2, sampleRate2, (DoubleDataSource)new BufferedDoubleDataSource(label2), (InlineFrameMerger)new LSFInterpolator(predictionOrder, r));
        DDSAudioInputStream outputAudio = new DDSAudioInputStream((DoubleDataSource)new BufferedDoubleDataSource((DoubleDataSource)foas), audio1.getFormat());
        return outputAudio;
    }
}

