/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Properties;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.exceptions.MaryConfigurationException;
import marytts.signalproc.adaptation.prosody.BasicProsodyModifierParams;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartWaveform;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizedSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.unitselection.data.HnmDatagram;
import marytts.unitselection.data.TimelineReader;
import marytts.util.data.Datagram;
import marytts.util.io.FileUtils;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;

public class HnmTimelineReader
extends TimelineReader {
    public HntmAnalyzerParams analysisParams;

    public HnmTimelineReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    @Override
    protected void load(String fileName) throws IOException, MaryConfigurationException {
        super.load(fileName);
        Properties props = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.procHdr.getString().getBytes("latin1"));
        props.load(bais);
        this.ensurePresent(props, "hnm.noiseModel");
        this.analysisParams = new HntmAnalyzerParams();
        this.analysisParams.noiseModel = Integer.parseInt(props.getProperty("hnm.noiseModel"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.numFilteringStages = Integer.parseInt(props.getProperty("hnm.numFiltStages"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.medianFilterLength = Integer.parseInt(props.getProperty("hnm.medianFiltLen"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.movingAverageFilterLength = Integer.parseInt(props.getProperty("hnm.maFiltLen"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.cumulativeAmpThreshold = Float.parseFloat(props.getProperty("hnm.cumAmpTh"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.maximumAmpThresholdInDB = Float.parseFloat(props.getProperty("hnm.maxAmpTh"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.harmonicDeviationPercent = Float.parseFloat(props.getProperty("hnm.harmDevPercent"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.sharpPeakAmpDiffInDB = Float.parseFloat(props.getProperty("hnm.sharpPeakAmpDiff"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.minimumTotalHarmonics = Integer.parseInt(props.getProperty("hnm.minHarmonics"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.maximumTotalHarmonics = Integer.parseInt(props.getProperty("hnm.maxHarmonics"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.minimumVoicedFrequencyOfVoicing = Float.parseFloat(props.getProperty("hnm.minVoicedFreq"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.maximumVoicedFrequencyOfVoicing = Float.parseFloat(props.getProperty("hnm.maxVoicedFreq"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.maximumFrequencyOfVoicingFinalShift = Float.parseFloat(props.getProperty("hnm.maxFreqVoicingFinalShift"));
        this.analysisParams.hnmPitchVoicingAnalyzerParams.neighsPercent = Float.parseFloat(props.getProperty("hnm.neighsPercent"));
        this.analysisParams.harmonicPartCepstrumOrder = Integer.parseInt(props.getProperty("hnm.harmCepsOrder"));
        this.analysisParams.regularizedCepstrumWarpingMethod = Integer.parseInt(props.getProperty("hnm.regCepWarpMethod"));
        this.analysisParams.regularizedCepstrumLambdaHarmonic = Float.parseFloat(props.getProperty("hnm.regCepsLambda"));
        this.analysisParams.noisePartLpOrder = Integer.parseInt(props.getProperty("hnm.noiseLpOrder"));
        this.analysisParams.preemphasisCoefNoise = Float.parseFloat(props.getProperty("hnm.preCoefNoise"));
        this.analysisParams.hpfBeforeNoiseAnalysis = Boolean.parseBoolean(props.getProperty("hnm.hpfBeforeNoiseAnalysis"));
        this.analysisParams.numPeriodsHarmonicsExtraction = Float.parseFloat(props.getProperty("hnm.harmNumPer"));
    }

    private void ensurePresent(Properties props, String key) throws MaryConfigurationException {
        if (!props.containsKey(key)) {
            throw new MaryConfigurationException("Processing header does not contain required field '" + key + "'");
        }
    }

    @Override
    protected Datagram getNextDatagram(ByteBuffer bb) {
        HnmDatagram d = null;
        if (bb.position() == bb.limit()) {
            return null;
        }
        try {
            d = new HnmDatagram(bb, this.analysisParams.noiseModel);
        }
        catch (IOException e) {
            return null;
        }
        return d;
    }

    private void testSynthesizeFromDatagrams(LinkedList<HnmDatagram> datagrams, int startIndex, int endIndex, DataOutputStream output) throws IOException {
        int i;
        HntmSynthesizer s = new HntmSynthesizer();
        HntmAnalyzerParams hnmAnalysisParams = new HntmAnalyzerParams();
        HntmSynthesizerParams synthesisParams = new HntmSynthesizerParams();
        BasicProsodyModifierParams pmodParams = new BasicProsodyModifierParams();
        int samplingRateInHz = this.getSampleRate();
        int totalFrm = 0;
        float originalDurationInSeconds = 0.0f;
        for (i = startIndex; i <= endIndex; ++i) {
            HnmDatagram datagram = datagrams.get(i);
            if (datagram == null || !(datagram instanceof HnmDatagram)) continue;
            ++totalFrm;
            float deltaTimeInSeconds = datagram.frame.deltaAnalysisTimeInSeconds;
            originalDurationInSeconds += deltaTimeInSeconds;
        }
        HntmSpeechSignal hnmSignal = new HntmSpeechSignal(totalFrm, samplingRateInHz, originalDurationInSeconds);
        int frameCount = 0;
        float tAnalysisInSeconds = 0.0f;
        for (i = startIndex; i <= endIndex; ++i) {
            HnmDatagram datagram = datagrams.get(i);
            if (datagram == null || !(datagram instanceof HnmDatagram)) continue;
            tAnalysisInSeconds += datagram.getFrame().deltaAnalysisTimeInSeconds;
            if (frameCount >= totalFrm) continue;
            hnmSignal.frames[frameCount] = new HntmSpeechFrame(datagram.getFrame());
            hnmSignal.frames[frameCount].tAnalysisInSeconds = tAnalysisInSeconds;
            ++frameCount;
        }
        HntmSynthesizedSignal ss = null;
        if (totalFrm > 0) {
            ss = s.synthesize(hnmSignal, null, null, pmodParams, null, hnmAnalysisParams, synthesisParams);
            FileUtils.writeBinaryFile((short[])ArrayUtils.copyDouble2Short((double[])ss.output), (DataOutputStream)output);
            if (ss.output != null) {
                ss.output = MathUtils.multiply((double[])ss.output, (double)3.0517578125E-5);
            }
        }
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        HnmTimelineReader h = new HnmTimelineReader(args[0]);
        LinkedList<HnmDatagram> datagrams = new LinkedList<HnmDatagram>();
        int count = 0;
        long startDatagramTime = 0L;
        int numDatagrams = (int)h.numDatagrams;
        Datagram[] rawDatagrams = h.getDatagrams(0L, numDatagrams, h.getSampleRate(), (long[])null);
        for (int i = 0; i < rawDatagrams.length; ++i) {
            HnmDatagram d = (HnmDatagram)rawDatagrams[i];
            datagrams.add(d);
            System.out.println("Datagram " + String.valueOf(++count) + "Noise waveform size=" + ((FrameNoisePartWaveform)d.frame.n).waveform().length);
        }
        int clusterSize = 1000;
        int numClusters = (int)Math.floor((double)numDatagrams / (double)clusterSize + 0.5);
        for (int i = 0; i < numClusters; ++i) {
            DataOutputStream output = new DataOutputStream(new FileOutputStream(new File(String.format("%s_%06d.bin", args[1], i))));
            int startIndex = i * clusterSize;
            int endIndex = Math.min((i + 1) * clusterSize - 1, numDatagrams - 1);
            h.testSynthesizeFromDatagrams(datagrams, startIndex, endIndex, output);
            System.out.println("Timeline cluster " + String.valueOf(i + 1) + " of " + String.valueOf(numClusters) + " synthesized...");
            output.close();
        }
    }
}

