/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.data.HalfPhoneFeatureFileReader;
import marytts.unitselection.data.Unit;
import marytts.util.data.MaryHeader;

public class FeatureFileReader {
    protected MaryHeader hdr;
    protected FeatureDefinition featureDefinition;
    protected FeatureVector[] featureVectors;

    public static FeatureFileReader getFeatureFileReader(String fileName) throws IOException, MaryConfigurationException {
        int fileType = MaryHeader.peekFileType((String)fileName);
        if (fileType == 300) {
            return new FeatureFileReader(fileName);
        }
        if (fileType == 301) {
            return new HalfPhoneFeatureFileReader(fileName);
        }
        throw new MaryConfigurationException("File " + fileName + ": Type " + fileType + " is not a known unit feature file type");
    }

    public FeatureFileReader() {
    }

    public FeatureFileReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    public void load(String fileName) throws IOException, MaryConfigurationException {
        this.loadFromByteBuffer(fileName);
    }

    protected void loadFromStream(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        this.hdr = new MaryHeader((DataInput)dis);
        if (this.hdr.getType() != 300 && this.hdr.getType() != 301) {
            throw new IOException("File [" + fileName + "] is not a valid Mary feature file.");
        }
        this.featureDefinition = new FeatureDefinition(dis);
        int numberOfUnits = dis.readInt();
        this.featureVectors = new FeatureVector[numberOfUnits];
        for (int i = 0; i < numberOfUnits; ++i) {
            this.featureVectors[i] = this.featureDefinition.readFeatureVector(i, dis);
        }
    }

    protected void loadFromByteBuffer(String fileName) throws IOException, MaryConfigurationException {
        FileInputStream fis = new FileInputStream(fileName);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        fis.close();
        this.hdr = new MaryHeader((ByteBuffer)bb);
        if (this.hdr.getType() != 300 && this.hdr.getType() != 301) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary feature file.");
        }
        this.featureDefinition = new FeatureDefinition(bb);
        int numberOfUnits = bb.getInt();
        this.featureVectors = new FeatureVector[numberOfUnits];
        for (int i = 0; i < numberOfUnits; ++i) {
            this.featureVectors[i] = this.featureDefinition.readFeatureVector(i, bb);
        }
    }

    public FeatureVector getFeatureVector(int unitIndex) {
        return this.featureVectors[unitIndex];
    }

    public FeatureVector[] getCopyOfFeatureVectors() {
        return (FeatureVector[])this.featureVectors.clone();
    }

    public FeatureVector[] getFeatureVectors() {
        return this.featureVectors;
    }

    public FeatureVector[] featureVectorMapping(FeatureDefinition newFeatureDefinition) {
        int noContiniousFeatures;
        int noShortFeatures;
        int noByteFeatures;
        if (!this.featureDefinition.contains(newFeatureDefinition)) {
            throw new RuntimeException("the new feature definition is not a subset of original feature definition");
        }
        int numberOfFeatures = newFeatureDefinition.getNumberOfFeatures();
        if (numberOfFeatures != (noByteFeatures = newFeatureDefinition.getNumberOfByteFeatures()) + (noShortFeatures = newFeatureDefinition.getNumberOfShortFeatures()) + (noContiniousFeatures = newFeatureDefinition.getNumberOfContinuousFeatures())) {
            throw new RuntimeException("The sum of byte, short and continious features are not equal to number of features");
        }
        String[] featureNames = new String[numberOfFeatures];
        for (int j = 0; j < numberOfFeatures; ++j) {
            featureNames[j] = newFeatureDefinition.getFeatureName(j);
        }
        int[] featureIndexes = this.featureDefinition.getFeatureIndexArray(featureNames);
        FeatureVector[] newFV = new FeatureVector[this.getNumberOfUnits()];
        for (int i = 0; i < this.getNumberOfUnits(); ++i) {
            byte[] byteFeatures = new byte[noByteFeatures];
            short[] shortFeatures = new short[noShortFeatures];
            float[] continiousFeatures = new float[noContiniousFeatures];
            int countByteFeatures = 0;
            int countShortFeatures = 0;
            int countFloatFeatures = 0;
            for (int j = 0; j < featureIndexes.length; ++j) {
                if (newFeatureDefinition.isByteFeature(j)) {
                    byteFeatures[countByteFeatures++] = this.featureVectors[i].getByteFeature(featureIndexes[j]);
                    continue;
                }
                if (newFeatureDefinition.isShortFeature(j)) {
                    shortFeatures[countShortFeatures++] = this.featureVectors[i].getShortFeature(featureIndexes[j]);
                    continue;
                }
                if (!newFeatureDefinition.isContinuousFeature(j)) continue;
                continiousFeatures[countFloatFeatures++] = this.featureVectors[i].getContinuousFeature(featureIndexes[j]);
            }
            newFV[i] = newFeatureDefinition.toFeatureVector(i, byteFeatures, shortFeatures, continiousFeatures);
        }
        return newFV;
    }

    public FeatureVector getFeatureVector(Unit unit) {
        return this.featureVectors[unit.index];
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.featureDefinition;
    }

    public int getNumberOfUnits() {
        return this.featureVectors.length;
    }
}

