/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import marytts.cart.CART;
import marytts.cart.io.MaryCARTReader;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.server.MaryProperties;
import marytts.unitselection.concat.FdpsolaUnitConcatenator;
import marytts.unitselection.concat.UnitConcatenator;
import marytts.unitselection.data.TimelineReader;
import marytts.unitselection.data.UnitDatabase;
import marytts.unitselection.data.UnitFileReader;
import marytts.unitselection.select.JoinCostFunction;
import marytts.unitselection.select.JoinModelCost;
import marytts.unitselection.select.StatisticalCostFunction;
import marytts.unitselection.select.TargetCostFunction;
import marytts.unitselection.select.UnitSelector;

public class UnitSelectionVoice
extends Voice {
    protected UnitDatabase database;
    protected UnitSelector unitSelector;
    protected UnitConcatenator concatenator;
    protected UnitConcatenator modificationConcatenator;
    protected String domain;
    protected String name;
    protected CART[] f0Carts;
    protected String exampleText;

    public UnitSelectionVoice(String name, WaveformSynthesizer synthesizer) throws MaryConfigurationException {
        super(name, synthesizer);
        try {
            FeatureProcessorManager featProcManager;
            this.name = name;
            String header = "voice." + name;
            this.domain = MaryProperties.needProperty(header + ".domain");
            InputStream exampleTextStream = null;
            exampleTextStream = !this.domain.equals("general") ? MaryProperties.needStream(header + ".exampleTextFile") : MaryProperties.getStream(header + ".exampleTextFile");
            if (exampleTextStream != null) {
                this.readExampleText(exampleTextStream);
            }
            if ((featProcManager = FeatureRegistry.getFeatureProcessorManager(this)) == null) {
                featProcManager = FeatureRegistry.getFeatureProcessorManager(this.getLocale());
            }
            if (featProcManager == null) {
                throw new MaryConfigurationException("No feature processor manager for voice '" + name + "' (locale " + this.getLocale() + ")");
            }
            logger.debug((Object)"...loading target cost function...");
            String featureFileName = MaryProperties.needFilename(header + ".featureFile");
            InputStream targetWeightStream = MaryProperties.getStream(header + ".targetCostWeights");
            String targetCostClass = MaryProperties.needProperty(header + ".targetCostClass");
            TargetCostFunction targetFunction = (TargetCostFunction)Class.forName(targetCostClass).newInstance();
            targetFunction.load(featureFileName, targetWeightStream, featProcManager);
            logger.debug((Object)"...loading join cost function...");
            String joinCostClass = MaryProperties.needProperty(header + ".joinCostClass");
            JoinCostFunction joinFunction = (JoinCostFunction)Class.forName(joinCostClass).newInstance();
            if (joinFunction instanceof JoinModelCost) {
                ((JoinModelCost)joinFunction).setFeatureDefinition(targetFunction.getFeatureDefinition());
            }
            joinFunction.init(header);
            StatisticalCostFunction sCostFunction = null;
            boolean useSCost = MaryProperties.getBoolean(header + ".useSCost", false);
            if (useSCost) {
                logger.debug((Object)"...loading scost function...");
                String sCostClass = MaryProperties.needProperty(header + ".sCostClass");
                sCostFunction = (StatisticalCostFunction)Class.forName(sCostClass).newInstance();
                sCostFunction.init(header);
            }
            logger.debug((Object)"...loading units file...");
            String unitReaderClass = MaryProperties.needProperty(header + ".unitReaderClass");
            String unitsFile = MaryProperties.needFilename(header + ".unitsFile");
            UnitFileReader unitReader = (UnitFileReader)Class.forName(unitReaderClass).newInstance();
            unitReader.load(unitsFile);
            logger.debug((Object)"...loading cart file...");
            InputStream cartStream = MaryProperties.needStream(header + ".cartFile");
            CART cart = new MaryCARTReader().loadFromStream(cartStream);
            cartStream.close();
            int backtrace = MaryProperties.getInteger(header + ".cart.backtrace", 100);
            logger.debug((Object)"...loading audio time line...");
            String timelineReaderClass = MaryProperties.needProperty(header + ".audioTimelineReaderClass");
            String timelineFile = MaryProperties.needFilename(header + ".audioTimelineFile");
            Class<TimelineReader> theClass = Class.forName(timelineReaderClass).asSubclass(TimelineReader.class);
            Class[] constructorArgTypes = new Class[]{String.class};
            Object[] args = new Object[]{timelineFile};
            Constructor<TimelineReader> constructor = theClass.getConstructor(constructorArgTypes);
            TimelineReader timelineReader = constructor.newInstance(args);
            String basenameTimelineFile = MaryProperties.getFilename(header + ".basenameTimeline");
            TimelineReader basenameTimelineReader = null;
            if (basenameTimelineFile != null) {
                logger.debug((Object)"...loading basename time line...");
                basenameTimelineReader = new TimelineReader(basenameTimelineFile);
            }
            logger.debug((Object)"...instantiating database...");
            String databaseClass = MaryProperties.needProperty(header + ".databaseClass");
            this.database = (UnitDatabase)Class.forName(databaseClass).newInstance();
            if (useSCost) {
                this.database.load(targetFunction, joinFunction, sCostFunction, unitReader, cart, timelineReader, basenameTimelineReader, backtrace);
            } else {
                this.database.load(targetFunction, joinFunction, unitReader, cart, timelineReader, basenameTimelineReader, backtrace);
            }
            logger.debug((Object)"...instantiating unit selector...");
            String selectorClass = MaryProperties.needProperty(header + ".selectorClass");
            this.unitSelector = (UnitSelector)Class.forName(selectorClass).newInstance();
            float targetCostWeights = Float.parseFloat(MaryProperties.getProperty(header + ".viterbi.wTargetCosts", "0.33"));
            int beamSize = MaryProperties.getInteger(header + ".viterbi.beamsize", 100);
            if (!useSCost) {
                this.unitSelector.load(this.database, targetCostWeights, beamSize);
            } else {
                float sCostWeights = Float.parseFloat(MaryProperties.getProperty(header + ".viterbi.wSCosts", "0.33"));
                this.unitSelector.load(this.database, targetCostWeights, sCostWeights, beamSize);
            }
            logger.debug((Object)"...instantiating unit concatenator...");
            String concatenatorClass = MaryProperties.needProperty(header + ".concatenatorClass");
            this.concatenator = (UnitConcatenator)Class.forName(concatenatorClass).newInstance();
            this.concatenator.load(this.database);
            this.f0Carts = null;
            InputStream leftF0CartStream = MaryProperties.getStream(header + ".f0.cart.left");
            if (leftF0CartStream != null) {
                logger.debug((Object)"...loading f0 trees...");
                this.f0Carts = new CART[3];
                this.f0Carts[0] = new MaryCARTReader().loadFromStream(leftF0CartStream);
                leftF0CartStream.close();
                InputStream midF0CartStream = MaryProperties.needStream(header + ".f0.cart.mid");
                this.f0Carts[1] = new MaryCARTReader().loadFromStream(midF0CartStream);
                midF0CartStream.close();
                InputStream rightF0CartStream = MaryProperties.needStream(header + ".f0.cart.right");
                this.f0Carts[2] = new MaryCARTReader().loadFromStream(rightF0CartStream);
                rightF0CartStream.close();
            }
        }
        catch (MaryConfigurationException mce) {
            throw mce;
        }
        catch (Exception ex) {
            throw new MaryConfigurationException("Cannot build unit selection voice '" + name + "'", (Throwable)ex);
        }
    }

    public UnitDatabase getDatabase() {
        return this.database;
    }

    public UnitSelector getUnitSelector() {
        return this.unitSelector;
    }

    public UnitConcatenator getConcatenator() {
        return this.concatenator;
    }

    public UnitConcatenator getModificationConcatenator() {
        if (this.modificationConcatenator == null) {
            try {
                double minTimeScaleFactor = Double.parseDouble(MaryProperties.getProperty("voice." + this.name + ".prosody.modification.duration.factor.minimum"));
                double maxTimeScaleFactor = Double.parseDouble(MaryProperties.getProperty("voice." + this.name + ".prosody.modification.duration.factor.maximum"));
                double minPitchScaleFactor = Double.parseDouble(MaryProperties.getProperty("voice." + this.name + ".prosody.modification.f0.factor.minimum"));
                double maxPitchScaleFactor = Double.parseDouble(MaryProperties.getProperty("voice." + this.name + ".prosody.modification.f0.factor.maximum"));
                logger.debug((Object)"Initializing FD-PSOLA unit concatenator with the following parameter thresholds:");
                logger.debug((Object)("minimum duration modification factor: " + minTimeScaleFactor));
                logger.debug((Object)("maximum duration modification factor: " + maxTimeScaleFactor));
                logger.debug((Object)("minimum F0 modification factor: " + minPitchScaleFactor));
                logger.debug((Object)("maximum F0 modification factor: " + maxPitchScaleFactor));
                this.modificationConcatenator = new FdpsolaUnitConcatenator(minTimeScaleFactor, maxTimeScaleFactor, minPitchScaleFactor, maxPitchScaleFactor);
            }
            catch (Exception e) {
                logger.debug((Object)"Initializing FD-PSOLA unit concatenator with default parameter thresholds.");
                this.modificationConcatenator = new FdpsolaUnitConcatenator();
            }
            this.modificationConcatenator.load(this.database);
        }
        return this.modificationConcatenator;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getExampleText() {
        if (this.exampleText == null) {
            return "";
        }
        return this.exampleText;
    }

    public void readExampleText(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("***")) {
                sb.append(line + "\n");
            }
            line = reader.readLine();
        }
        this.exampleText = sb.toString();
    }

    public CART[] getF0Trees() {
        return this.f0Carts;
    }

    public FeatureDefinition getF0CartsFeatDef() {
        if (this.f0Carts == null || this.f0Carts.length < 1) {
            return null;
        }
        return this.f0Carts[0].getFeatureDefinition();
    }
}

