/*
 * Decompiled with CFR 0.152.
 */
package marytts.server.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.modules.synthesis.Voice;
import marytts.server.http.BaseHttpRequestHandler;
import marytts.server.http.MaryHttpServerUtils;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.http.Address;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.NStringEntity;

public class InfoRequestHandler
extends BaseHttpRequestHandler {
    @Override
    protected void handleClientRequest(String absPath, Map<String, String> queryItems, HttpResponse response, Address serverAddressAtClient) throws IOException {
        String infoResponse = this.handleInfoRequest(absPath, queryItems, response);
        if (infoResponse == null) {
            return;
        }
        response.setStatusCode(200);
        try {
            NStringEntity entity = new NStringEntity(infoResponse, "UTF-8");
            entity.setContentType("text/plain; charset=UTF-8");
            response.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    private String handleInfoRequest(String absPath, Map<String, String> queryItems, HttpResponse response) {
        String effect;
        String voice;
        logger.debug((Object)("New info request: " + absPath));
        if (queryItems != null) {
            for (String key : queryItems.keySet()) {
                logger.debug((Object)("    " + key + "=" + queryItems.get(key)));
            }
        }
        assert (absPath.startsWith("/")) : "Absolute path '" + absPath + "' does not start with a slash!";
        String request = absPath.substring(1);
        if (request.equals("version")) {
            return MaryRuntimeUtils.getMaryVersion();
        }
        if (request.equals("datatypes")) {
            return MaryRuntimeUtils.getDataTypes();
        }
        if (request.equals("locales")) {
            return MaryRuntimeUtils.getLocales();
        }
        if (request.equals("voices")) {
            return MaryRuntimeUtils.getVoices();
        }
        if (request.equals("audioformats")) {
            return MaryRuntimeUtils.getAudioFileFormatTypes();
        }
        if (request.equals("exampletext")) {
            if (queryItems != null) {
                voice = queryItems.get("voice");
                if (voice != null) {
                    return MaryRuntimeUtils.getVoiceExampleText(voice);
                }
                String datatype = queryItems.get("datatype");
                String locale = queryItems.get("locale");
                if (datatype != null && locale != null) {
                    Locale loc = MaryUtils.string2locale((String)locale);
                    return MaryRuntimeUtils.getExampleText(datatype, loc);
                }
            }
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'datatype' and 'locale' or 'voice'");
            return null;
        }
        if (request.equals("audioeffects")) {
            return MaryRuntimeUtils.getDefaultAudioEffects();
        }
        if (request.equals("audioeffect-default-param")) {
            if (queryItems != null && (effect = queryItems.get("effect")) != null) {
                return MaryRuntimeUtils.getAudioEffectDefaultParam(effect);
            }
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'effect'");
            return null;
        }
        if (request.equals("audioeffect-full")) {
            if (queryItems != null) {
                effect = queryItems.get("effect");
                String params = queryItems.get("params");
                if (effect != null && params != null) {
                    return MaryRuntimeUtils.getFullAudioEffect(effect, params);
                }
            }
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'effect' and 'params'");
            return null;
        }
        if (request.equals("audioeffect-help")) {
            if (queryItems != null && (effect = queryItems.get("effect")) != null) {
                return MaryRuntimeUtils.getAudioEffectHelpText(effect);
            }
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'effect'");
            return null;
        }
        if (request.equals("audioeffect-is-hmm-effect")) {
            if (queryItems != null && (effect = queryItems.get("effect")) != null) {
                return MaryRuntimeUtils.isHmmAudioEffect(effect);
            }
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'effect'");
            return null;
        }
        if (request.equals("features") || request.equals("features-discrete")) {
            if (queryItems != null) {
                FeatureProcessorManager mgr = null;
                String voiceName = queryItems.get("voice");
                String localeName = queryItems.get("locale");
                if (voiceName != null) {
                    Voice voice2 = Voice.getVoice(voiceName);
                    if (voice2 == null) {
                        MaryHttpServerUtils.errorWrongQueryParameterValue(response, "voice", voiceName, "No voice with that name");
                        return null;
                    }
                    mgr = FeatureRegistry.getFeatureProcessorManager(voice2);
                    if (mgr == null) {
                        mgr = FeatureRegistry.getFeatureProcessorManager(voice2.getLocale());
                    }
                    if (mgr == null) {
                        mgr = FeatureRegistry.getFeatureProcessorManager(new Locale(voice2.getLocale().getLanguage()));
                    }
                    if (mgr == null) {
                        mgr = FeatureRegistry.getFallbackFeatureProcessorManager();
                    }
                } else if (localeName != null) {
                    Locale locale = MaryUtils.string2locale((String)localeName);
                    mgr = FeatureRegistry.getFeatureProcessorManager(locale);
                    if (mgr == null) {
                        mgr = FeatureRegistry.getFeatureProcessorManager(new Locale(locale.getLanguage()));
                    }
                    if (mgr == null) {
                        StringBuilder localeList = new StringBuilder();
                        for (Locale l : FeatureRegistry.getSupportedLocales()) {
                            if (localeList.length() > 0) {
                                localeList.append(",");
                            }
                            localeList.append(l.toString());
                        }
                        MaryHttpServerUtils.errorWrongQueryParameterValue(response, "locale", localeName, "The locale is not supported.<br />Supported locales: <code>" + localeList + "</code>");
                        return null;
                    }
                }
                if (mgr != null && request.equals("features-discrete")) {
                    String discreteFeatureNames = mgr.listByteValuedFeatureProcessorNames() + mgr.listShortValuedFeatureProcessorNames();
                    return discreteFeatureNames;
                }
                return mgr.listFeatureProcessorNames();
            }
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'voice' or 'locale'");
            return null;
        }
        if (request.equals("vocalizations")) {
            if (queryItems != null && (voice = queryItems.get("voice")) != null) {
                return MaryRuntimeUtils.getVocalizations(voice);
            }
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'voice'");
            return null;
        }
        if (request.equals("styles")) {
            if (queryItems != null && (voice = queryItems.get("voice")) != null) {
                return MaryRuntimeUtils.getStyles(voice);
            }
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'voice'");
            return null;
        }
        MaryHttpServerUtils.errorFileNotFound(response, request);
        return null;
    }
}

