/*
 * Decompiled with CFR 0.152.
 */
package marytts.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import marytts.config.MaryConfig;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.NoSuchPropertyException;
import org.apache.commons.lang.StringUtils;

public class MaryProperties {
    public static String maryBase() {
        return MaryProperties.getFilename("mary.base", ".");
    }

    public static List<String> getList(String propName) {
        assert (propName.endsWith(".list"));
        ArrayList<String> vals = new ArrayList<String>();
        String val = System.getProperty(propName);
        if (val != null) {
            vals.addAll(Arrays.asList(StringUtils.split((String)val)));
        }
        for (MaryConfig mc : MaryConfig.getConfigs()) {
            vals.addAll(mc.getList(propName));
        }
        return vals;
    }

    public static String getProperty(String property, String defaultValue) {
        String val = System.getProperty(property);
        if (val != null) {
            return val;
        }
        for (MaryConfig mc : MaryConfig.getConfigs()) {
            val = mc.getProperties().getProperty(property);
            if (val == null) continue;
            return val;
        }
        return defaultValue;
    }

    public static List<String> moduleInitInfo() {
        return MaryProperties.getList("modules.classes.list");
    }

    public static List<String> synthesizerClasses() {
        return MaryProperties.getList("synthesizers.classes.list");
    }

    public static Vector<String> effectClasses() {
        return new Vector<String>(MaryProperties.getList("audioeffects.classes.list"));
    }

    private static String expandPath(String path) {
        String MARY_BASE = "MARY_BASE";
        StringBuilder buf = null;
        if (path.startsWith("MARY_BASE")) {
            buf = new StringBuilder(MaryProperties.maryBase());
            buf.append(path.substring("MARY_BASE".length()));
        } else {
            buf = new StringBuilder(path);
        }
        if (File.separator.equals("/")) {
            int i = -1;
            while ((i = buf.indexOf("\\")) != -1) {
                buf.replace(i, i + 1, "/");
            }
        } else if (File.separator.equals("\\")) {
            int i = -1;
            while ((i = buf.indexOf("/")) != -1) {
                buf.replace(i, i + 1, "\\");
            }
        } else {
            throw new Error("Unexpected File.separator: `" + File.separator + "'");
        }
        return buf.toString();
    }

    public static String getProperty(String property) {
        return MaryProperties.getProperty(property, null);
    }

    public static boolean getBoolean(String property) {
        return MaryProperties.getBoolean(property, false);
    }

    public static boolean getAutoBoolean(String property) {
        return MaryProperties.getAutoBoolean(property, false);
    }

    public static int getInteger(String property) {
        return MaryProperties.getInteger(property, -1);
    }

    public static String getFilename(String property) {
        return MaryProperties.getFilename(property, null);
    }

    public static boolean getBoolean(String property, boolean defaultValue) {
        String value = MaryProperties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean getAutoBoolean(String property, boolean defaultValue) {
        String value = MaryProperties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("auto")) {
            return !MaryProperties.getProperty("server").equals("commandline");
        }
        return MaryProperties.getBoolean(property, defaultValue);
    }

    public static int getInteger(String property, int defaultValue) {
        String value = MaryProperties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String getFilename(String property, String defaultValue) {
        String filename = MaryProperties.getProperty(property);
        if (filename == null) {
            return defaultValue;
        }
        return MaryProperties.expandPath(filename);
    }

    public static String needProperty(String property) throws NoSuchPropertyException {
        String value = MaryProperties.getProperty(property);
        if (value == null) {
            throw new NoSuchPropertyException("Missing value `" + property + "' in configuration files");
        }
        return value;
    }

    public static boolean needBoolean(String property) throws NoSuchPropertyException {
        String value = MaryProperties.getProperty(property);
        if (value == null) {
            throw new NoSuchPropertyException("Missing property `" + property + "' in configuration files");
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new NoSuchPropertyException("Boolean property `" + property + "' in configuration files has wrong value `" + value + "'");
        }
    }

    public static boolean needAutoBoolean(String property) throws NoSuchPropertyException {
        String value = MaryProperties.getProperty(property);
        if (value == null) {
            throw new NoSuchPropertyException("Missing property `" + property + "' in configuration files");
        }
        if (value.equals("auto")) {
            return !MaryProperties.needProperty("server").equals("commandline");
        }
        return MaryProperties.needBoolean(property);
    }

    public static int needInteger(String property) throws NoSuchPropertyException {
        String value = MaryProperties.getProperty(property);
        if (value == null) {
            throw new NoSuchPropertyException("Missing property `" + property + "' in configuration files");
        }
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException e) {
            throw new NoSuchPropertyException("Integer property `" + property + "' in configuration files has wrong value `" + value + "'");
        }
    }

    public static String needFilename(String property) throws NoSuchPropertyException {
        String filename = MaryProperties.expandPath(MaryProperties.needProperty(property));
        if (!new File(filename).canRead()) {
            throw new NoSuchPropertyException("Cannot read file `" + filename + "'. Check property `" + property + "' in configuration files");
        }
        return filename;
    }

    public static InputStream needStream(String propertyName) throws NoSuchPropertyException, FileNotFoundException, MaryConfigurationException {
        MaryProperties.needProperty(propertyName);
        return MaryProperties.getStream(propertyName);
    }

    public static InputStream getStream(String propertyName) throws FileNotFoundException, MaryConfigurationException {
        InputStream stream;
        String propertyValue = MaryProperties.getProperty(propertyName);
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue.startsWith("jar:")) {
            String classpathLocation = propertyValue.substring("jar:".length());
            stream = MaryProperties.class.getResourceAsStream(classpathLocation);
            if (stream == null) {
                throw new MaryConfigurationException("For property '" + propertyName + "', no classpath resource available at '" + classpathLocation + "'");
            }
        } else {
            String fileName = MaryProperties.getFilename(propertyName);
            stream = new FileInputStream(fileName);
        }
        return stream;
    }

    public static Class needClass(String property) throws NoSuchPropertyException {
        String value = MaryProperties.needProperty(property);
        Class<?> c = null;
        try {
            c = Class.forName(value);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchPropertyException("Cannot find class `" + value + "'. Check property `" + property + "' in configuration files");
        }
        return c;
    }

    public static String localePrefix(Locale locale) {
        if (locale == null) {
            return null;
        }
        return locale.toString();
    }
}

