/*
 * Decompiled with CFR 0.152.
 */
package marytts.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import marytts.Version;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.modules.MaryModule;
import marytts.modules.ModuleRegistry;
import marytts.modules.Synthesis;
import marytts.modules.synthesis.Voice;
import marytts.server.EnvironmentChecks;
import marytts.server.MaryProperties;
import marytts.server.Request;
import marytts.util.MaryCache;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.Pair;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Mary {
    public static final int STATE_OFF = 0;
    public static final int STATE_STARTING = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_SHUTTING_DOWN = 3;
    private static Logger logger;
    private static int currentState;
    private static boolean jarsAdded;

    public static int currentState() {
        return currentState;
    }

    protected static void addJarsToClasspath() throws Exception {
    }

    private static void startModules() throws ClassNotFoundException, InstantiationException, Exception {
        for (String moduleClassName : MaryProperties.moduleInitInfo()) {
            MaryModule m = ModuleRegistry.instantiateModule(moduleClassName);
            ModuleRegistry.registerModule(m, m.getLocale(), null);
        }
        ModuleRegistry.setRegistrationComplete();
        ArrayList<Pair> startupTimes = new ArrayList<Pair>();
        for (MaryModule m : ModuleRegistry.getAllModules()) {
            if ((!MaryProperties.getProperty("server").equals("commandline") || m instanceof Synthesis) && m.getState() == 0) {
                long before = System.currentTimeMillis();
                try {
                    m.startup();
                }
                catch (Throwable t) {
                    throw new Exception("Problem starting module " + m.name(), t);
                }
                long after = System.currentTimeMillis();
                startupTimes.add(new Pair((Object)m, (Object)(after - before)));
            }
            if (!MaryProperties.getAutoBoolean("modules.poweronselftest", false)) continue;
            m.powerOnSelfTest();
        }
        if (startupTimes.size() > 0) {
            Collections.sort(startupTimes, new Comparator<Pair<MaryModule, Long>>(){

                @Override
                public int compare(Pair<MaryModule, Long> o1, Pair<MaryModule, Long> o2) {
                    return -((Long)o1.getSecond()).compareTo((Long)o2.getSecond());
                }
            });
            logger.debug((Object)"Startup times:");
            for (Pair p : startupTimes) {
                logger.debug((Object)(((MaryModule)p.getFirst()).name() + ": " + p.getSecond() + " ms"));
            }
        }
    }

    private static void setupFeatureProcessors() throws Exception {
        for (String fpmInitInfo : MaryProperties.getList("featuremanager.classes.list")) {
            try {
                FeatureProcessorManager mgr = (FeatureProcessorManager)MaryRuntimeUtils.instantiateObject(fpmInitInfo);
                Locale locale = mgr.getLocale();
                if (locale != null) {
                    FeatureRegistry.setFeatureProcessorManager(locale, mgr);
                    continue;
                }
                logger.debug((Object)("Setting fallback feature processor manager to '" + fpmInitInfo + "'"));
                FeatureRegistry.setFallbackFeatureProcessorManager(mgr);
            }
            catch (Throwable t) {
                throw new Exception("Cannot instantiate feature processor manager '" + fpmInitInfo + "'", t);
            }
        }
    }

    public static void startup() throws Exception {
        Mary.startup(true);
    }

    public static void startup(boolean addJarsToClasspath) throws Exception {
        if (currentState != 0) {
            throw new IllegalStateException("Cannot start system: it is not offline");
        }
        currentState = 1;
        if (addJarsToClasspath) {
            Mary.addJarsToClasspath();
        }
        Mary.configureLogging();
        logger.info((Object)"Mary starting up...");
        logger.info((Object)("Specification version " + Version.specificationVersion()));
        logger.info((Object)("Implementation version " + Version.implementationVersion()));
        logger.info((Object)("Running on a Java " + System.getProperty("java.version") + " implementation by " + System.getProperty("java.vendor") + ", on a " + System.getProperty("os.name") + " platform (" + System.getProperty("os.arch") + ", " + System.getProperty("os.version") + ")"));
        logger.debug((Object)("MARY_BASE: " + MaryProperties.maryBase()));
        String[] installedFilenames = new File(MaryProperties.maryBase() + "/installed").list();
        if (installedFilenames == null) {
            logger.debug((Object)"The installed/ folder does not exist.");
        } else {
            StringBuilder installedMsg = new StringBuilder();
            for (String filename : installedFilenames) {
                if (installedMsg.length() > 0) {
                    installedMsg.append(", ");
                }
                installedMsg.append(filename);
            }
            logger.debug((Object)("Content of installed/ folder: " + installedMsg));
        }
        String[] confFilenames = new File(MaryProperties.maryBase() + "/conf").list();
        if (confFilenames == null) {
            logger.debug((Object)"The conf/ folder does not exist.");
        } else {
            StringBuilder confMsg = new StringBuilder();
            for (String filename : confFilenames) {
                if (confMsg.length() > 0) {
                    confMsg.append(", ");
                }
                confMsg.append(filename);
            }
            logger.debug((Object)("Content of conf/ folder: " + confMsg));
        }
        logger.debug((Object)"Full dump of system properties:");
        for (Object e : new TreeSet<Object>(System.getProperties().keySet())) {
            logger.debug((Object)(e + " = " + System.getProperties().get(e)));
        }
        logger.debug((Object)"XML libraries used:");
        logger.debug((Object)("DocumentBuilderFactory: " + DocumentBuilderFactory.newInstance().getClass()));
        try {
            Class<?> xercesVersion = Class.forName("org.apache.xerces.impl.Version");
            logger.debug(xercesVersion.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug((Object)("TransformerFactory:     " + TransformerFactory.newInstance().getClass()));
        EnvironmentChecks.check();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Mary.shutdown();
            }
        });
        Mary.setupFeatureProcessors();
        Mary.startModules();
        logger.info((Object)"Startup complete.");
        currentState = 2;
    }

    private static void configureLogging() throws MaryConfigurationException, IOException {
        if (!MaryUtils.isLog4jConfigured()) {
            Properties logprops = new Properties();
            BufferedInputStream propIS = new BufferedInputStream(MaryProperties.needStream("log.config"));
            logprops.load(propIS);
            ((InputStream)propIS).close();
            for (Object key : logprops.keySet()) {
                String val = (String)logprops.get(key);
                if (!val.contains("MARY_BASE")) continue;
                String maryBase = MaryProperties.maryBase();
                if (maryBase.contains("\\")) {
                    maryBase = maryBase.replaceAll("\\\\", "/");
                }
                val = val.replaceAll("MARY_BASE", maryBase);
                logprops.put(key, val);
            }
            String loggerMaryttsKey = "log4j.logger.marytts";
            String loggerMaryttsValue = MaryProperties.getProperty(loggerMaryttsKey);
            if (loggerMaryttsValue != null) {
                logprops.setProperty(loggerMaryttsKey, loggerMaryttsValue);
            }
            PropertyConfigurator.configure((Properties)logprops);
        }
        logger = MaryUtils.getLogger((String)"main");
    }

    public static void shutdown() {
        if (currentState != 2) {
            throw new IllegalStateException("MARY system is not running");
        }
        currentState = 3;
        logger.info((Object)"Shutting down modules...");
        for (MaryModule m : ModuleRegistry.getAllModules()) {
            if (m.getState() != 1) continue;
            m.shutdown();
        }
        if (MaryCache.haveCache()) {
            MaryCache cache = MaryCache.getCache();
            try {
                cache.shutdown();
            }
            catch (SQLException e) {
                logger.warn((Object)"Cannot shutdown cache: ", (Throwable)e);
            }
        }
        logger.info((Object)"Shutdown complete.");
        currentState = 0;
    }

    public static void process(String input, String inputTypeName, String outputTypeName, String localeString, String audioTypeName, String voiceName, String style, String effects, String outputTypeParams, OutputStream output) throws Exception {
        if (currentState != 2) {
            throw new IllegalStateException("MARY system is not running");
        }
        MaryDataType inputType = MaryDataType.get(inputTypeName);
        MaryDataType outputType = MaryDataType.get(outputTypeName);
        Locale locale = MaryUtils.string2locale((String)localeString);
        Voice voice = null;
        if (voiceName != null) {
            voice = Voice.getVoice(voiceName);
        }
        AudioFileFormat audioFileFormat = null;
        AudioFileFormat.Type audioType = null;
        if (audioTypeName != null) {
            audioType = MaryAudioUtils.getAudioFileFormatType((String)audioTypeName);
            AudioFormat audioFormat = null;
            audioFormat = audioTypeName.equals("MP3") ? MaryRuntimeUtils.getMP3AudioFormat() : (audioTypeName.equals("Vorbis") ? MaryRuntimeUtils.getOggAudioFormat() : (voice != null ? voice.dbAudioFormat() : Voice.AF22050));
            audioFileFormat = new AudioFileFormat(audioType, audioFormat, -1);
        }
        Request request = new Request(inputType, outputType, locale, voice, effects, style, 1, audioFileFormat, false, outputTypeParams);
        request.setInputData(input);
        request.process();
        request.writeOutputData(output);
    }

    public static void main(final String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        Mary.addJarsToClasspath();
        String server = MaryProperties.needProperty("server");
        System.err.print("MARY server " + Version.specificationVersion() + " starting as a ");
        if (server.equals("socket")) {
            System.err.print("socket server...");
        } else if (server.equals("http")) {
            System.err.print("HTTP server...");
        } else {
            System.err.print("command-line application...");
        }
        if (!server.equals("commandline")) {
            int localPort = MaryProperties.needInteger("socket.port");
            try {
                ServerSocket serverSocket = new ServerSocket(localPort);
                serverSocket.close();
            }
            catch (IOException e) {
                System.err.println("\nPort " + localPort + " already in use!");
                throw e;
            }
        }
        Mary.startup();
        System.err.println(" started in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " s");
        Runnable main = null;
        main = server.equals("socket") ? (Runnable)Class.forName("marytts.server.MaryServer").newInstance() : (server.equals("http") ? (Runnable)Class.forName("marytts.server.http.MaryHttpServer").newInstance() : new Runnable(){

            @Override
            public void run() {
                try {
                    InputStream inputStream = args.length == 0 || args[0].equals("-") ? System.in : new FileInputStream(args[0]);
                    String input = FileUtils.getStreamAsString((InputStream)inputStream, (String)"UTF-8");
                    Mary.process(input, MaryProperties.getProperty("input.type", "TEXT"), MaryProperties.getProperty("output.type", "AUDIO"), MaryProperties.getProperty("locale", "en_US"), MaryProperties.getProperty("audio.type", "WAVE"), MaryProperties.getProperty("voice", null), MaryProperties.getProperty("style", null), MaryProperties.getProperty("effect", null), MaryProperties.getProperty("output.type.params", null), System.out);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        main.run();
    }

    static {
        currentState = 0;
        jarsAdded = false;
    }
}

