/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.synthesis;

import com.sun.speech.freetts.en.us.CMULexicon;
import com.sun.speech.freetts.lexicon.Lexicon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.cart.DirectedGraph;
import marytts.cart.io.DirectedGraphReader;
import marytts.config.MaryConfig;
import marytts.config.VoiceConfig;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.NoSuchPropertyException;
import marytts.exceptions.SynthesisException;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.modules.MaryModule;
import marytts.modules.ModuleRegistry;
import marytts.modules.acoustic.BoundaryModel;
import marytts.modules.acoustic.CARTModel;
import marytts.modules.acoustic.HMMModel;
import marytts.modules.acoustic.Model;
import marytts.modules.acoustic.ModelType;
import marytts.modules.acoustic.SoPModel;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.FreeTTSVoices;
import marytts.modules.synthesis.WaveformSynthesizer;
import marytts.server.MaryProperties;
import marytts.unitselection.data.FeatureFileReader;
import marytts.unitselection.interpolation.InterpolatingSynthesizer;
import marytts.unitselection.interpolation.InterpolatingVoice;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.vocalizations.VocalizationSynthesizer;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class Voice {
    public static final Gender MALE = new Gender("male");
    public static final Gender FEMALE = new Gender("female");
    public static final AudioFormat AF16000 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, !System.getProperty("os.arch").equals("x86") && !System.getProperty("os.arch").equals("i386") && !System.getProperty("os.arch").equals("amd64"));
    public static final AudioFormat AF16000BE = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, true);
    public static final AudioFormat AF22050 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, !System.getProperty("os.arch").equals("x86") && !System.getProperty("os.arch").equals("i386"));
    private static Set<Voice> allVoices = new TreeSet<Voice>(new Comparator<Voice>(){

        @Override
        public int compare(Voice v1, Voice v2) {
            int desireDelta = v2.wantToBeDefault - v1.wantToBeDefault;
            if (desireDelta != 0) {
                return desireDelta;
            }
            return v2.getName().compareTo(v1.getName());
        }
    });
    private static Map<Locale, Voice> defaultVoices = new HashMap<Locale, Voice>();
    protected static Logger logger = MaryUtils.getLogger((String)"Voice");
    private static Map<String, Lexicon> lexicons = new HashMap<String, Lexicon>();
    private String voiceName;
    private Locale locale;
    private AudioFormat dbAudioFormat = null;
    private WaveformSynthesizer synthesizer;
    private Gender gender;
    private int wantToBeDefault;
    private AllophoneSet allophoneSet;
    String preferredModulesClasses;
    private Vector<MaryModule> preferredModules;
    private Lexicon lexicon;
    private boolean vocalizationSupport;
    private VocalizationSynthesizer vocalizationSynthesizer;
    protected DirectedGraph durationGraph;
    protected DirectedGraph f0Graph;
    protected FeatureFileReader f0ContourFeatures;
    protected Map<String, Model> acousticModels;

    @Deprecated
    public Voice(String name, Locale locale, AudioFormat dbAudioFormat, WaveformSynthesizer synthesizer, Gender gender) throws MaryConfigurationException {
        this.voiceName = name;
        this.locale = locale;
        this.dbAudioFormat = dbAudioFormat;
        this.synthesizer = synthesizer;
        this.gender = gender;
        try {
            this.init();
        }
        catch (Exception n) {
            throw new MaryConfigurationException("Cannot instantiate voice '" + this.voiceName + "'", (Throwable)n);
        }
    }

    public Voice(String name, WaveformSynthesizer synthesizer) throws MaryConfigurationException {
        this.voiceName = name;
        this.synthesizer = synthesizer;
        VoiceConfig config = MaryConfig.getVoiceConfig(this.voiceName);
        if (config == null) {
            throw new MaryConfigurationException("Trying to load config for voice '" + this.voiceName + "' but cannot find it.");
        }
        this.locale = config.getLocale();
        int samplingRate = MaryProperties.getInteger("voice." + this.voiceName + ".samplingRate", 16000);
        this.dbAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, samplingRate, 16, 1, 2, samplingRate, false);
        this.gender = new Gender(MaryProperties.needProperty("voice." + this.voiceName + ".gender"));
        try {
            this.init();
        }
        catch (Exception n) {
            throw new MaryConfigurationException("Cannot instantiate voice '" + this.voiceName + "'", (Throwable)n);
        }
    }

    private void init() throws MaryConfigurationException, NoSuchPropertyException, IOException {
        String header = "voice." + this.getName();
        this.wantToBeDefault = MaryProperties.getInteger(header + ".wants.to.be.default", 0);
        try {
            this.allophoneSet = MaryRuntimeUtils.needAllophoneSet(header + ".allophoneset");
        }
        catch (MaryConfigurationException e) {
            try {
                this.allophoneSet = MaryRuntimeUtils.needAllophoneSet(MaryProperties.localePrefix(this.getLocale()) + ".allophoneset");
            }
            catch (MaryConfigurationException e2) {
                throw new MaryConfigurationException("No allophone set specified -- neither for voice '" + this.getName() + "' nor for locale '" + this.getLocale() + "'", (Throwable)e2);
            }
        }
        this.preferredModulesClasses = MaryProperties.getProperty(header + ".preferredModules");
        String lexiconClass = MaryProperties.getProperty(header + ".lexiconClass");
        String lexiconName = MaryProperties.getProperty(header + ".lexicon");
        this.lexicon = Voice.getLexicon(lexiconClass, lexiconName);
        this.vocalizationSupport = MaryProperties.getBoolean(header + ".vocalizationSupport", false);
        if (this.vocalizationSupport) {
            this.vocalizationSynthesizer = new VocalizationSynthesizer(this);
        }
        this.loadOldStyleProsodyModels(header);
        this.loadAcousticModels(header);
        this.initFeatureProcessorManager();
    }

    @Deprecated
    private void loadOldStyleProsodyModels(String header) throws MaryConfigurationException {
        this.durationGraph = null;
        String durationGraphFile = MaryProperties.getFilename(header + ".duration.cart");
        if (durationGraphFile != null) {
            logger.debug((Object)"...loading duration graph...");
            try {
                this.durationGraph = new DirectedGraphReader().load(durationGraphFile);
            }
            catch (IOException e) {
                throw new MaryConfigurationException("Cannot load duration graph file '" + durationGraphFile + "'", (Throwable)e);
            }
        }
        this.f0Graph = null;
        String f0GraphFile = MaryProperties.getFilename(header + ".f0.graph");
        if (f0GraphFile != null) {
            logger.debug((Object)"...loading f0 contour graph...");
            try {
                this.f0Graph = new DirectedGraphReader().load(f0GraphFile);
                String f0ContourFile = MaryProperties.needFilename(header + ".f0.contours");
                this.f0ContourFeatures = new FeatureFileReader(f0ContourFile);
            }
            catch (IOException e) {
                throw new MaryConfigurationException("Cannot load f0 contour graph file '" + f0GraphFile + "'", (Throwable)e);
            }
        }
    }

    private void loadAcousticModels(String header) throws MaryConfigurationException, NoSuchPropertyException, IOException {
        FeatureProcessorManager symbolicFPM = FeatureRegistry.determineBestFeatureProcessorManager(this.getLocale());
        String acousticModelsString = MaryProperties.getProperty(header + ".acousticModels");
        if (acousticModelsString != null) {
            this.acousticModels = new HashMap<String, Model>();
            this.acousticModels.put("boundary", new BoundaryModel(symbolicFPM, this.voiceName, null, "duration", null, null, null, "boundaries"));
            StringTokenizer acousticModelStrings = new StringTokenizer(acousticModelsString);
            do {
                String modelName = acousticModelStrings.nextToken();
                String modelType = MaryProperties.needProperty(header + "." + modelName + ".model");
                InputStream modelDataStream = MaryProperties.getStream(header + "." + modelName + ".data");
                String modelAttributeName = MaryProperties.needProperty(header + "." + modelName + ".attribute");
                String modelAttributeFormat = MaryProperties.getProperty(header + "." + modelName + ".attribute.format");
                String modelFeatureName = MaryProperties.getProperty(header + "." + modelName + ".feature");
                String modelPredictFrom = MaryProperties.getProperty(header + "." + modelName + ".predictFrom");
                String modelApplyTo = MaryProperties.getProperty(header + "." + modelName + ".applyTo");
                ModelType possibleModelTypes = ModelType.fromString(modelType);
                if (possibleModelTypes == null) {
                    throw new MaryConfigurationException("Cannot handle unknown model type: " + modelType);
                }
                Model model = null;
                try {
                    switch (possibleModelTypes) {
                        case CART: {
                            model = new CARTModel(symbolicFPM, this.voiceName, modelDataStream, modelAttributeName, modelAttributeFormat, modelFeatureName, modelPredictFrom, modelApplyTo);
                            break;
                        }
                        case SOP: {
                            model = new SoPModel(symbolicFPM, this.voiceName, modelDataStream, modelAttributeName, modelAttributeFormat, modelFeatureName, modelPredictFrom, modelApplyTo);
                            break;
                        }
                        case HMM: {
                            if (this.getDurationModel() != null && this.getDurationModel() instanceof HMMModel && modelName.equalsIgnoreCase("F0") && this.voiceName.equals(this.getDurationModel().getVoiceName())) {
                                model = this.getDurationModel();
                                ((HMMModel)model).setPredictDurAndF0(true);
                                break;
                            }
                            if (this.getF0Model() != null && this.getF0Model() instanceof HMMModel && modelName.equalsIgnoreCase("duration") && this.voiceName.equals(this.getF0Model().getVoiceName())) {
                                model = this.getF0Model();
                                ((HMMModel)model).setPredictDurAndF0(true);
                                break;
                            }
                            model = new HMMModel(symbolicFPM, this.voiceName, modelDataStream, modelAttributeName, modelAttributeFormat, modelFeatureName, modelPredictFrom, modelApplyTo);
                        }
                    }
                }
                catch (Throwable t) {
                    throw new MaryConfigurationException("Cannot instantiate model '" + modelName + "' of type '" + modelType + "' from '" + MaryProperties.getProperty(header + "." + modelName + ".data") + "'", t);
                }
                assert (model != null);
                this.acousticModels.put(modelName, model);
            } while (acousticModelStrings.hasMoreTokens());
        }
    }

    private void initFeatureProcessorManager() throws MaryConfigurationException {
        FeatureProcessorManager featMgr = null;
        String keyVoiceFeatMgr = "voice." + this.getName() + ".featuremanager";
        String featMgrClass = MaryProperties.getProperty(keyVoiceFeatMgr);
        if (featMgrClass != null) {
            try {
                featMgr = (FeatureProcessorManager)Class.forName(featMgrClass).newInstance();
            }
            catch (Exception e) {
                throw new MaryConfigurationException("Cannot initialise voice-specific FeatureProcessorManager " + featMgrClass + " from config file", (Throwable)e);
            }
        }
        if (this.getOtherModels() != null) {
            FeatureProcessorManager genericFPM = FeatureRegistry.determineBestFeatureProcessorManager(this.locale);
            Class<?> fpmClass = genericFPM.getClass();
            try {
                Constructor<?> fpmVoiceConstructor = fpmClass.getConstructor(Voice.class);
                featMgr = (FeatureProcessorManager)fpmVoiceConstructor.newInstance(this);
            }
            catch (NoSuchMethodException nsme) {
                throw new MaryConfigurationException("Cannot initialise voice-specific FeatureProcessorManager: Class " + fpmClass.getName() + " has no constructor " + fpmClass.getSimpleName() + "(Voice)");
            }
            catch (Exception e) {
                throw new MaryConfigurationException("Cannot initialise voice-specific FeatureProcessorManager", (Throwable)e);
            }
        }
        if (featMgr != null) {
            FeatureRegistry.setFeatureProcessorManager(this, featMgr);
        }
    }

    public AllophoneSet getAllophoneSet() {
        return this.allophoneSet;
    }

    @Deprecated
    public Allophone getAllophone(String phoneSymbol) {
        return this.allophoneSet.getAllophone(phoneSymbol);
    }

    public synchronized Vector<MaryModule> getPreferredModulesAcceptingType(MaryDataType type) {
        if (this.preferredModules == null && this.preferredModulesClasses != null) {
            this.preferredModules = new Vector();
            StringTokenizer st = new StringTokenizer(this.preferredModulesClasses);
            while (st.hasMoreTokens()) {
                String moduleInfo = st.nextToken();
                try {
                    MaryModule mm = null;
                    if (!moduleInfo.contains("(")) {
                        mm = ModuleRegistry.getModule(Class.forName(moduleInfo));
                    }
                    if (mm == null) {
                        logger.warn((Object)("Module " + moduleInfo + " is not in the standard list of modules -- will start our own, but will not be able to shut it down at the end."));
                        mm = ModuleRegistry.instantiateModule(moduleInfo);
                        mm.startup();
                    }
                    this.preferredModules.add(mm);
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot initialise preferred module " + moduleInfo + " for voice " + this.getName() + " -- skipping."), (Throwable)e);
                }
            }
        }
        if (this.preferredModules != null) {
            Vector<MaryModule> v = new Vector<MaryModule>();
            for (MaryModule m : this.preferredModules) {
                if (!m.inputType().equals(type)) continue;
                v.add(m);
            }
            if (v.size() > 0) {
                return v;
            }
            return null;
        }
        return null;
    }

    public boolean hasName(String aName) {
        return this.voiceName.equals(aName);
    }

    public String getName() {
        return this.voiceName;
    }

    public String toString() {
        return this.getName();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public AudioFormat dbAudioFormat() {
        return this.dbAudioFormat;
    }

    public WaveformSynthesizer synthesizer() {
        return this.synthesizer;
    }

    public Gender gender() {
        return this.gender;
    }

    public boolean hasVocalizationSupport() {
        return this.vocalizationSupport;
    }

    public VocalizationSynthesizer getVocalizationSynthesizer() {
        return this.vocalizationSynthesizer;
    }

    public String[] getStyles() {
        if (this.voiceName.equals("dfki-pavoque-styles")) {
            return new String[]{"neutral", "poker", "happy", "angry", "sad"};
        }
        return null;
    }

    public AudioInputStream synthesize(List<Element> tokensAndBoundaries, String outputParams) throws SynthesisException {
        return this.synthesizer.synthesize(tokensAndBoundaries, this, outputParams);
    }

    public Lexicon getLexicon() {
        return this.lexicon;
    }

    public DirectedGraph getDurationGraph() {
        return this.durationGraph;
    }

    public DirectedGraph getF0Graph() {
        return this.f0Graph;
    }

    public FeatureFileReader getF0ContourFeatures() {
        return this.f0ContourFeatures;
    }

    public Map<String, Model> getAcousticModels() {
        return this.acousticModels;
    }

    public Model getDurationModel() {
        if (this.acousticModels == null) {
            return null;
        }
        return this.acousticModels.get("duration");
    }

    public Model getF0Model() {
        if (this.acousticModels == null) {
            return null;
        }
        return this.acousticModels.get("F0");
    }

    public Model getBoundaryModel() {
        if (this.acousticModels == null) {
            return null;
        }
        return this.acousticModels.get("boundary");
    }

    public Map<String, Model> getOtherModels() {
        if (this.acousticModels == null) {
            return null;
        }
        HashMap<String, Model> otherModels = new HashMap<String, Model>();
        for (String modelName : this.acousticModels.keySet()) {
            if (modelName.equals("duration") || modelName.equals("F0") || modelName.equals("boundary")) continue;
            otherModels.put(modelName, this.acousticModels.get(modelName));
        }
        if (otherModels.size() == 0) {
            return null;
        }
        return otherModels;
    }

    public static void registerVoice(Voice voice) {
        if (voice == null) {
            throw new NullPointerException("Cannot register null voice.");
        }
        if (!allVoices.contains(voice)) {
            logger.info((Object)("Registering voice `" + voice.getName() + "': " + voice.gender() + ", locale " + voice.getLocale()));
            allVoices.add(voice);
            try {
                FreeTTSVoices.load(voice);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        Voice.checkIfDefaultVoice(voice);
    }

    private static void checkIfDefaultVoice(Voice voice) {
        Locale locale = voice.getLocale();
        Voice currentDefault = defaultVoices.get(locale);
        if (currentDefault == null || currentDefault.wantToBeDefault < voice.wantToBeDefault) {
            logger.info((Object)("New default voice for locale " + locale + ": " + voice.getName() + " (desire " + voice.wantToBeDefault + ")"));
            defaultVoices.put(locale, voice);
        }
    }

    public static Voice getVoice(String name) {
        for (Voice v : allVoices) {
            if (!v.hasName(name)) continue;
            return v;
        }
        if (InterpolatingVoice.isInterpolatingVoiceName(name)) {
            InterpolatingSynthesizer interpolatingSynthesizer = null;
            for (Voice v : allVoices) {
                if (!(v instanceof InterpolatingVoice)) continue;
                interpolatingSynthesizer = (InterpolatingSynthesizer)v.synthesizer();
                break;
            }
            if (interpolatingSynthesizer == null) {
                return null;
            }
            try {
                Voice v;
                v = new InterpolatingVoice(interpolatingSynthesizer, name);
                Voice.registerVoice(v);
                return v;
            }
            catch (Exception e) {
                logger.warn((Object)"Could not create Interpolating voice:", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static Collection<Voice> getAvailableVoices() {
        return Collections.unmodifiableSet(allVoices);
    }

    public static Collection<Voice> getAvailableVoices(Locale locale) {
        ArrayList<Voice> list = new ArrayList<Voice>();
        for (Voice v : allVoices) {
            if (!MaryUtils.subsumes((Locale)locale, (Locale)v.getLocale())) continue;
            list.add(v);
        }
        return list;
    }

    public static Collection<Voice> getAvailableVoices(WaveformSynthesizer synth) {
        if (synth == null) {
            throw new NullPointerException("Got null WaveformSynthesizer");
        }
        ArrayList<Voice> list = new ArrayList<Voice>();
        for (Voice v : allVoices) {
            if (!synth.equals(v.synthesizer())) continue;
            list.add(v);
        }
        return list;
    }

    public static Collection<Voice> getAvailableVoices(WaveformSynthesizer synth, Locale locale) {
        ArrayList<Voice> list = new ArrayList<Voice>();
        for (Voice v : allVoices) {
            if (!v.synthesizer().equals(synth) || !MaryUtils.subsumes((Locale)locale, (Locale)v.getLocale())) continue;
            list.add(v);
        }
        return list;
    }

    public static Voice getVoice(Locale locale, Gender gender) {
        for (Voice v : allVoices) {
            if (!MaryUtils.subsumes((Locale)locale, (Locale)v.getLocale()) || !v.gender().equals(gender)) continue;
            return v;
        }
        return null;
    }

    public static Voice getVoice(Element voiceElement) {
        if (voiceElement == null || !voiceElement.getTagName().equals("voice")) {
            return null;
        }
        Voice v = null;
        String voiceName = voiceElement.getAttribute("name");
        if (!voiceName.equals("")) {
            v = Voice.getVoice(voiceName);
        }
        if (v == null) {
            String voiceGender = voiceElement.getAttribute("gender");
            Locale locale = MaryUtils.string2locale((String)voiceElement.getOwnerDocument().getDocumentElement().getAttribute("xml:lang"));
            if (locale == null) {
                locale = Locale.GERMAN;
            }
            v = Voice.getVoice(locale, new Gender(voiceGender));
        }
        return v;
    }

    public static Voice getDefaultVoice(Locale locale) {
        Voice v = defaultVoices.get(locale);
        if (v == null) {
            v = Voice.getVoice(locale, FEMALE);
        }
        if (v == null) {
            v = Voice.getVoice(locale, MALE);
        }
        if (v == null) {
            logger.debug((Object)("Could not find default voice for locale " + locale));
        }
        return v;
    }

    public static Voice getSuitableVoice(MaryData d) {
        Locale docLocale = d.getLocale();
        if (docLocale == null && d.getType().isXMLType() && d.getDocument() != null && d.getDocument().getDocumentElement().hasAttribute("xml:lang")) {
            docLocale = MaryUtils.string2locale((String)d.getDocument().getDocumentElement().getAttribute("xml:lang"));
        }
        Voice guessedVoice = null;
        if (docLocale != null) {
            guessedVoice = Voice.getDefaultVoice(docLocale);
        } else if (allVoices.size() != 0) {
            guessedVoice = allVoices.iterator().next();
        }
        if (guessedVoice != null) {
            logger.debug((Object)("Guessing default voice `" + guessedVoice.getName() + "'"));
        } else {
            logger.debug((Object)"Couldn't find any voice at all");
        }
        return guessedVoice;
    }

    private static Lexicon getLexicon(String lexiconClass, String lexiconName) {
        if (lexiconClass == null) {
            return null;
        }
        Lexicon lexicon = null;
        if (lexicons.containsKey(lexiconClass + lexiconName)) {
            return lexicons.get(lexiconClass + lexiconName);
        }
        try {
            logger.debug((Object)"...loading lexicon...");
            if (lexiconName == null) {
                lexicon = (Lexicon)Class.forName(lexiconClass).newInstance();
            } else {
                Class<?> lexCl = Class.forName(lexiconClass);
                Constructor<?> lexConstr = lexCl.getConstructor(String.class);
                lexicon = (Lexicon)lexConstr.newInstance(lexiconName);
                if (lexiconName.equals("cmudict04")) {
                    assert (lexicon instanceof CMULexicon) : "Expected lexicon to be a CMULexicon";
                    String customAddenda = MaryProperties.getFilename("english.lexicon.customAddenda");
                    if (customAddenda != null) {
                        String line;
                        logger.debug((Object)"...loading custom addenda...");
                        lexicon.load();
                        BufferedReader addendaIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(customAddenda)), "UTF-8"));
                        while ((line = addendaIn.readLine()) != null) {
                            if (line.startsWith("#") || line.equals("")) continue;
                            StringTokenizer tok = new StringTokenizer(line);
                            String word = tok.nextToken();
                            int numPhones = tok.countTokens();
                            String[] phones = new String[numPhones];
                            for (int i = 0; i < phones.length; ++i) {
                                phones[i] = tok.nextToken();
                            }
                            ((CMULexicon)lexicon).addAddendum(word, null, phones);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Could not load lexicon " + lexiconClass + "('" + lexiconName + "')"), (Throwable)ex);
        }
        lexicons.put(lexiconClass + lexiconName, lexicon);
        return lexicon;
    }

    public static class Gender {
        String name;

        public Gender(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Gender other) {
            return other.toString().equals(this.name);
        }
    }
}

